/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import kotlin.jvm.functions.Function1;
import org.jetbrains.kotlin.idea.util.UtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.types.JetType;

public class IdeDescriptorRenderers {
    public static final Function1<JetType, JetType> APPROXIMATE_FLEXIBLE_TYPES = new Function1<JetType, JetType>(){

        public JetType invoke(JetType type2) {
            return UtilPackage.approximateFlexibleTypes(type2, true);
        }
    };
    public static final Function1<JetType, JetType> APPROXIMATE_FLEXIBLE_TYPES_IN_ARGUMENTS = new Function1<JetType, JetType>(){

        public JetType invoke(JetType type2) {
            return UtilPackage.approximateFlexibleTypes(type2, false);
        }
    };
    public static final DescriptorRenderer SOURCE_CODE = IdeDescriptorRenderers.commonBuilder().setNameShortness(NameShortness.SOURCE_CODE_QUALIFIED).setTypeNormalizer(APPROXIMATE_FLEXIBLE_TYPES).build();
    public static final DescriptorRenderer SOURCE_CODE_FOR_TYPE_ARGUMENTS = IdeDescriptorRenderers.commonBuilder().setNameShortness(NameShortness.SOURCE_CODE_QUALIFIED).setTypeNormalizer(APPROXIMATE_FLEXIBLE_TYPES_IN_ARGUMENTS).build();
    public static final DescriptorRenderer SOURCE_CODE_SHORT_NAMES_IN_TYPES = IdeDescriptorRenderers.commonBuilder().setNameShortness(NameShortness.SHORT).setTypeNormalizer(APPROXIMATE_FLEXIBLE_TYPES).build();

    private static DescriptorRendererBuilder commonBuilder() {
        return new DescriptorRendererBuilder().setNormalizedVisibilities(true).setWithDefinedIn(false).setShowInternalKeyword(false).setOverrideRenderingPolicy(DescriptorRenderer.OverrideRenderingPolicy.RENDER_OVERRIDE).setUnitReturnType(false);
    }
}

