/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetPluginUtil;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.LibraryPresentationProviderUtil;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtil;

public class OutdatedKotlinRuntimeNotification
extends AbstractProjectComponent {
    private static final String SUPPRESSED_PROPERTY_NAME = "oudtdated.runtime.suppressed.plugin.version";
    private static final String OUTDATED_RUNTIME_GROUP_DISPLAY_ID = "Outdated Kotlin Runtime";

    public OutdatedKotlinRuntimeNotification(Project project) {
        super(project);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                String message;
                final String pluginVersion = JetPluginUtil.getPluginVersion();
                if ("@snapshot@".equals(pluginVersion)) {
                    return;
                }
                if (pluginVersion.equals(PropertiesComponent.getInstance((Project)OutdatedKotlinRuntimeNotification.this.myProject).getValue(OutdatedKotlinRuntimeNotification.SUPPRESSED_PROPERTY_NAME))) {
                    return;
                }
                Collection versionedOutdatedLibraries = OutdatedKotlinRuntimeNotification.findOutdatedKotlinLibraries(OutdatedKotlinRuntimeNotification.this.myProject);
                if (versionedOutdatedLibraries.isEmpty()) {
                    return;
                }
                Collection outdatedLibraries = OutdatedKotlinRuntimeNotification.extractLibraries(versionedOutdatedLibraries);
                if (versionedOutdatedLibraries.size() == 1) {
                    VersionedLibrary versionedLibrary = (VersionedLibrary)((Object)versionedOutdatedLibraries.iterator().next());
                    String version = versionedLibrary.getVersion();
                    String readableVersion = version == null ? "unknown" : version;
                    String libraryName = versionedLibrary.getLibrary().getName();
                    message = String.format("<p>Your version of Kotlin runtime in '%s' library is %s, while plugin version is %s.</p><p>Runtime library should be updated to avoid compatibility problems.</p><p><a href=\"update\">Update Runtime</a> <a href=\"ignore\">Ignore</a></p>", libraryName, readableVersion, pluginVersion);
                } else {
                    String libraryNames = StringUtil.join((Collection)outdatedLibraries, (com.intellij.util.Function)new com.intellij.util.Function<Library, String>(){

                        public String fun(Library library) {
                            return library.getName();
                        }
                    }, (String)", ");
                    message = String.format("<p>Version of Kotlin runtime is outdated in several libraries (%s). Plugin version is %s.</p><p>Runtime libraries should be updated to avoid compatibility problems.</p><p><a href=\"update\">Update All</a> <a href=\"ignore\">Ignore</a></p>", libraryNames, pluginVersion);
                }
                Notifications.Bus.notify((Notification)new Notification(OutdatedKotlinRuntimeNotification.OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OutdatedKotlinRuntimeNotification.OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message, NotificationType.WARNING, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$1$2", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$1$2", "hyperlinkUpdate"));
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            if ("update".equals(event.getDescription())) {
                                Collection versionedOutdatedLibraries = OutdatedKotlinRuntimeNotification.findOutdatedKotlinLibraries(OutdatedKotlinRuntimeNotification.this.myProject);
                                Collection outdatedLibraries = OutdatedKotlinRuntimeNotification.extractLibraries(versionedOutdatedLibraries);
                                KotlinRuntimeLibraryUtil.updateLibraries(OutdatedKotlinRuntimeNotification.this.myProject, outdatedLibraries);
                                OutdatedKotlinRuntimeNotification.this.suggestDeleteKotlinJsIfNeeded(outdatedLibraries);
                            } else if ("ignore".equals(event.getDescription())) {
                                PropertiesComponent.getInstance((Project)OutdatedKotlinRuntimeNotification.this.myProject).setValue(OutdatedKotlinRuntimeNotification.SUPPRESSED_PROPERTY_NAME, pluginVersion);
                            } else {
                                throw new AssertionError();
                            }
                            notification.expire();
                        }
                    }
                }), (Project)OutdatedKotlinRuntimeNotification.this.myProject);
            }
        });
    }

    private void deleteKotlinJs() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile kotlinJsFile = OutdatedKotlinRuntimeNotification.this.myProject.getBaseDir().findFileByRelativePath("script/kotlin.js");
                        if (kotlinJsFile == null) {
                            return;
                        }
                        VirtualFile fileToDelete = PathUtil.getLocalFile((VirtualFile)kotlinJsFile);
                        try {
                            VirtualFile parent = fileToDelete.getParent();
                            fileToDelete.delete((Object)this);
                            parent.refresh(false, true);
                        }
                        catch (IOException ex) {
                            Notifications.Bus.notify((Notification)new Notification(OutdatedKotlinRuntimeNotification.OUTDATED_RUNTIME_GROUP_DISPLAY_ID, "Error", "Could not delete 'script/kotlin.js': " + ex.getMessage(), NotificationType.ERROR));
                        }
                    }
                });
            }
        });
    }

    private void suggestDeleteKotlinJsIfNeeded(Collection<Library> outdatedLibraries) {
        VirtualFile kotlinJsFile = this.myProject.getBaseDir().findFileByRelativePath("script/kotlin.js");
        if (kotlinJsFile == null) {
            return;
        }
        boolean addNotification = false;
        for (Library library : outdatedLibraries) {
            if (!LibraryPresentationProviderUtil.isDetected(JSLibraryStdPresentationProvider.getInstance(), library)) continue;
            VirtualFile jsStdlibJar = JSLibraryStdPresentationProvider.getJsStdLibJar(library);
            assert (jsStdlibJar != null) : "jslibFile should not be null";
            if (jsStdlibJar.findFileByRelativePath("kotlin.js") != null) continue;
            addNotification = true;
            break;
        }
        if (!addNotification) {
            return;
        }
        String message = String.format("<p>File 'script/kotlin.js' was probably created by an older version of the Kotlin plugin.</p><p>The new Kotlin plugin copies an up-to-date version of this file to the output directory automatically, so the old version of it can be deleted.</p><p><a href=\"delete\">Delete this file</a> <a href=\"ignore\">Ignore</a></p>", new Object[0]);
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$3", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$3", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if ("delete".equals(event.getDescription())) {
                        OutdatedKotlinRuntimeNotification.this.deleteKotlinJs();
                    } else if (!"ignore".equals(event.getDescription())) {
                        throw new AssertionError();
                    }
                    notification.expire();
                }
            }
        }), (Project)this.myProject);
    }

    private static Collection<Library> extractLibraries(Collection<VersionedLibrary> libraries) {
        return Collections2.transform(libraries, (Function)new Function<VersionedLibrary, Library>(){

            public Library apply(@Nullable VersionedLibrary versionedLibrary) {
                assert (versionedLibrary != null);
                return versionedLibrary.getLibrary();
            }
        });
    }

    @NotNull
    private static Collection<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification", "findOutdatedKotlinLibraries"));
        }
        ArrayList outdatedLibraries = Lists.newArrayList();
        for (Library library : KotlinRuntimeLibraryUtil.findKotlinLibraries(project)) {
            LibraryVersionProperties libraryVersionProperties = LibraryPresentationProviderUtil.getLibraryProperties(JavaRuntimePresentationProvider.getInstance(), library);
            if (libraryVersionProperties == null) {
                libraryVersionProperties = LibraryPresentationProviderUtil.getLibraryProperties(JSLibraryStdPresentationProvider.getInstance(), library);
            }
            if (libraryVersionProperties == null) continue;
            String libraryVersion = libraryVersionProperties.getVersionString();
            String runtimeVersion = KotlinRuntimeLibraryUtil.bundledRuntimeVersion();
            boolean isOutdated = libraryVersion == null || libraryVersion.startsWith("internal-") != runtimeVersion.startsWith("internal-") || VersionComparatorUtil.compare((String)runtimeVersion, (String)libraryVersion) > 0;
            if (!isOutdated) continue;
            outdatedLibraries.add(new VersionedLibrary(library, libraryVersion));
        }
        ArrayList arrayList = outdatedLibraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification", "findOutdatedKotlinLibraries"));
        }
        return arrayList;
    }

    @NotNull
    public static Runnable showRuntimeJarNotFoundDialog(final @NotNull Project project, final @NotNull String jarName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification", "showRuntimeJarNotFoundDialog"));
        }
        if (jarName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarName", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification", "showRuntimeJarNotFoundDialog"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project, (String)(jarName + " is not found. Make sure plugin is properly installed."), (String)"No Runtime Found");
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification", "showRuntimeJarNotFoundDialog"));
        }
        return runnable;
    }

    private static class VersionedLibrary
    extends Pair<Library, String> {
        public VersionedLibrary(@NotNull Library library, @Nullable String version) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$VersionedLibrary", "<init>"));
            }
            super((Object)library, (Object)version);
        }

        @NotNull
        public Library getLibrary() {
            Library library = (Library)this.first;
            if (library == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/OutdatedKotlinRuntimeNotification$VersionedLibrary", "getLibrary"));
            }
            return library;
        }

        @Nullable
        public String getVersion() {
            return (String)this.second;
        }
    }
}

