/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

public class SignatureDeserializer {
    private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    private final NameResolver nameResolver;

    public SignatureDeserializer(@NotNull NameResolver nameResolver) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "<init>"));
        }
        this.nameResolver = nameResolver;
    }

    @NotNull
    public String methodSignatureString(@NotNull JvmProtoBuf.JvmMethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "methodSignatureString"));
        }
        Name name2 = this.nameResolver.getName(signature.getName());
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        int length = signature.getParameterTypeCount();
        for (int i = 0; i < length; ++i) {
            this.typeDescriptor(signature.getParameterType(i), sb);
        }
        sb.append(')');
        this.typeDescriptor(signature.getReturnType(), sb);
        String string = name2.asString() + sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "methodSignatureString"));
        }
        return string;
    }

    @NotNull
    public MemberSignature methodSignature(@NotNull JvmProtoBuf.JvmMethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "methodSignature"));
        }
        MemberSignature memberSignature = MemberSignature.fromMethodNameAndDesc(this.methodSignatureString(signature));
        if (memberSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "methodSignature"));
        }
        return memberSignature;
    }

    @NotNull
    public String typeDescriptor(@NotNull JvmProtoBuf.JvmType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        String string = this.typeDescriptor(type2, new StringBuilder()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        return string;
    }

    @NotNull
    private StringBuilder typeDescriptor(@NotNull JvmProtoBuf.JvmType type2, @NotNull StringBuilder sb) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        for (int i = 0; i < type2.getArrayDimension(); ++i) {
            sb.append('[');
        }
        if (type2.hasPrimitiveType()) {
            sb.append(PRIMITIVE_TYPES[type2.getPrimitiveType().ordinal()]);
        } else {
            sb.append("L");
            sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type2.getClassFqName())));
            sb.append(";");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "typeDescriptor"));
        }
        return stringBuilder;
    }

    @NotNull
    private static String fqNameToInternalName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "fqNameToInternalName"));
        }
        String string = fqName2.asString().replace('.', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/SignatureDeserializer", "fqNameToInternalName"));
        }
        return string;
    }
}

