/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImplStub;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpressionImpl;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetDotQualifiedExpression
extends JetExpressionImplStub<KotlinPlaceHolderStub<JetDotQualifiedExpression>>
implements JetQualifiedExpression {
    private static final Logger LOG = Logger.getInstance(JetDotQualifiedExpression.class);

    public JetDotQualifiedExpression(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "<init>"));
        }
        super(node2);
    }

    public JetDotQualifiedExpression(@NotNull KotlinPlaceHolderStub<JetDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "<init>"));
        }
        super(stub, JetStubElementTypes.DOT_QUALIFIED_EXPRESSION);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "accept"));
        }
        return visitor2.visitDotQualifiedExpression(this, data2);
    }

    @Override
    @NotNull
    public JetExpression getReceiverExpression() {
        JetExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null) {
            JetExpression jetExpression = childExpressionsByStub[0];
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "getReceiverExpression"));
            }
            return jetExpression;
        }
        JetExpression jetExpression = JetQualifiedExpressionImpl.INSTANCE$.getReceiverExpression(this);
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "getReceiverExpression"));
        }
        return jetExpression;
    }

    @Override
    @Nullable
    public JetExpression getSelectorExpression() {
        JetExpression[] childExpressionsByStub;
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        if (stub != null && (childExpressionsByStub = this.getChildExpressionsByStub(stub)) != null && childExpressionsByStub.length == 2) {
            return childExpressionsByStub[1];
        }
        return JetQualifiedExpressionImpl.INSTANCE$.getSelectorExpression(this);
    }

    @Nullable
    private JetExpression[] getChildExpressionsByStub(@NotNull KotlinPlaceHolderStub<JetDotQualifiedExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "getChildExpressionsByStub"));
        }
        if (stub.getParentStubOfType(JetImportDirective.class) == null && stub.getParentStubOfType(JetPackageDirective.class) == null) {
            LOG.error("JetDotQualifiedExpression should only have stubs inside import or package directives.\n Stubs were created for:\n " + this.getText() + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        JetExpression[] expressions = (JetExpression[])stub.getChildrenByType(JetStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, JetExpression.ARRAY_FACTORY);
        if (expressions.length < 1 || expressions.length > 2) {
            LOG.error("Invalid stub structure. DOT_QUALIFIED_EXPRESSION must have one or two children. Was: " + expressions.length + "\nFile text:\n" + this.getContainingFile().getText());
            return null;
        }
        return expressions;
    }

    @Override
    @NotNull
    public ASTNode getOperationTokenNode() {
        ASTNode aSTNode = JetQualifiedExpressionImpl.INSTANCE$.getOperationTokenNode(this);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "getOperationTokenNode"));
        }
        return aSTNode;
    }

    @Override
    @NotNull
    public JetToken getOperationSign() {
        JetToken jetToken = JetQualifiedExpressionImpl.INSTANCE$.getOperationSign(this);
        if (jetToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDotQualifiedExpression", "getOperationSign"));
        }
        return jetToken;
    }
}

