/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class CallResolverUtil {
    private CallResolverUtil() {
    }

    public static boolean hasUnknownFunctionParameter(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasUnknownFunctionParameter"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        List<TypeProjection> functionParameters = arguments2.subList(0, arguments2.size() - 1);
        for (TypeProjection functionParameter : functionParameters) {
            if (!TypeUtils.containsSpecialType(functionParameter.getType(), TypeUtils.DONT_CARE) && !ErrorUtils.containsUninferredParameter(functionParameter.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnknownReturnType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasUnknownReturnType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        JetType returnTypeFromFunctionType = KotlinBuiltIns.getReturnTypeFromFunctionType(type2);
        return ErrorUtils.containsErrorType(returnTypeFromFunctionType);
    }

    public static JetType replaceReturnTypeByUnknown(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "replaceReturnTypeByUnknown"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(type2));
        List<TypeProjection> arguments2 = type2.getArguments();
        ArrayList newArguments = Lists.newArrayList();
        newArguments.addAll(arguments2.subList(0, arguments2.size() - 1));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        return new JetTypeImpl(type2.getAnnotations(), type2.getConstructor(), type2.isMarkedNullable(), newArguments, type2.getMemberScope());
    }

    private static boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor candidateDescriptor, @NotNull ConstraintSystem constraintSystem) {
        if (candidateDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasReturnTypeDependentOnUninferredParams"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasReturnTypeDependentOnUninferredParams"));
        }
        JetType returnType2 = candidateDescriptor.getReturnType();
        if (returnType2 == null) {
            return false;
        }
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            JetType inferredValueForTypeVariable = constraintSystem.getTypeBounds(typeVariable).getValue();
            if (inferredValueForTypeVariable != null || !TypeUtils.dependsOnTypeParameters(returnType2, Collections.singleton(typeVariable))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInferredReturnType(@NotNull CallableDescriptor candidateDescriptor, @NotNull ConstraintSystem constraintSystem) {
        if (candidateDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasInferredReturnType"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "hasInferredReturnType"));
        }
        if (CallResolverUtil.hasReturnTypeDependentOnUninferredParams(candidateDescriptor, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsFromPosition(ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
    }

    @NotNull
    public static JetType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        if (receiverParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        JetType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!typeParameter.getTypeConstructor().equals(receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        ArrayList fakeTypeArguments = Lists.newArrayList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(receiverType.getAnnotations(), receiverType.getConstructor(), receiverType.isMarkedNullable(), fakeTypeArguments, ErrorUtils.createErrorScope("Error scope for erased receiver type", true));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        return jetTypeImpl;
    }

    public static boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "isOrOverridesSynthesized"));
        }
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
                if (CallResolverUtil.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isInvokeCallOnVariable(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "isInvokeCallOnVariable"));
        }
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue dispatchReceiver = call.getDispatchReceiver();
        JetExpression expression2 = ((ExpressionReceiver)dispatchReceiver).getExpression();
        return expression2 instanceof JetSimpleNameExpression;
    }

    public static boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "isInvokeCallOnExpressionWithBothReceivers"));
        }
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtil.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver().exists() && call.getDispatchReceiver().exists();
    }

    public static JetSuperExpression getSuperCallExpression(@NotNull Call call) {
        JetExpression receiverExpression;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolverUtil", "getSuperCallExpression"));
        }
        ReceiverValue explicitReceiver = call.getExplicitReceiver();
        if (explicitReceiver instanceof ExpressionReceiver && (receiverExpression = ((ExpressionReceiver)explicitReceiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)receiverExpression;
        }
        return null;
    }

    public static enum ResolveArgumentsMode {
        RESOLVE_FUNCTION_ARGUMENTS,
        SHAPE_FUNCTION_ARGUMENTS;

    }
}

