/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.JetType;

public class IntValue
extends IntegerValueConstant<Integer> {
    public IntValue(int value2, boolean canBeUsedInAnnotations, boolean pure, boolean usesVariableAsConstant) {
        super(value2, canBeUsedInAnnotations, pure, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/kotlin/resolve/constants/IntValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getIntType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/constants/IntValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitIntValue(this, data2);
    }

    public String toString() {
        return ((Integer)this.value).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntValue intValue = (IntValue)o;
        return this.value == intValue.value;
    }

    public int hashCode() {
        return (Integer)this.value;
    }
}

