/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;

public class ExpressionReceiver
extends AbstractReceiverValue
implements ReceiverValue {
    private final JetExpression expression;

    public ExpressionReceiver(@NotNull JetExpression expression2, @NotNull JetType type2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver", "<init>"));
        }
        super(type2);
        this.expression = expression2;
    }

    @NotNull
    public JetExpression getExpression() {
        JetExpression jetExpression = this.expression;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver", "getExpression"));
        }
        return jetExpression;
    }

    public String toString() {
        return this.getType() + " {" + this.expression + ": " + this.expression.getText() + "}";
    }
}

