/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceBundleDialogComponent {
    private static final Logger LOG = Logger.getInstance(CreateResourceBundleDialogComponent.class);
    private static final Comparator<Locale> LOCALE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale l1, Locale l2) {
            if (l1 == PropertiesUtil.DEFAULT_LOCALE) {
                return -1;
            }
            if (l2 == PropertiesUtil.DEFAULT_LOCALE) {
                return 1;
            }
            return l1.toString().compareTo(l2.toString());
        }
    };
    private final Project myProject;
    private final PsiDirectory myDirectory;
    private final ResourceBundle myResourceBundle;
    private JPanel myPanel;
    private JTextField myResourceBundleBaseNameTextField;
    private JButton myAddLocaleFromExistButton;
    private JPanel myNewBundleLocalesPanel;
    private JPanel myProjectExistLocalesPanel;
    private JButton myAddAllButton;
    private JPanel myResourceBundleNamePanel;
    private JCheckBox myUseXMLBasedPropertiesCheckBox;
    private CollectionListModel<Locale> myLocalesModel;

    public CreateResourceBundleDialogComponent(Project project, PsiDirectory directory, ResourceBundle resourceBundle) {
        this.myProject = project;
        this.myDirectory = directory;
        this.myResourceBundle = resourceBundle;
        this.$$$setupUI$$$();
        if (resourceBundle != null) {
            this.myResourceBundleNamePanel.setVisible(false);
            this.myUseXMLBasedPropertiesCheckBox.setVisible(false);
        } else {
            final String checkBoxSelectedStateKey = this.getClass() + ".useXmlPropertiesFiles";
            this.myUseXMLBasedPropertiesCheckBox.setSelected(PropertiesComponent.getInstance().getBoolean(checkBoxSelectedStateKey, false));
            this.myUseXMLBasedPropertiesCheckBox.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    PropertiesComponent.getInstance().setValue(checkBoxSelectedStateKey, CreateResourceBundleDialogComponent.this.myUseXMLBasedPropertiesCheckBox.isSelected(), false);
                }
            });
        }
    }

    private List<PsiFile> createPropertiesFiles() {
        final Set<String> fileNames = this.getFileNamesToCreate();
        List createdFiles = (List)WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Computable)new Computable<List<PsiFile>>(){

            public List<PsiFile> compute() {
                return (List)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<List<PsiFile>>(){

                    public List<PsiFile> compute() {
                        return ContainerUtil.map((Collection)fileNames, (Function)new Function<String, PsiFile>(){

                            public PsiFile fun(String n) {
                                boolean isXml;
                                boolean bl = isXml = CreateResourceBundleDialogComponent.this.myResourceBundle == null ? CreateResourceBundleDialogComponent.this.myUseXMLBasedPropertiesCheckBox.isSelected() : CreateResourceBundleDialogComponent.this.myResourceBundle.getDefaultPropertiesFile() instanceof XmlPropertiesFile;
                                if (isXml) {
                                    FileTemplate template = FileTemplateManager.getInstance((Project)CreateResourceBundleDialogComponent.this.myProject).getInternalTemplate("XML Properties File.xml");
                                    LOG.assertTrue(template != null);
                                    try {
                                        return (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)n, null, (PsiDirectory)CreateResourceBundleDialogComponent.this.myDirectory);
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                return CreateResourceBundleDialogComponent.this.myDirectory.createFile(n);
                            }
                        });
                    }
                });
            }
        });
        this.combineToResourceBundleIfNeed(createdFiles);
        return createdFiles;
    }

    @NotNull
    private Set<String> getFileNamesToCreate() {
        final String name = this.getBaseName();
        final String suffix = this.getPropertiesFileSuffix();
        Set set = ContainerUtil.map2Set((Collection)this.myLocalesModel.getItems(), (Function)new Function<Locale, String>(){

            public String fun(Locale locale) {
                return name + (locale == PropertiesUtil.DEFAULT_LOCALE ? "" : "_" + locale.toString()) + suffix;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent", "getFileNamesToCreate"));
        }
        return set;
    }

    private void combineToResourceBundleIfNeed(Collection<PsiFile> files) {
        List createdFiles = ContainerUtil.map(files, (Function)new NotNullFunction<PsiFile, PropertiesFile>(){

            @NotNull
            public PropertiesFile fun(PsiFile dom) {
                PropertiesFile file = PropertiesImplUtil.getPropertiesFile(dom);
                LOG.assertTrue(file != null, (Object)dom.getName());
                PropertiesFile propertiesFile = file;
                if (propertiesFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$5", "fun"));
                }
                return propertiesFile;
            }
        });
        ResourceBundle mainBundle = this.myResourceBundle;
        HashSet<ResourceBundle> allBundles = new HashSet<ResourceBundle>();
        if (mainBundle != null) {
            allBundles.add(mainBundle);
        }
        boolean needCombining = false;
        for (PropertiesFile file : createdFiles) {
            ResourceBundle rb = file.getResourceBundle();
            if (mainBundle == null) {
                mainBundle = rb;
            } else if (!mainBundle.equals(rb)) {
                needCombining = true;
            }
            allBundles.add(rb);
        }
        if (needCombining) {
            ArrayList<PropertiesFile> toCombine = new ArrayList<PropertiesFile>(createdFiles);
            String baseName = this.getBaseName();
            if (this.myResourceBundle != null) {
                toCombine.addAll(this.myResourceBundle.getPropertiesFiles());
            }
            ResourceBundleManager manager = ResourceBundleManager.getInstance(mainBundle.getProject());
            for (ResourceBundle bundle : allBundles) {
                manager.dissociateResourceBundle(bundle);
            }
            manager.combineToResourceBundle(toCombine, baseName);
        }
    }

    private String getBaseName() {
        return this.myResourceBundle == null ? this.myResourceBundleBaseNameTextField.getText() : this.myResourceBundle.getBaseName();
    }

    private String canCreateAllFilesForAllLocales() {
        String name = this.getBaseName();
        if (name.isEmpty()) {
            return "Base name is empty";
        }
        Set<String> files = this.getFileNamesToCreate();
        if (files.isEmpty()) {
            return "No locales added";
        }
        for (PsiElement element : this.myDirectory.getChildren()) {
            PropertiesFile propertiesFile;
            String propertiesFileName;
            if (!(element instanceof PsiFile) || !(element instanceof PropertiesFile) || !files.contains(propertiesFileName = (propertiesFile = (PropertiesFile)element).getName())) continue;
            return "Some of files already exist";
        }
        return null;
    }

    private String getPropertiesFileSuffix() {
        if (this.myResourceBundle == null) {
            return this.myUseXMLBasedPropertiesCheckBox.isSelected() ? ".xml" : ".properties";
        }
        return "." + this.myResourceBundle.getDefaultPropertiesFile().getContainingFile().getFileType().getDefaultExtension();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    private static List<Locale> extractLocalesFromString(String rawLocales) {
        if (rawLocales.isEmpty()) {
            return Collections.emptyList();
        }
        String[] splitRawLocales = rawLocales.split(",");
        ArrayList<Locale> locales = new ArrayList<Locale>(splitRawLocales.length);
        for (String rawLocale : splitRawLocales) {
            Locale locale = PropertiesUtil.getLocale("_" + rawLocale + ".properties");
            if (locale == PropertiesUtil.DEFAULT_LOCALE) {
                return null;
            }
            if (locales.contains(locale)) continue;
            locales.add(locale);
        }
        return locales;
    }

    private void createUIComponents() {
        List restrictedLocales;
        List<Object> locales;
        final JBList projectExistLocalesList = new JBList();
        final MyExistLocalesListModel existLocalesListModel = new MyExistLocalesListModel();
        projectExistLocalesList.setModel((ListModel)existLocalesListModel);
        projectExistLocalesList.setCellRenderer(CreateResourceBundleDialogComponent.getLocaleRenderer());
        this.myProjectExistLocalesPanel = ToolbarDecorator.createDecorator((JList)projectExistLocalesList).disableRemoveAction().disableUpDownActions().createPanel();
        this.myProjectExistLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Project locales", (boolean)false));
        final JBList localesToAddList = new JBList();
        if (this.myResourceBundle == null) {
            locales = Collections.singletonList(PropertiesUtil.DEFAULT_LOCALE);
            restrictedLocales = Collections.emptyList();
        } else {
            locales = Collections.emptyList();
            restrictedLocales = ContainerUtil.map(this.myResourceBundle.getPropertiesFiles(), (Function)new Function<PropertiesFile, Locale>(){

                public Locale fun(PropertiesFile propertiesFile) {
                    return propertiesFile.getLocale();
                }
            });
        }
        this.myLocalesModel = new CollectionListModel<Locale>(locales){

            public void add(@NotNull List<? extends Locale> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$7", "add"));
                }
                final List currentItems = this.getItems();
                elements = ContainerUtil.filter(elements, (Condition)new Condition<Locale>(){

                    public boolean value(Locale locale) {
                        return !restrictedLocales.contains(locale) && !currentItems.contains(locale);
                    }
                });
                super.add(elements);
            }
        };
        localesToAddList.setModel(this.myLocalesModel);
        localesToAddList.setCellRenderer(CreateResourceBundleDialogComponent.getLocaleRenderer());
        localesToAddList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                projectExistLocalesList.clearSelection();
            }
        });
        projectExistLocalesList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                localesToAddList.clearSelection();
            }
        });
        this.myNewBundleLocalesPanel = ToolbarDecorator.createDecorator((JList)localesToAddList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String rawAddedLocales = Messages.showInputDialog((Project)CreateResourceBundleDialogComponent.this.myProject, (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.message", new Object[0]), (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.title", new Object[0]), null, null, (InputValidator)new InputValidatorEx(){

                    @Nullable
                    public String getErrorText(String inputString) {
                        return this.checkInput(inputString) ? null : "Invalid locales";
                    }

                    public boolean checkInput(String inputString) {
                        return CreateResourceBundleDialogComponent.extractLocalesFromString(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (rawAddedLocales != null) {
                    List locales = CreateResourceBundleDialogComponent.extractLocalesFromString(rawAddedLocales);
                    LOG.assertTrue(locales != null);
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(locales);
                }
            }
        }).setAddActionName("Add locales by suffix").disableUpDownActions().createPanel();
        this.myNewBundleLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Locales to add", (boolean)false));
        this.myAddLocaleFromExistButton = new JButton(AllIcons.Actions.Forward);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$11", "onClick"));
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(ContainerUtil.map((Object[])projectExistLocalesList.getSelectedValues(), (Function)new Function<Object, Locale>(){

                        public Locale fun(Object o) {
                            return (Locale)o;
                        }
                    }));
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myAddLocaleFromExistButton);
        projectExistLocalesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List currentItems = CreateResourceBundleDialogComponent.this.myLocalesModel.getItems();
                for (Object o : projectExistLocalesList.getSelectedValues()) {
                    Locale l = (Locale)o;
                    if (restrictedLocales.contains(l) || currentItems.contains(l)) continue;
                    CreateResourceBundleDialogComponent.this.myAddLocaleFromExistButton.setEnabled(true);
                    return;
                }
                CreateResourceBundleDialogComponent.this.myAddLocaleFromExistButton.setEnabled(false);
            }
        });
        this.myAddLocaleFromExistButton.setEnabled(false);
        this.myAddAllButton = new JButton("Add All");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$13", "onClick"));
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(existLocalesListModel.getLocales());
                }
                return false;
            }
        }.installOn((Component)this.myAddAllButton);
    }

    @NotNull
    private static ColoredListCellRenderer<Locale> getLocaleRenderer() {
        ColoredListCellRenderer<Locale> coloredListCellRenderer = new ColoredListCellRenderer<Locale>(){

            protected void customizeCellRenderer(JList list, Locale locale, int index, boolean selected, boolean hasFocus) {
                if (PropertiesUtil.DEFAULT_LOCALE == locale) {
                    this.append("Default locale");
                } else {
                    this.append(locale.toString());
                    this.append(PropertiesUtil.getPresentableLocale(locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        };
        if (coloredListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent", "getLocaleRenderer"));
        }
        return coloredListCellRenderer;
    }

    @Nullable
    static PsiDirectory getResourceBundlePlacementDirectory(ResourceBundle resourceBundle) {
        PsiDirectory containingDirectory = null;
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (containingDirectory == null) {
                containingDirectory = propertiesFile.getContainingFile().getContainingDirectory();
                continue;
            }
            if (containingDirectory.isEquivalentTo((PsiElement)propertiesFile.getContainingFile().getContainingDirectory())) continue;
            return null;
        }
        LOG.assertTrue(containingDirectory != null);
        return containingDirectory;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myResourceBundleNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "North");
        this.myResourceBundleBaseNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resource bundle base name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseXMLBasedPropertiesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use XML-based properties files");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "Center");
        JButton jButton = this.myAddLocaleFromExistButton;
        jButton.setFocusable(false);
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = this.myNewBundleLocalesPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 2, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myProjectExistLocalesPanel;
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JButton jButton2 = this.myAddAllButton;
        jButton2.setFocusable(false);
        jButton2.setText("Add All");
        jPanel3.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyExistLocalesListModel
    extends AbstractListModel {
        private final List<Locale> myLocales = new ArrayList<Locale>();

        private MyExistLocalesListModel() {
            this.myLocales.add(PropertiesUtil.DEFAULT_LOCALE);
            PropertiesReferenceManager.getInstance(CreateResourceBundleDialogComponent.this.myProject).processPropertiesFiles(GlobalSearchScope.projectScope((Project)CreateResourceBundleDialogComponent.this.myProject), new PropertiesFileProcessor(){

                @Override
                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    Locale locale = propertiesFile.getLocale();
                    if (locale != PropertiesUtil.DEFAULT_LOCALE && !MyExistLocalesListModel.this.myLocales.contains(locale)) {
                        MyExistLocalesListModel.this.myLocales.add(locale);
                    }
                    return true;
                }
            }, BundleNameEvaluator.DEFAULT);
            Collections.sort(this.myLocales, LOCALE_COMPARATOR);
        }

        @Override
        public int getSize() {
            return this.myLocales.size();
        }

        @Override
        public Locale getElementAt(int index) {
            return this.myLocales.get(index);
        }

        public List<Locale> getLocales() {
            return this.myLocales;
        }
    }

    public static class Dialog
    extends DialogWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final PsiDirectory myDirectory;
        private CreateResourceBundleDialogComponent myComponent;
        private PsiElement[] myCreatedFiles;

        protected Dialog(@Nullable Project project, @Nullable PsiDirectory directory, @Nullable ResourceBundle resourceBundle) {
            super(project);
            if (directory == null) {
                LOG.assertTrue(resourceBundle != null && CreateResourceBundleDialogComponent.getResourceBundlePlacementDirectory(resourceBundle) != null);
            }
            this.myProject = project;
            this.myDirectory = directory == null ? resourceBundle.getDefaultPropertiesFile().getContainingFile().getContainingDirectory() : directory;
            this.myComponent = new CreateResourceBundleDialogComponent(this.myProject, this.myDirectory, resourceBundle);
            this.init();
            this.initValidation();
            this.setTitle(resourceBundle == null ? "Create resource bundle" : String.format("Add locales to resource bundle '%s'", resourceBundle.getBaseName()));
        }

        protected void doOKAction() {
            String errorString = this.myComponent.canCreateAllFilesForAllLocales();
            if (errorString != null) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)errorString);
            } else {
                List createFiles = this.myComponent.createPropertiesFiles();
                this.myCreatedFiles = createFiles.toArray(new PsiElement[createFiles.size()]);
                super.doOKAction();
            }
        }

        @Nullable
        protected ValidationInfo doValidate() {
            for (String fileName : this.myComponent.getFileNamesToCreate()) {
                if (!PathUtil.isValidFileName((String)fileName)) {
                    return new ValidationInfo(String.format("File name for properties file '%s' is invalid", fileName));
                }
                if (this.myDirectory.findFile(fileName) == null) continue;
                return new ValidationInfo(String.format("File with name '%s' already exist", fileName));
            }
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComponent.getPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComponent.myResourceBundleBaseNameTextField;
        }

        public PsiElement[] getCreatedFiles() {
            return this.myCreatedFiles;
        }
    }
}

