/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectPackage$reflectClassUtil$bd8e40d0;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectPackage$ReflectKotlinClass$56485e6e;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class ReflectClassStructure {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final ReflectClassStructure INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectClassStructure.class);
        new ReflectClassStructure();
    }

    public final void loadClassAnnotations(@JetValueParameter(name="klass") @NotNull Class<?> klass, @JetValueParameter(name="visitor") @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(visitor, "visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation;
            Annotation annotation2 = annotation = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
            this.processAnnotation(visitor, annotation2);
        }
        visitor.visitEnd();
    }

    public final void visitMembers(@JetValueParameter(name="klass") @NotNull Class<?> klass, @JetValueParameter(name="memberVisitor") @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(memberVisitor, "memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMethodAnnotations(@JetValueParameter(name="klass") Class<?> klass, @JetValueParameter(name="memberVisitor") KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor;
            Method method = methodArray[i];
            Name name = Name.identifier(method.getName());
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE$.methodDesc(method2)) == null) {
                continue;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            for (IndexedValue<Object> indexedValue : KotlinPackage.withIndex((Object[])method.getParameterAnnotations())) {
                int parameterIndex = indexedValue.component1();
                Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                for (int j = 0; j < annotations2.length; ++j) {
                    Unit unit;
                    Annotation annotation = annotations2[j];
                    Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
                    if (visitor.visitParameterAnnotation(parameterIndex, ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(annotationType)) != null) {
                        void $receiver;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
                        Annotation annotation3 = annotation;
                        Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                        ReflectClassStructure.INSTANCE$.processAnnotationArguments(it, annotation3, annotationType);
                        unit = Unit.INSTANCE$;
                        continue;
                    }
                    unit = null;
                }
            }
            visitor.visitEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadConstructorAnnotations(@JetValueParameter(name="klass") Class<?> klass, @JetValueParameter(name="memberVisitor") KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor;
            Constructor<?> constructor2 = constructorArray[i];
            Name name = Name.special("<init>");
            Constructor<?> constructor3 = constructor2;
            Intrinsics.checkExpressionValueIsNotNull(constructor3, "constructor");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE$.constructorDesc(constructor3)) == null) {
                continue;
            }
            Annotation[] annotationArray = constructor2.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor2.getParameterAnnotations();
            if (KotlinPackage.isNotEmpty((Object[])parameterAnnotations)) {
                int shift = ((Object[])constructor2.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (IndexedValue<Object> indexedValue : KotlinPackage.withIndex((Object[])parameterAnnotations)) {
                    int parameterIndex = indexedValue.component1();
                    Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                    for (int j = 0; j < annotations2.length; ++j) {
                        Unit unit;
                        Annotation annotation = annotations2[j];
                        Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
                        if (visitor.visitParameterAnnotation(parameterIndex + shift, ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(annotationType)) != null) {
                            void $receiver;
                            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
                            Annotation annotation3 = annotation;
                            Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                            ReflectClassStructure.INSTANCE$.processAnnotationArguments(it, annotation3, annotationType);
                            unit = Unit.INSTANCE$;
                            continue;
                        }
                        unit = null;
                    }
                }
            }
            visitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(@JetValueParameter(name="klass") Class<?> klass, @JetValueParameter(name="memberVisitor") KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor;
            Field field2 = fieldArray[i];
            Name name = Name.identifier(field2.getName());
            Field field3 = field2;
            Intrinsics.checkExpressionValueIsNotNull(field3, "field");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE$.fieldDesc(field3), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field2.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation;
                Annotation annotation2 = annotation = annotationArray[j];
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(visitor, annotation2);
            }
            visitor.visitEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotation(@JetValueParameter(name="visitor") KotlinJvmBinaryClass.AnnotationVisitor visitor, @JetValueParameter(name="annotation") Annotation annotation) {
        Unit unit;
        Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor.visitAnnotation(ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(annotationType));
        if (annotationArgumentVisitor != null) {
            void $receiver;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
            ReflectClassStructure.INSTANCE$.processAnnotationArguments(it, annotation, annotationType);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    private final void processAnnotationArguments(@JetValueParameter(name="visitor") KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor, @JetValueParameter(name="annotation") Annotation annotation, @JetValueParameter(name="annotationType") Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Name name = Name.identifier(method.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(method.getName())");
            Object object = method.invoke((Object)annotation, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(object, "method(annotation)");
            this.processAnnotationArgumentValue(visitor, name, object);
        }
        visitor.visitEnd();
    }

    private final void processAnnotationArgumentValue(@JetValueParameter(name="visitor") KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor, @JetValueParameter(name="name") Name name, @JetValueParameter(name="value") Object value) {
        Class<?> clazz = value.getClass();
        if (ReflectPackage$ReflectKotlinClass$56485e6e.getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT().contains(clazz)) {
            visitor.visit(name, value);
        } else if (ReflectPackage$reflectClassUtil$bd8e40d0.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            ClassId classId = ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(clazz.isEnum() ? clazz : clazz.getEnclosingClass());
            Object object = value;
            if (object == null) {
                throw new TypeCastException("kotlin.Any cannot be cast to kotlin.Enum<*>");
            }
            visitor.visitEnum(name, classId, Name.identifier(((Enum)object).name()));
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class annotationClass = (Class)KotlinPackage.single((Object[])clazz.getInterfaces());
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor.visitAnnotation(name, ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Object object = value;
            if (object == null) {
                throw new TypeCastException("kotlin.Any cannot be cast to kotlin.Annotation");
            }
            Annotation annotation = (Annotation)object;
            Class clazz2 = annotationClass;
            Intrinsics.checkExpressionValueIsNotNull(clazz2, "annotationClass");
            this.processAnnotationArguments(v, annotation, clazz2);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                ClassId enumClassId = ReflectPackage$reflectClassUtil$bd8e40d0.getClassId(componentType);
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("kotlin.Any cannot be cast to kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element;
                    Object object2 = element = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.Enum<*>");
                    }
                    v.visitEnum(enumClassId, Name.identifier(((Enum)object2).name()));
                }
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("kotlin.Any cannot be cast to kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element = objectArray[i];
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }

    ReflectClassStructure() {
        INSTANCE$ = this;
    }
}

