/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.MergeSourceDetailsAction;
import org.jetbrains.idea.svn.history.SvnDiffFromHistoryHandler;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageFromFileHistoryAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnHistorySession;
import org.jetbrains.idea.svn.history.SvnMergeSourceDetails;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnPathThroughHistoryCorrection;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnHistoryProvider
implements VcsHistoryProvider,
VcsCacheableHistorySessionFactory<Boolean, SvnHistorySession> {
    private final SvnVcs myVcs;
    private static final Object MERGE_SOURCE_DETAILS_TAG = new Object();

    public SvnHistoryProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new SvnDiffFromHistoryHandler(this.myVcs);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/history/SvnHistoryProvider", "canShowHistoryFor"));
        }
        return true;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        JPanel addComp;
        Consumer<VcsFileRevision> listener;
        ColumnInfo[] columns;
        if (((SvnHistorySession)session).isHaveMergeSources()) {
            final MergeSourceColumnInfo mergeSourceColumn = new MergeSourceColumnInfo((SvnHistorySession)session);
            columns = new ColumnInfo[]{new CopyFromColumnInfo(), mergeSourceColumn};
            JPanel panel = new JPanel(new BorderLayout());
            final JTextArea field = new JTextArea();
            field.setEditable(false);
            field.setBackground(UIUtil.getComboBoxDisabledBackground());
            field.setWrapStyleWord(true);
            listener = new Consumer<VcsFileRevision>(){

                public void consume(VcsFileRevision vcsFileRevision) {
                    field.setText(mergeSourceColumn.getText(vcsFileRevision));
                }
            };
            MergeSourceDetailsAction sourceAction = new MergeSourceDetailsAction();
            sourceAction.registerSelf(forShortcutRegistration);
            JPanel fieldPanel = new ToolbarDecorator(){

                protected JComponent getComponent() {
                    return field;
                }

                protected void updateButtons() {
                }

                protected void installDnDSupport() {
                }

                protected boolean isModelEditable() {
                    return false;
                }
            }.initPosition().addExtraAction(AnActionButton.fromAction((AnAction)sourceAction)).createPanel();
            fieldPanel.setBorder(IdeBorderFactory.createBorder((int)3));
            panel.add((Component)fieldPanel, "Center");
            panel.add((Component)new JLabel("Merge Sources:"), "North");
            addComp = panel;
        } else {
            columns = new ColumnInfo[]{new CopyFromColumnInfo()};
            addComp = null;
            listener = null;
        }
        return new VcsDependentHistoryComponents(columns, listener, addComp);
    }

    public FilePath getUsedFilePath(SvnHistorySession session) {
        return session.getCommittedPath();
    }

    public Boolean getAddinionallyCachedData(SvnHistorySession session) {
        return session.isHaveMergeSources();
    }

    public SvnHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "org/jetbrains/idea/svn/history/SvnHistoryProvider", "createFromCachedData"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/history/SvnHistoryProvider", "createFromCachedData"));
        }
        return new SvnHistorySession(this.myVcs, revisions, filePath, aBoolean, currentRevision, false, !filePath.isNonLocal());
    }

    @Nullable
    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        VcsAppendableHistoryPartnerAdapter adapter = new VcsAppendableHistoryPartnerAdapter();
        this.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)adapter);
        adapter.check();
        return adapter.getSession();
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myVcs.getProject());
        int limit = configuration.LIMIT_HISTORY ? configuration.MAXIMUM_HISTORY_ROWS + 1 : 0;
        this.reportAppendableHistory(path, partner, null, null, limit, null, false);
    }

    public void reportAppendableHistory(FilePath path, final VcsAppendableHistorySessionPartner partner, @Nullable SVNRevision from, @Nullable SVNRevision to, int limit, SVNRevision peg, boolean forceBackwards) throws VcsException {
        FilePath committedPath = path;
        Change change = ChangeListManager.getInstance((Project)this.myVcs.getProject()).getChange(path);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(path)) {
                committedPath = beforeRevision.getFile();
            }
            if (peg == null && change.getBeforeRevision() != null && change.getBeforeRevision().getRevisionNumber() instanceof SvnRevisionNumber) {
                peg = ((SvnRevisionNumber)change.getBeforeRevision().getRevisionNumber()).getRevision();
            }
        }
        boolean showMergeSources = SvnConfiguration.getInstance(this.myVcs.getProject()).isShowMergeSourcesInAnnotate();
        LogLoader logLoader = path.isNonLocal() ? new RepositoryLoader(this.myVcs, committedPath, from, to, limit, peg, forceBackwards, showMergeSources) : new LocalLoader(this.myVcs, committedPath, from, to, limit, peg, showMergeSources);
        try {
            logLoader.preliminary();
        }
        catch (SVNCancelException e) {
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        logLoader.check();
        if (showMergeSources) {
            logLoader.initSupports15();
        }
        final SvnHistorySession historySession = new SvnHistorySession(this.myVcs, Collections.<VcsFileRevision>emptyList(), committedPath, showMergeSources && Boolean.TRUE.equals(logLoader.mySupport15), null, false, !path.isNonLocal());
        final Ref sessionReported = new Ref();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(SvnBundle.message("progress.text2.collecting.history", path.getName()));
        }
        Consumer<VcsFileRevision> consumer = new Consumer<VcsFileRevision>(){

            public void consume(VcsFileRevision vcsFileRevision) {
                if (!Boolean.TRUE.equals(sessionReported.get())) {
                    partner.reportCreatedEmptySession((VcsAbstractHistorySession)historySession);
                    sessionReported.set((Object)true);
                }
                partner.acceptRevision(vcsFileRevision);
            }
        };
        logLoader.setConsumer(consumer);
        logLoader.load();
        logLoader.check();
    }

    private static ThrowableConsumer<VcsFileRevision, SVNException> createConsumerAdapter(final Consumer<VcsFileRevision> consumer) {
        return new ThrowableConsumer<VcsFileRevision, SVNException>(){

            public void consume(VcsFileRevision revision) throws SVNException {
                consumer.consume((Object)revision);
            }
        };
    }

    public String getHelpId() {
        return null;
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new MergeSourceDetailsAction(), new SvnEditCommitMessageFromFileHistoryAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    private static class CopyFromColumnInfo
    extends ColumnInfo<VcsFileRevision, String> {
        private final Icon myIcon = PlatformIcons.COPY_ICON;
        private final ColoredTableCellRenderer myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof String && ((String)value).length() > 0) {
                    this.setIcon(CopyFromColumnInfo.this.myIcon);
                    this.setToolTipText(SvnBundle.message("copy.column.tooltip", value));
                } else {
                    this.setToolTipText("");
                }
            }
        };

        public CopyFromColumnInfo() {
            super(SvnBundle.message("copy.column.title", new Object[0]));
        }

        public String valueOf(VcsFileRevision o) {
            return o instanceof SvnFileRevision ? ((SvnFileRevision)o).getCopyFromPath() : "";
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public String getMaxStringValue() {
            return SvnBundle.message("copy.column.title", new Object[0]);
        }

        public int getAdditionalWidth() {
            return 6;
        }
    }

    private class MergeSourceRenderer
    extends ColoredTableCellRenderer {
        private MergeSourceDetailsLinkListener myListener;
        private final VirtualFile myFile;

        private MergeSourceRenderer(SvnHistorySession session) {
            this.myFile = session.getCommittedPath().getVirtualFile();
        }

        public String getText(VcsFileRevision value) {
            return RevisionMergeSourceInfo.toString(value);
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (this.myListener == null) {
                this.myListener = new MergeSourceDetailsLinkListener(MERGE_SOURCE_DETAILS_TAG, this.myFile);
                this.myListener.installOn(table);
            }
            this.appendMergeSourceText(table, row, column, value instanceof RevisionMergeSourceInfo ? value.toString() : null);
        }

        private void appendMergeSourceText(JTable table, int row, int column, @Nullable String text) {
            if (StringUtil.isEmpty((String)text)) {
                this.append("", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.append(this.cutString(text, table.getCellRect(row, column, false).getWidth()), SimpleTextAttributes.REGULAR_ATTRIBUTES, MERGE_SOURCE_DETAILS_TAG);
            }
        }

        private String cutString(String text, double value) {
            Graphics g;
            FontMetrics m = this.getFontMetrics(this.getFont());
            if (m.getStringBounds(text, g = this.getGraphics()).getWidth() < value) {
                return text;
            }
            String dots = "...";
            double dotsWidth = m.getStringBounds("...", g).getWidth();
            if (dotsWidth >= value) {
                return "...";
            }
            for (int i = 1; i < text.length(); ++i) {
                if (!(m.getStringBounds(text, 0, i, g).getWidth() + dotsWidth >= value)) continue;
                if (i < 2) {
                    return "...";
                }
                return text.substring(0, i - 1) + "...";
            }
            return text;
        }
    }

    private class MergeSourceDetailsLinkListener
    extends TableLinkMouseListener {
        private final VirtualFile myFile;
        private final Object myTag;

        private MergeSourceDetailsLinkListener(Object tag, VirtualFile file) {
            this.myTag = tag;
            this.myFile = file;
        }

        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            SvnFileRevision revision;
            Object tag;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/history/SvnHistoryProvider$MergeSourceDetailsLinkListener", "onClick"));
            }
            if (e.getButton() == 1 && !e.isPopupTrigger() && (tag = this.getTagAt(e)) == this.myTag && (revision = this.getSelectedRevision(e)) != null) {
                SvnMergeSourceDetails.showMe(SvnHistoryProvider.this.myVcs.getProject(), revision, this.myFile);
                return true;
            }
            return false;
        }

        @Nullable
        private SvnFileRevision getSelectedRevision(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int column = table.columnAtPoint(e.getPoint());
            Object value = table.getModel().getValueAt(row, column);
            if (value instanceof RevisionMergeSourceInfo) {
                return ((RevisionMergeSourceInfo)value).getRevision();
            }
            return null;
        }

        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Object tag = this.getTagAt(e);
            if (tag == this.myTag) {
                table.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                table.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class MergeSourceColumnInfo
    extends ColumnInfo<VcsFileRevision, RevisionMergeSourceInfo> {
        private final MergeSourceRenderer myRenderer;

        private MergeSourceColumnInfo(SvnHistorySession session) {
            super("Merge Sources");
            this.myRenderer = new MergeSourceRenderer(session);
        }

        public TableCellRenderer getRenderer(VcsFileRevision vcsFileRevision) {
            return this.myRenderer;
        }

        public RevisionMergeSourceInfo valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision != null ? new RevisionMergeSourceInfo(vcsFileRevision) : null;
        }

        public String getText(VcsFileRevision vcsFileRevision) {
            return this.myRenderer.getText(vcsFileRevision);
        }

        public int getAdditionalWidth() {
            return 20;
        }

        public String getPreferredStringValue() {
            return "1234567, 1234567, 1234567";
        }
    }

    private static class RevisionMergeSourceInfo {
        @NotNull
        private final VcsFileRevision revision;

        private RevisionMergeSourceInfo(@NotNull VcsFileRevision revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/history/SvnHistoryProvider$RevisionMergeSourceInfo", "<init>"));
            }
            this.revision = revision;
        }

        @NotNull
        public SvnFileRevision getRevision() {
            SvnFileRevision svnFileRevision = (SvnFileRevision)this.revision;
            if (svnFileRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnHistoryProvider$RevisionMergeSourceInfo", "getRevision"));
            }
            return svnFileRevision;
        }

        public String toString() {
            return RevisionMergeSourceInfo.toString(this.revision);
        }

        private static String toString(@Nullable VcsFileRevision value) {
            if (!(value instanceof SvnFileRevision)) {
                return "";
            }
            SvnFileRevision revision = (SvnFileRevision)value;
            List<SvnFileRevision> mergeSources = revision.getMergeSources();
            if (mergeSources.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (SvnFileRevision source : mergeSources) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(source.getRevisionNumber().asString());
                if (source.getMergeSources().isEmpty()) continue;
                sb.append("*");
            }
            return sb.toString();
        }
    }

    private static class RepositoryLogEntryHandler
    extends MyLogEntryHandler {
        public RepositoryLogEntryHandler(SvnVcs vcs, String url, SVNRevision pegRevision, String lastPath, ThrowableConsumer<VcsFileRevision, SVNException> result, SVNURL repoRootURL) throws VcsException, SVNException {
            super(vcs, url, pegRevision, lastPath, result, repoRootURL, null);
        }

        @Override
        protected SvnFileRevision createRevision(LogEntry logEntry, String copyPath, LogEntryPath entryPath) throws SVNException {
            SVNURL url = entryPath == null ? this.myRepositoryRoot.appendPath(this.myLastPathCorrector.getBefore(), false) : this.myRepositoryRoot.appendPath(entryPath.getPath(), true);
            return new SvnFileRevision(this.myVcs, SVNRevision.UNDEFINED, logEntry, url.toString(), copyPath);
        }
    }

    private static class MyLogEntryHandler
    implements LogEntryConsumer {
        private final ProgressIndicator myIndicator;
        protected final SvnVcs myVcs;
        protected final SvnPathThroughHistoryCorrection myLastPathCorrector;
        private final Charset myCharset;
        protected final ThrowableConsumer<VcsFileRevision, SVNException> myResult;
        private final String myLastPath;
        private VcsFileRevision myPrevious;
        private final SVNRevision myPegRevision;
        protected final String myUrl;
        private final SvnMergeSourceTracker myTracker;
        protected SVNURL myRepositoryRoot;
        private boolean myThrowCancelOnMeetPathCreation;

        public void setThrowCancelOnMeetPathCreation(boolean throwCancelOnMeetPathCreation) {
            this.myThrowCancelOnMeetPathCreation = throwCancelOnMeetPathCreation;
        }

        public MyLogEntryHandler(SvnVcs vcs, String url, SVNRevision pegRevision, String lastPath, ThrowableConsumer<VcsFileRevision, SVNException> result, SVNURL repoRootURL, Charset charset) throws SVNException, VcsException {
            this.myVcs = vcs;
            this.myLastPathCorrector = new SvnPathThroughHistoryCorrection(lastPath);
            this.myLastPath = lastPath;
            this.myCharset = charset;
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            this.myResult = result;
            this.myPegRevision = pegRevision;
            this.myUrl = url;
            this.myRepositoryRoot = repoRootURL;
            this.myTracker = new SvnMergeSourceTracker(new ThrowableConsumer<Pair<LogEntry, Integer>, SVNException>(){

                public void consume(Pair<LogEntry, Integer> svnLogEntryIntegerPair) throws SVNException {
                    LogEntry logEntry = (LogEntry)svnLogEntryIntegerPair.getFirst();
                    if (MyLogEntryHandler.this.myIndicator != null) {
                        if (MyLogEntryHandler.this.myIndicator.isCanceled()) {
                            SVNErrorManager.cancel((String)SvnBundle.message("exception.text.update.operation.cancelled", new Object[0]), (SVNLogType)SVNLogType.DEFAULT);
                        }
                        MyLogEntryHandler.this.myIndicator.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                    }
                    LogEntryPath entryPath = null;
                    String copyPath = null;
                    int mergeLevel = (Integer)svnLogEntryIntegerPair.getSecond();
                    if (!MyLogEntryHandler.this.myLastPathCorrector.isRoot()) {
                        MyLogEntryHandler.this.myLastPathCorrector.consume(logEntry);
                        entryPath = MyLogEntryHandler.this.myLastPathCorrector.getDirectlyMentioned();
                        copyPath = null;
                        if (entryPath != null) {
                            copyPath = entryPath.getCopyPath();
                        }
                    }
                    SvnFileRevision revision = MyLogEntryHandler.this.createRevision(logEntry, copyPath, entryPath);
                    if (mergeLevel >= 0) {
                        MyLogEntryHandler.addToListByLevel((SvnFileRevision)MyLogEntryHandler.this.myPrevious, revision, mergeLevel);
                    } else {
                        MyLogEntryHandler.this.myResult.consume((Object)revision);
                        MyLogEntryHandler.this.myPrevious = revision;
                    }
                    if (MyLogEntryHandler.this.myThrowCancelOnMeetPathCreation && MyLogEntryHandler.this.myUrl.equals(revision.getURL()) && entryPath != null && entryPath.getType() == 'A') {
                        throw new SVNCancelException();
                    }
                }
            });
        }

        private boolean checkForParentChanges(LogEntry logEntry) {
            String lastPathBefore = this.myLastPathCorrector.getBefore();
            String path = SVNPathUtil.removeTail((String)lastPathBefore);
            while (path.length() > 0) {
                LogEntryPath entryPath = logEntry.getChangedPaths().get(path);
                if (entryPath != null && (entryPath.getType() == 'A' || entryPath.getType() == 'D')) {
                    if (entryPath.getCopyPath() == null) break;
                    return true;
                }
                path = SVNPathUtil.removeTail((String)path);
            }
            return false;
        }

        private boolean checkForChildChanges(LogEntry logEntry) {
            String lastPathBefore = this.myLastPathCorrector.getBefore();
            for (String key : logEntry.getChangedPaths().keySet()) {
                if (!SVNPathUtil.isAncestor((String)lastPathBefore, (String)key)) continue;
                return true;
            }
            return false;
        }

        public void consume(LogEntry logEntry) throws SVNException {
            this.myTracker.consume(logEntry);
        }

        private static void addToListByLevel(SvnFileRevision revision, SvnFileRevision revisionToAdd, int level) {
            if (level < 0) {
                return;
            }
            if (level == 0) {
                revision.addMergeSource(revisionToAdd);
                return;
            }
            List<SvnFileRevision> sources = revision.getMergeSources();
            if (!sources.isEmpty()) {
                MyLogEntryHandler.addToListByLevel(sources.get(sources.size() - 1), revisionToAdd, level - 1);
            }
        }

        protected SvnFileRevision createRevision(LogEntry logEntry, String copyPath, LogEntryPath entryPath) throws SVNException {
            Date date = logEntry.getDate();
            String author = logEntry.getAuthor();
            String message = logEntry.getMessage();
            SVNRevision rev = SVNRevision.create((long)logEntry.getRevision());
            SVNURL url = this.myRepositoryRoot.appendPath(this.myLastPath, true);
            return new SvnFileRevision(this.myVcs, this.myPegRevision, rev, url.toString(), author, date, message, copyPath);
        }
    }

    private static class RepositoryLoader
    extends LogLoader {
        private final boolean myForceBackwards;

        private RepositoryLoader(SvnVcs vcs, FilePath file, SVNRevision from, SVNRevision to, int limit, SVNRevision peg, boolean forceBackwards, boolean showMergeSources) {
            super(vcs, file, from, to, limit, peg, showMergeSources);
            this.myForceBackwards = forceBackwards;
        }

        @Override
        protected void preliminary() throws SVNException {
            this.myUrl = this.myFile.getPath().replace('\\', '/');
        }

        @Override
        protected void load() {
            if (this.myPI != null) {
                this.myPI.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", this.myUrl));
            }
            try {
                SVNURL svnurl;
                if (this.myForceBackwards && !this.existsNow(svnurl = SVNURL.parseURIEncoded((String)this.myUrl))) {
                    this.loadBackwards(svnurl);
                    return;
                }
                svnurl = SVNURL.parseURIEncoded((String)this.myUrl);
                SVNRevision operationalFrom = this.myFrom == null ? SVNRevision.HEAD : this.myFrom;
                SVNURL rootURL = SvnUtil.getRepositoryRoot(this.myVcs, svnurl);
                if (rootURL == null) {
                    throw new VcsException("Could not find repository root for URL: " + this.myUrl);
                }
                String root = rootURL.toString();
                String relativeUrl = this.myUrl;
                if (this.myUrl.startsWith(root)) {
                    relativeUrl = this.myUrl.substring(root.length());
                }
                SvnTarget target = SvnTarget.fromURL((SVNURL)svnurl, (SVNRevision)(this.myPeg == null ? this.myFrom : this.myPeg));
                RepositoryLogEntryHandler handler = new RepositoryLogEntryHandler(this.myVcs, this.myUrl, SVNRevision.UNDEFINED, relativeUrl, (ThrowableConsumer<VcsFileRevision, SVNException>)SvnHistoryProvider.createConsumerAdapter((Consumer<VcsFileRevision>)this.myConsumer), rootURL);
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, operationalFrom, this.myTo == null ? SVNRevision.create((long)1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, this.myLimit, null, handler);
            }
            catch (SVNCancelException svnurl) {
            }
            catch (SVNException e) {
                this.myException = new VcsException((Throwable)e);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        private void loadBackwards(SVNURL svnurl) throws SVNException, VcsException {
            Info info = this.myVcs.getInfo(svnurl, this.myPeg, this.myPeg);
            SVNURL rootURL = info != null ? info.getRepositoryRootURL() : null;
            String root = rootURL != null ? rootURL.toString() : "";
            String relativeUrl = this.myUrl;
            if (this.myUrl.startsWith(root)) {
                relativeUrl = this.myUrl.substring(root.length());
            }
            RepositoryLogEntryHandler repositoryLogEntryHandler = new RepositoryLogEntryHandler(this.myVcs, this.myUrl, SVNRevision.UNDEFINED, relativeUrl, new ThrowableConsumer<VcsFileRevision, SVNException>(){

                public void consume(VcsFileRevision revision) throws SVNException {
                    RepositoryLoader.this.myConsumer.consume((Object)revision);
                }
            }, rootURL);
            repositoryLogEntryHandler.setThrowCancelOnMeetPathCreation(true);
            SvnTarget target = SvnTarget.fromURL((SVNURL)rootURL, (SVNRevision)this.myFrom);
            this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.myFrom, this.myTo == null ? SVNRevision.create((long)1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, 1L, null, repositoryLogEntryHandler);
        }

        private boolean existsNow(SVNURL svnurl) {
            Info info;
            try {
                info = this.myVcs.getInfo(svnurl, SVNRevision.HEAD, SVNRevision.HEAD);
            }
            catch (SvnBindException e) {
                return false;
            }
            return info != null && info.getURL() != null && info.getRevision().isValid();
        }
    }

    private static class LocalLoader
    extends LogLoader {
        private Info myInfo;

        private LocalLoader(SvnVcs vcs, FilePath file, SVNRevision from, SVNRevision to, int limit, SVNRevision peg, boolean showMergeSources) {
            super(vcs, file, from, to, limit, peg, showMergeSources);
        }

        @Override
        protected void preliminary() throws SVNException {
            this.myInfo = this.myVcs.getInfo(this.myFile.getIOFile());
            if (this.myInfo == null || this.myInfo.getRepositoryRootURL() == null) {
                this.myException = new VcsException("File " + this.myFile.getPath() + " is not under version control");
                return;
            }
            if (this.myInfo.getURL() == null) {
                this.myException = new VcsException("File " + this.myFile.getPath() + " is not under Subversion control");
                return;
            }
            this.myUrl = this.myInfo.getURL().toDecodedString();
        }

        @Override
        protected void load() {
            String relativeUrl = this.myUrl;
            SVNURL repoRootURL = this.myInfo.getRepositoryRootURL();
            String root = repoRootURL.toString();
            if (this.myUrl != null && this.myUrl.startsWith(root)) {
                relativeUrl = this.myUrl.substring(root.length());
            }
            if (this.myPI != null) {
                this.myPI.setText2(SvnBundle.message("progress.text2.changes.establishing.connection", this.myUrl));
            }
            SVNRevision pegRevision = this.myInfo.getRevision();
            SvnTarget target = SvnTarget.fromFile((File)this.myFile.getIOFile(), (SVNRevision)this.myPeg);
            try {
                this.myVcs.getFactory(target).createHistoryClient().doLog(target, this.myFrom == null ? SVNRevision.HEAD : this.myFrom, this.myTo == null ? SVNRevision.create((long)1L) : this.myTo, false, true, this.myShowMergeSources && this.mySupport15, this.myLimit, null, new MyLogEntryHandler(this.myVcs, this.myUrl, pegRevision, relativeUrl, (ThrowableConsumer<VcsFileRevision, SVNException>)SvnHistoryProvider.createConsumerAdapter((Consumer<VcsFileRevision>)this.myConsumer), repoRootURL, this.myFile.getCharset()));
            }
            catch (SVNCancelException sVNCancelException) {
            }
            catch (SVNException e) {
                this.myException = new VcsException((Throwable)e);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }
    }

    private static abstract class LogLoader {
        protected final boolean myShowMergeSources;
        protected String myUrl;
        protected boolean mySupport15;
        protected final SvnVcs myVcs;
        protected final FilePath myFile;
        protected final SVNRevision myFrom;
        protected final SVNRevision myTo;
        protected final int myLimit;
        protected final SVNRevision myPeg;
        protected Consumer<VcsFileRevision> myConsumer;
        protected final ProgressIndicator myPI;
        protected VcsException myException;

        protected LogLoader(SvnVcs vcs, FilePath file, SVNRevision from, SVNRevision to, int limit, SVNRevision peg, boolean showMergeSources) {
            this.myVcs = vcs;
            this.myFile = file;
            this.myFrom = from;
            this.myTo = to;
            this.myLimit = limit;
            this.myPeg = peg;
            this.myPI = ProgressManager.getInstance().getProgressIndicator();
            this.myShowMergeSources = showMergeSources;
        }

        public void setConsumer(Consumer<VcsFileRevision> consumer) {
            this.myConsumer = consumer;
        }

        protected void initSupports15() {
            assert (this.myUrl != null);
            this.mySupport15 = SvnUtil.checkRepositoryVersion15(this.myVcs, this.myUrl);
        }

        public void check() throws VcsException {
            if (this.myException != null) {
                throw this.myException;
            }
        }

        protected abstract void preliminary() throws SVNException;

        protected abstract void load();
    }
}

