/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.DefaultRepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;

public class CustomRepositoryMetadataManager
extends DefaultRepositoryMetadataManager {
    private MavenWorkspaceMap myWorkspaceMap;

    public void customize(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = workspaceMap;
    }

    public void reset() {
        this.myWorkspaceMap = null;
    }

    public void resolve(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        super.resolve(metadata, remoteRepositories, localRepository);
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return;
        }
        Metadata data = metadata.getMetadata();
        Versioning versioning = data.getVersioning();
        if (versioning == null) {
            versioning = new Versioning();
            data.setVersioning(versioning);
        }
        for (MavenId each : map.getAvailableIds()) {
            if (!each.equals(data.getGroupId(), data.getArtifactId())) continue;
            versioning.addVersion(each.getVersion());
        }
    }
}

