/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.JavaContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValueArray;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.StaticInitializer;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;

public class JavaVisitor {
    private static final int SAME_TYPE_COUNT = 8;
    private final Map<String, List<VisitingDetector>> mMethodDetectors = Maps.newHashMapWithExpectedSize((int)40);
    private final Map<String, List<VisitingDetector>> mConstructorDetectors = Maps.newHashMapWithExpectedSize((int)12);
    private Set<String> mConstructorSimpleNames;
    private final List<VisitingDetector> mResourceFieldDetectors = new ArrayList<VisitingDetector>();
    private final List<VisitingDetector> mAllDetectors;
    private final List<VisitingDetector> mFullTreeDetectors;
    private final Map<Class<? extends Node>, List<VisitingDetector>> mNodeTypeDetectors = new HashMap<Class<? extends Node>, List<VisitingDetector>>(16);
    private final JavaParser mParser;
    private final Map<String, List<VisitingDetector>> mSuperClassDetectors = new HashMap<String, List<VisitingDetector>>();

    JavaVisitor(@NonNull JavaParser parser, @NonNull List<Detector> detectors) {
        this.mParser = parser;
        this.mAllDetectors = new ArrayList<VisitingDetector>(detectors.size());
        this.mFullTreeDetectors = new ArrayList<VisitingDetector>(detectors.size());
        for (Detector detector : detectors) {
            List<String> types;
            List<String> list;
            VisitingDetector v = new VisitingDetector(detector, (Detector.JavaScanner)((Object)detector));
            this.mAllDetectors.add(v);
            List<String> applicableSuperClasses = detector.applicableSuperClasses();
            if (applicableSuperClasses != null) {
                for (String string : applicableSuperClasses) {
                    List<VisitingDetector> list2 = this.mSuperClassDetectors.get(string);
                    if (list2 == null) {
                        list2 = new ArrayList<VisitingDetector>(8);
                        this.mSuperClassDetectors.put(string, list2);
                    }
                    list2.add(v);
                }
                continue;
            }
            List<Class<? extends Node>> nodeTypes = detector.getApplicableNodeTypes();
            if (nodeTypes != null) {
                for (Class<? extends Node> type : nodeTypes) {
                    List<VisitingDetector> list3 = this.mNodeTypeDetectors.get(type);
                    if (list3 == null) {
                        list3 = new ArrayList<VisitingDetector>(8);
                        this.mNodeTypeDetectors.put(type, list3);
                    }
                    list3.add(v);
                }
            }
            if ((list = detector.getApplicableMethodNames()) != null) {
                Class<? extends Node> type;
                assert (list != Detector.XmlScanner.ALL);
                type = list.iterator();
                while (type.hasNext()) {
                    String name = (String)type.next();
                    List<VisitingDetector> list4 = this.mMethodDetectors.get(name);
                    if (list4 == null) {
                        list4 = new ArrayList<VisitingDetector>(8);
                        this.mMethodDetectors.put(name, list4);
                    }
                    list4.add(v);
                }
            }
            if ((types = detector.getApplicableConstructorTypes()) != null) {
                assert (types != Detector.XmlScanner.ALL);
                if (this.mConstructorSimpleNames == null) {
                    this.mConstructorSimpleNames = Sets.newHashSet();
                }
                for (String type : types) {
                    List<VisitingDetector> list5 = this.mConstructorDetectors.get(type);
                    if (list5 == null) {
                        list5 = new ArrayList<VisitingDetector>(8);
                        this.mConstructorDetectors.put(type, list5);
                        this.mConstructorSimpleNames.add(type.substring(type.lastIndexOf(46) + 1));
                    }
                    list5.add(v);
                }
            }
            if (detector.appliesToResourceRefs()) {
                this.mResourceFieldDetectors.add(v);
                continue;
            }
            if (list != null && !list.isEmpty() || nodeTypes != null && !nodeTypes.isEmpty() || types != null && !types.isEmpty()) continue;
            this.mFullTreeDetectors.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(@NonNull JavaContext context) {
        Node compilationUnit = null;
        try {
            Object visitor;
            compilationUnit = this.mParser.parseJava(context);
            if (compilationUnit == null) {
                return;
            }
            context.setCompilationUnit(compilationUnit);
            for (VisitingDetector v : this.mAllDetectors) {
                v.setContext(context);
                v.getDetector().beforeCheckFile(context);
            }
            if (!this.mSuperClassDetectors.isEmpty()) {
                visitor = new SuperclassVisitor(context);
                compilationUnit.accept(visitor);
            }
            for (VisitingDetector v : this.mFullTreeDetectors) {
                AstVisitor visitor2 = v.getVisitor();
                compilationUnit.accept(visitor2);
            }
            if (!(this.mMethodDetectors.isEmpty() && this.mResourceFieldDetectors.isEmpty() && this.mConstructorDetectors.isEmpty())) {
                visitor = new DelegatingJavaVisitor(context);
                compilationUnit.accept(visitor);
            } else if (!this.mNodeTypeDetectors.isEmpty()) {
                visitor = new DispatchVisitor();
                compilationUnit.accept(visitor);
            }
            for (VisitingDetector v : this.mAllDetectors) {
                v.getDetector().afterCheckFile(context);
            }
        }
        finally {
            if (compilationUnit != null) {
                this.mParser.dispose(context, compilationUnit);
            }
        }
    }

    public void prepare(@NonNull List<JavaContext> contexts) {
        this.mParser.prepareJavaParse(contexts);
    }

    public void dispose() {
        this.mParser.dispose();
    }

    private class DelegatingJavaVisitor
    extends DispatchVisitor {
        private final JavaContext mContext;
        private final boolean mVisitResources;
        private final boolean mVisitMethods;
        private final boolean mVisitConstructors;

        public DelegatingJavaVisitor(JavaContext context) {
            this.mContext = context;
            this.mVisitMethods = !JavaVisitor.this.mMethodDetectors.isEmpty();
            this.mVisitConstructors = !JavaVisitor.this.mConstructorDetectors.isEmpty();
            this.mVisitResources = !JavaVisitor.this.mResourceFieldDetectors.isEmpty();
        }

        @Override
        public boolean visitSelect(Select node) {
            if (this.mVisitResources) {
                Node grandParent;
                Node parent;
                VariableReference reference;
                Select select;
                if (node.astOperand() instanceof Select && (select = (Select)node.astOperand()).astOperand() instanceof VariableReference && (reference = (VariableReference)select.astOperand()).astIdentifier().astValue().equals("R")) {
                    String type = select.astIdentifier().astValue();
                    String name = node.astIdentifier().astValue();
                    boolean isFramework = false;
                    for (VisitingDetector v : JavaVisitor.this.mResourceFieldDetectors) {
                        Detector.JavaScanner detector = v.getJavaScanner();
                        detector.visitResourceReference(this.mContext, v.getVisitor(), (Node)node, type, name, isFramework);
                    }
                    return super.visitSelect(node);
                }
                if (node.astIdentifier().astValue().equals("R") && (parent = node.getParent()) instanceof Select && (grandParent = parent.getParent()) instanceof Select) {
                    Select select2 = (Select)grandParent;
                    String name = select2.astIdentifier().astValue();
                    Expression typeOperand = select2.astOperand();
                    if (typeOperand instanceof Select) {
                        Select typeSelect = (Select)typeOperand;
                        String type = typeSelect.astIdentifier().astValue();
                        boolean isFramework = node.astIdentifier().astValue().equals("android");
                        for (VisitingDetector v : JavaVisitor.this.mResourceFieldDetectors) {
                            Detector.JavaScanner detector = v.getJavaScanner();
                            detector.visitResourceReference(this.mContext, v.getVisitor(), (Node)node, type, name, isFramework);
                        }
                    }
                }
            }
            return super.visitSelect(node);
        }

        @Override
        public boolean visitMethodInvocation(MethodInvocation node) {
            if (this.mVisitMethods) {
                String methodName = node.astName().astValue();
                List list = (List)JavaVisitor.this.mMethodDetectors.get(methodName);
                if (list != null) {
                    for (VisitingDetector v : list) {
                        v.getJavaScanner().visitMethod(this.mContext, v.getVisitor(), node);
                    }
                }
            }
            return super.visitMethodInvocation(node);
        }

        @Override
        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            TypeReferencePart last;
            TypeReference typeReference;
            if (this.mVisitConstructors && (typeReference = node.astTypeReference()) != null && (last = (TypeReferencePart)typeReference.astParts().last()) != null) {
                JavaParser.ResolvedNode resolved;
                String name = last.astIdentifier().astValue();
                if (JavaVisitor.this.mConstructorSimpleNames.contains(name) && (resolved = this.mContext.resolve((Node)node)) instanceof JavaParser.ResolvedMethod) {
                    JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                    String type = method.getContainingClass().getSignature();
                    List list = (List)JavaVisitor.this.mConstructorDetectors.get(type);
                    if (list != null) {
                        for (VisitingDetector v : list) {
                            v.getJavaScanner().visitConstructor(this.mContext, v.getVisitor(), node, method);
                        }
                    }
                }
            }
            return super.visitConstructorInvocation(node);
        }
    }

    private class DispatchVisitor
    extends ForwardingAstVisitor {
        private DispatchVisitor() {
        }

        public void endVisit(Node node) {
            for (VisitingDetector v : JavaVisitor.this.mAllDetectors) {
                v.getVisitor().endVisit(node);
            }
        }

        public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AlternateConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAlternateConstructorInvocation(node);
                }
            }
            return false;
        }

        public boolean visitAnnotation(Annotation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Annotation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotation(node);
                }
            }
            return false;
        }

        public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitAnnotationElement(AnnotationElement node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationElement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationElement(node);
                }
            }
            return false;
        }

        public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationMethodDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationMethodDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitAnnotationValueArray(AnnotationValueArray node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(AnnotationValueArray.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAnnotationValueArray(node);
                }
            }
            return false;
        }

        public boolean visitArrayAccess(ArrayAccess node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayAccess.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayAccess(node);
                }
            }
            return false;
        }

        public boolean visitArrayCreation(ArrayCreation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayCreation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayCreation(node);
                }
            }
            return false;
        }

        public boolean visitArrayDimension(ArrayDimension node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayDimension.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayDimension(node);
                }
            }
            return false;
        }

        public boolean visitArrayInitializer(ArrayInitializer node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ArrayInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitArrayInitializer(node);
                }
            }
            return false;
        }

        public boolean visitAssert(Assert node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Assert.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitAssert(node);
                }
            }
            return false;
        }

        public boolean visitBinaryExpression(BinaryExpression node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(BinaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBinaryExpression(node);
                }
            }
            return false;
        }

        public boolean visitBlock(Block node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Block.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBlock(node);
                }
            }
            return false;
        }

        public boolean visitBooleanLiteral(BooleanLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(BooleanLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBooleanLiteral(node);
                }
            }
            return false;
        }

        public boolean visitBreak(Break node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Break.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitBreak(node);
                }
            }
            return false;
        }

        public boolean visitCase(Case node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Case.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCase(node);
                }
            }
            return false;
        }

        public boolean visitCast(Cast node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Cast.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCast(node);
                }
            }
            return false;
        }

        public boolean visitCatch(Catch node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Catch.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCatch(node);
                }
            }
            return false;
        }

        public boolean visitCharLiteral(CharLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(CharLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCharLiteral(node);
                }
            }
            return false;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ClassDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitClassLiteral(ClassLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ClassLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitClassLiteral(node);
                }
            }
            return false;
        }

        public boolean visitComment(Comment node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Comment.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitComment(node);
                }
            }
            return false;
        }

        public boolean visitCompilationUnit(CompilationUnit node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(CompilationUnit.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitCompilationUnit(node);
                }
            }
            return false;
        }

        public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ConstructorDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitConstructorDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitConstructorInvocation(node);
                }
            }
            return false;
        }

        public boolean visitContinue(Continue node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Continue.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitContinue(node);
                }
            }
            return false;
        }

        public boolean visitDefault(Default node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Default.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDefault(node);
                }
            }
            return false;
        }

        public boolean visitDoWhile(DoWhile node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(DoWhile.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitDoWhile(node);
                }
            }
            return false;
        }

        public boolean visitEmptyDeclaration(EmptyDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EmptyDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEmptyDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitEmptyStatement(EmptyStatement node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EmptyStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEmptyStatement(node);
                }
            }
            return false;
        }

        public boolean visitEnumConstant(EnumConstant node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumConstant.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumConstant(node);
                }
            }
            return false;
        }

        public boolean visitEnumDeclaration(EnumDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitEnumTypeBody(EnumTypeBody node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(EnumTypeBody.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitEnumTypeBody(node);
                }
            }
            return false;
        }

        public boolean visitExpressionStatement(ExpressionStatement node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ExpressionStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitExpressionStatement(node);
                }
            }
            return false;
        }

        public boolean visitFloatingPointLiteral(FloatingPointLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(FloatingPointLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitFloatingPointLiteral(node);
                }
            }
            return false;
        }

        public boolean visitFor(For node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(For.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitFor(node);
                }
            }
            return false;
        }

        public boolean visitForEach(ForEach node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ForEach.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitForEach(node);
                }
            }
            return false;
        }

        public boolean visitIdentifier(Identifier node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Identifier.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIdentifier(node);
                }
            }
            return false;
        }

        public boolean visitIf(If node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(If.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIf(node);
                }
            }
            return false;
        }

        public boolean visitImportDeclaration(ImportDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(ImportDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitImportDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitInlineIfExpression(InlineIfExpression node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InlineIfExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInlineIfExpression(node);
                }
            }
            return false;
        }

        public boolean visitInstanceInitializer(InstanceInitializer node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InstanceInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInstanceInitializer(node);
                }
            }
            return false;
        }

        public boolean visitInstanceOf(InstanceOf node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InstanceOf.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInstanceOf(node);
                }
            }
            return false;
        }

        public boolean visitIntegralLiteral(IntegralLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(IntegralLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitIntegralLiteral(node);
                }
            }
            return false;
        }

        public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(InterfaceDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitInterfaceDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitKeywordModifier(KeywordModifier node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(KeywordModifier.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitKeywordModifier(node);
                }
            }
            return false;
        }

        public boolean visitLabelledStatement(LabelledStatement node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(LabelledStatement.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitLabelledStatement(node);
                }
            }
            return false;
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(MethodDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethodDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(MethodInvocation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitMethodInvocation(node);
                }
            }
            return false;
        }

        public boolean visitModifiers(Modifiers node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Modifiers.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitModifiers(node);
                }
            }
            return false;
        }

        public boolean visitNormalTypeBody(NormalTypeBody node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(NormalTypeBody.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitNormalTypeBody(node);
                }
            }
            return false;
        }

        public boolean visitNullLiteral(NullLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(NullLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitNullLiteral(node);
                }
            }
            return false;
        }

        public boolean visitPackageDeclaration(PackageDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(PackageDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitPackageDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitParseArtefact(Node node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Node.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitParseArtefact(node);
                }
            }
            return false;
        }

        public boolean visitReturn(Return node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Return.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitReturn(node);
                }
            }
            return false;
        }

        public boolean visitSelect(Select node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Select.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSelect(node);
                }
            }
            return false;
        }

        public boolean visitStaticInitializer(StaticInitializer node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(StaticInitializer.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitStaticInitializer(node);
                }
            }
            return false;
        }

        public boolean visitStringLiteral(StringLiteral node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(StringLiteral.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitStringLiteral(node);
                }
            }
            return false;
        }

        public boolean visitSuper(Super node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Super.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSuper(node);
                }
            }
            return false;
        }

        public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(SuperConstructorInvocation.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSuperConstructorInvocation(node);
                }
            }
            return false;
        }

        public boolean visitSwitch(Switch node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Switch.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSwitch(node);
                }
            }
            return false;
        }

        public boolean visitSynchronized(Synchronized node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Synchronized.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitSynchronized(node);
                }
            }
            return false;
        }

        public boolean visitThis(This node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(This.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThis(node);
                }
            }
            return false;
        }

        public boolean visitThrow(Throw node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Throw.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitThrow(node);
                }
            }
            return false;
        }

        public boolean visitTry(Try node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(Try.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTry(node);
                }
            }
            return false;
        }

        public boolean visitTypeReference(TypeReference node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeReference.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeReference(node);
                }
            }
            return false;
        }

        public boolean visitTypeReferencePart(TypeReferencePart node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeReferencePart.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeReferencePart(node);
                }
            }
            return false;
        }

        public boolean visitTypeVariable(TypeVariable node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(TypeVariable.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitTypeVariable(node);
                }
            }
            return false;
        }

        public boolean visitUnaryExpression(UnaryExpression node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(UnaryExpression.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitUnaryExpression(node);
                }
            }
            return false;
        }

        public boolean visitVariableDeclaration(VariableDeclaration node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDeclaration.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariableDeclaration(node);
                }
            }
            return false;
        }

        public boolean visitVariableDefinition(VariableDefinition node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDefinition.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariableDefinition(node);
                }
            }
            return false;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableDefinitionEntry.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariableDefinitionEntry(node);
                }
            }
            return false;
        }

        public boolean visitVariableReference(VariableReference node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(VariableReference.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitVariableReference(node);
                }
            }
            return false;
        }

        public boolean visitWhile(While node) {
            List list = (List)JavaVisitor.this.mNodeTypeDetectors.get(While.class);
            if (list != null) {
                for (VisitingDetector v : list) {
                    v.getVisitor().visitWhile(node);
                }
            }
            return false;
        }
    }

    private class SuperclassVisitor
    extends ForwardingAstVisitor {
        private JavaContext mContext;

        public SuperclassVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitClassDeclaration(ClassDeclaration node) {
            JavaParser.ResolvedClass resolvedClass;
            JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)node);
            if (!(resolved instanceof JavaParser.ResolvedClass)) {
                return true;
            }
            for (JavaParser.ResolvedClass cls = resolvedClass = (JavaParser.ResolvedClass)resolved; cls != null; cls = cls.getSuperClass()) {
                List list;
                String fqcn = cls.getSignature();
                if (fqcn == null || (list = (List)JavaVisitor.this.mSuperClassDetectors.get(fqcn)) == null) continue;
                for (VisitingDetector v : list) {
                    v.getJavaScanner().checkClass(this.mContext, node, (Node)node, resolvedClass);
                }
            }
            return false;
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            NormalTypeBody anonymous = node.astAnonymousClassBody();
            if (anonymous != null) {
                JavaParser.ResolvedClass resolvedClass;
                JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)anonymous);
                if (resolved instanceof JavaParser.ResolvedMethod) {
                    resolved = ((JavaParser.ResolvedMethod)resolved).getContainingClass();
                }
                if (!(resolved instanceof JavaParser.ResolvedClass)) {
                    return true;
                }
                for (JavaParser.ResolvedClass cls = resolvedClass = (JavaParser.ResolvedClass)resolved; cls != null; cls = cls.getSuperClass()) {
                    List list;
                    String fqcn = cls.getSignature();
                    if (fqcn == null || (list = (List)JavaVisitor.this.mSuperClassDetectors.get(fqcn)) == null) continue;
                    for (VisitingDetector v : list) {
                        v.getJavaScanner().checkClass(this.mContext, null, (Node)anonymous, resolvedClass);
                    }
                }
            }
            return true;
        }

        public boolean visitImportDeclaration(ImportDeclaration node) {
            return true;
        }
    }

    private static class VisitingDetector {
        private AstVisitor mVisitor;
        private JavaContext mContext;
        public final Detector mDetector;
        public final Detector.JavaScanner mJavaScanner;

        public VisitingDetector(@NonNull Detector detector, @NonNull Detector.JavaScanner javaScanner) {
            this.mDetector = detector;
            this.mJavaScanner = javaScanner;
        }

        @NonNull
        public Detector getDetector() {
            return this.mDetector;
        }

        @NonNull
        public Detector.JavaScanner getJavaScanner() {
            return this.mJavaScanner;
        }

        public void setContext(@NonNull JavaContext context) {
            this.mContext = context;
            this.mVisitor = null;
        }

        @NonNull
        AstVisitor getVisitor() {
            if (this.mVisitor == null) {
                this.mVisitor = this.mDetector.createJavaVisitor(this.mContext);
                if (this.mVisitor == null) {
                    this.mVisitor = new ForwardingAstVisitor(){};
                }
            }
            return this.mVisitor;
        }
    }
}

