/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenExecutionRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerSettings;

public abstract class Maven3ServerEmbedder
extends MavenRemoteObject
implements MavenServerEmbedder {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");

    public Maven3ServerEmbedder(MavenServerSettings settings) {
        Maven3ServerEmbedder.initLog4J(settings);
    }

    private static void initLog4J(MavenServerSettings settings) {
        try {
            BasicConfigurator.configure();
            Level rootLoggerLevel = Maven3ServerEmbedder.toLog4JLevel(settings.getLoggingLevel());
            Logger.getRootLogger().setLevel(rootLoggerLevel);
            if (!rootLoggerLevel.isGreaterOrEqual((Priority)Level.ERROR)) {
                Logger.getLogger((String)"org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toLog4JLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.ERROR;
            }
            case 4: {
                return Level.FATAL;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    protected abstract ArtifactRepository getLocalRepository();

    @NotNull
    public List<String> retrieveAvailableVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull String remoteRepositoryUrl) throws RemoteException {
        ArrayList arrayList;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        if (remoteRepositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteRepositoryUrl", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "", "compile", "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            MavenArtifactRepository remoteRepository = new MavenArtifactRepository("id", remoteRepositoryUrl, this.getComponent(ArtifactRepositoryLayout.class), new ArtifactRepositoryPolicy(true, "daily", "warn"), new ArtifactRepositoryPolicy(true, "daily", "warn"));
            List versions = this.getComponent(ArtifactMetadataSource.class).retrieveAvailableVersions((Artifact)artifact, this.getLocalRepository(), Collections.singletonList(remoteRepository));
            arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)versions, (Function)new Function<ArtifactVersion, String>(){

                public String apply(ArtifactVersion version) {
                    return version.toString();
                }
            }));
        }
        catch (Exception e) {
            Maven3ServerGlobals.getLogger().info(e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
            }
            return list;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven3ServerEmbedder", "retrieveAvailableVersions"));
        }
        return arrayList;
    }

    @Nullable
    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    public abstract void executeWithMavenSession(MavenExecutionRequest var1, Runnable var2);

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3, List<String> var4) throws RemoteException;
}

