/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.IDEACoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCoverageSuite
extends BaseCoverageSuite {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageSuite.class.getName());
    private String[] myFilters;
    private String mySuiteToMerge;
    @NonNls
    private static final String FILTER = "FILTER";
    @NonNls
    private static final String MERGE_SUITE = "MERGE_SUITE";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    private final CoverageEngine myCoverageEngine;

    public JavaCoverageSuite(@NotNull JavaCoverageEngine coverageSupportProvider) {
        if (coverageSupportProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageSupportProvider", "com/intellij/coverage/JavaCoverageSuite", "<init>"));
        }
        this.myCoverageEngine = coverageSupportProvider;
    }

    /*
     * WARNING - void declaration
     */
    public JavaCoverageSuite(String name, CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner, @NotNull JavaCoverageEngine coverageSupportProvider, Project project) {
        void project2;
        if (coverageSupportProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageSupportProvider", "com/intellij/coverage/JavaCoverageSuite", "<init>"));
        }
        super(name, coverageDataFileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, coverageRunner != null ? coverageRunner : CoverageRunner.getInstance(IDEACoverageRunner.class), (Project)project2);
        this.myFilters = filters;
        this.myCoverageEngine = coverageSupportProvider;
    }

    @NotNull
    public String[] getFilteredPackageNames() {
        if (this.myFilters == null || this.myFilters.length == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getFilteredPackageNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : this.myFilters) {
            if (filter.equals("*")) {
                result.add("");
                continue;
            }
            if (!filter.endsWith(".*")) continue;
            result.add(filter.substring(0, filter.length() - 2));
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getFilteredPackageNames"));
        }
        return stringArray;
    }

    @NotNull
    public String[] getFilteredClassNames() {
        if (this.myFilters == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getFilteredClassNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String filter : this.myFilters) {
            if (filter.equals("*") || filter.endsWith(".*")) continue;
            result.add(filter);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getFilteredClassNames"));
        }
        return stringArray;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        List children = element.getChildren(FILTER);
        ArrayList<String> filters = new ArrayList<String>();
        for (Element child : children) {
            filters.add(child.getValue());
        }
        this.myFilters = filters.isEmpty() ? null : ArrayUtil.toStringArray(filters);
        this.mySuiteToMerge = element.getAttributeValue(MERGE_SUITE);
        if (this.getRunner() == null) {
            this.setRunner(CoverageRunner.getInstance(IDEACoverageRunner.class));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        CoverageRunner coverageRunner;
        super.writeExternal(element);
        if (this.mySuiteToMerge != null) {
            element.setAttribute(MERGE_SUITE, this.mySuiteToMerge);
        }
        if (this.myFilters != null) {
            for (String filter : this.myFilters) {
                Element filterElement = new Element(FILTER);
                filterElement.setText(filter);
                element.addContent(filterElement);
            }
        }
        element.setAttribute(COVERAGE_RUNNER, (coverageRunner = this.getRunner()) != null ? coverageRunner.getId() : "emma");
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData data = this.getCoverageData();
        if (data != null) {
            return data;
        }
        ProjectData map = this.loadProjectInfo();
        if (this.mySuiteToMerge != null) {
            CoverageSuite[] suites;
            JavaCoverageSuite toMerge = null;
            for (CoverageSuite suite : suites = coverageDataManager.getSuites()) {
                if (!Comparing.strEqual((String)suite.getPresentableName(), (String)this.mySuiteToMerge)) continue;
                if (Comparing.strEqual((String)((JavaCoverageSuite)suite).getSuiteToMerge(), (String)this.getPresentableName())) break;
                toMerge = (JavaCoverageSuite)suite;
                break;
            }
            if (toMerge != null) {
                ProjectData projectInfo = toMerge.getCoverageData(coverageDataManager);
                if (map != null) {
                    map.merge((CoverageData)projectInfo);
                } else {
                    map = projectInfo;
                }
            }
        }
        this.setCoverageData(map);
        return map;
    }

    @Override
    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myCoverageEngine;
        if (coverageEngine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getCoverageEngine"));
        }
        return coverageEngine;
    }

    @Nullable
    public String getSuiteToMerge() {
        return this.mySuiteToMerge;
    }

    public boolean isClassFiltered(String classFQName) {
        for (String className : this.getFilteredClassNames()) {
            if (!className.equals(classFQName) && (!classFQName.startsWith(className) || classFQName.charAt(className.length()) != '$')) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageFiltered(String packageFQName) {
        String[] filteredPackageNames;
        for (String packName : filteredPackageNames = this.getFilteredPackageNames()) {
            if (!packName.equals(packageFQName) && (!packageFQName.startsWith(packName) || packageFQName.charAt(packName.length()) != '.')) continue;
            return true;
        }
        return filteredPackageNames.length == 0 && this.getFilteredClassNames().length == 0;
    }

    @NotNull
    public List<PsiPackage> getCurrentSuitePackages(final Project project) {
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiPackage>>(){

            public List<PsiPackage> compute() {
                ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                String[] filters = JavaCoverageSuite.this.getFilteredPackageNames();
                if (filters.length == 0) {
                    if (JavaCoverageSuite.this.getFilteredClassNames().length > 0) {
                        return Collections.emptyList();
                    }
                    PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage("");
                    if (defaultPackage != null) {
                        packages.add(defaultPackage);
                    }
                } else {
                    ArrayList<String> nonInherited = new ArrayList<String>();
                    for (String filter : filters) {
                        if (JavaCoverageSuite.isSubPackage(filters, filter)) continue;
                        nonInherited.add(filter);
                    }
                    for (String filter : nonInherited) {
                        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(filter);
                        if (psiPackage == null) continue;
                        packages.add(psiPackage);
                    }
                }
                return packages;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getCurrentSuitePackages"));
        }
        return list;
    }

    private static boolean isSubPackage(String[] filters, String filter) {
        for (String supPackageFilter : filters) {
            if (!filter.startsWith(supPackageFilter + ".")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<PsiClass> getCurrentSuiteClasses(final Project project) {
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        String[] classNames = this.getFilteredClassNames();
        if (classNames.length > 0) {
            for (final String className : classNames) {
                PsiClass aClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

                    @Nullable
                    public PsiClass compute() {
                        return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className.replace("$", "."), GlobalSearchScope.allScope((Project)project));
                    }
                });
                if (aClass == null) continue;
                classes.add(aClass);
            }
        }
        ArrayList<PsiClass> arrayList = classes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/JavaCoverageSuite", "getCurrentSuiteClasses"));
        }
        return arrayList;
    }
}

