/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope$$TImpl;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScopeSelectorUtil;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedScope
implements JetScope {
    public static final /* synthetic */ KClass $kotlinClass;
    private final JetScope[] scopeChain;
    private List<? extends ReceiverParameterDescriptor> implicitReceiverHierarchy;
    private final DeclarationDescriptor containingDeclaration;
    private final String debugName;

    static {
        $kotlinClass = Reflection.createKotlinClass(ChainedScope.class);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@JetValueParameter(name="name") @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@JetValueParameter(name="name") @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.PACKAGE_SCOPE_SELECTOR);
    }

    @NotNull
    public Set<VariableDescriptor> getProperties(@JetValueParameter(name="name") @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Set<VariableDescriptor> set = JetScopeSelectorUtil.getFromAllScopes(this.scopeChain, name, JetScopeSelectorUtil.NAMED_PROPERTIES_SCOPE_SELECTOR);
        Intrinsics.checkExpressionValueIsNotNull(set, "getFromAllScopes(scopeCh\u2026ROPERTIES_SCOPE_SELECTOR)");
        return set;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@JetValueParameter(name="name") @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return JetScopeSelectorUtil.getFirstMatch(this.scopeChain, name, JetScopeSelectorUtil.VARIABLE_DESCRIPTOR_SCOPE_SELECTOR);
    }

    @NotNull
    public Set<FunctionDescriptor> getFunctions(@JetValueParameter(name="name") @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Set<FunctionDescriptor> set = JetScopeSelectorUtil.getFromAllScopes(this.scopeChain, name, JetScopeSelectorUtil.NAMED_FUNCTION_SCOPE_SELECTOR);
        Intrinsics.checkExpressionValueIsNotNull(set, "getFromAllScopes(scopeCh\u2026_FUNCTION_SCOPE_SELECTOR)");
        return set;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        if (this.implicitReceiverHierarchy == null) {
            ArrayList result = new ArrayList();
            Object[] $receiver = this.scopeChain;
            for (int i = 0; i < $receiver.length; ++i) {
                Object element = $receiver[i];
                JetScope it = (JetScope)element;
                Iterable list = it.getImplicitReceiversHierarchy();
                KotlinPackage.addAll((Collection)result, list);
            }
            result.trimToSize();
            this.implicitReceiverHierarchy = result;
        }
        List<ReceiverParameterDescriptor> list = this.implicitReceiverHierarchy;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration;
        if (declarationDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return declarationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DeclarationDescriptor> getDeclarationsByLabel(@JetValueParameter(name="labelName") @NotNull Name labelName) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(labelName, "labelName");
        Object[] $receiver2 = this.scopeChain;
        Object[] objectArray = $receiver2;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            JetScope it = (JetScope)element;
            Iterable list = it.getDeclarationsByLabel(labelName);
            KotlinPackage.addAll(destination, list);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDescriptors(@JetValueParameter(name="kindFilter") @NotNull DescriptorKindFilter kindFilter, @JetValueParameter(name="nameFilter") @NotNull Function1<? super Name, ? extends Boolean> nameFilter) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(kindFilter, "kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, "nameFilter");
        LinkedHashSet result = new LinkedHashSet();
        Object[] objectArray = this.scopeChain;
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            JetScope it = (JetScope)element;
            Iterable list = it.getDescriptors(kindFilter, nameFilter);
            KotlinPackage.addAll((Collection)result, list);
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @Override
    public void printScopeStructure(@JetValueParameter(name="p") @NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull(p, "p");
        p.println(this.getClass().getSimpleName(), ": ", this.debugName, " {");
        p.pushIndent();
        JetScope[] jetScopeArray = this.scopeChain;
        for (int i = 0; i < jetScopeArray.length; ++i) {
            JetScope scope2 = jetScopeArray[i];
            scope2.printScopeStructure(p);
        }
        p.popIndent();
        p.println("}");
    }

    public ChainedScope(@JetValueParameter(name="containingDeclaration", type="?") @Nullable DeclarationDescriptor containingDeclaration, @JetValueParameter(name="debugName") @NotNull String debugName, JetScope ... scopes) {
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        Intrinsics.checkParameterIsNotNull(scopes, "scopes");
        this.containingDeclaration = containingDeclaration;
        this.debugName = debugName;
        this.scopeChain = (JetScope[])((Object[])scopes).clone();
    }

    @Override
    @NotNull
    public final Collection<DeclarationDescriptor> getAllDescriptors() {
        return JetScope$$TImpl.getAllDescriptors(this);
    }
}

