/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractJetType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.jetbrains.annotations.NotNull;

public final class JetTypeImpl
extends AbstractJetType {
    private final TypeConstructor constructor;
    private final List<? extends TypeProjection> arguments;
    private final boolean nullable;
    private final JetScope memberScope;
    private final Annotations annotations;

    public JetTypeImpl(@NotNull Annotations annotations2, @NotNull TypeConstructor constructor2, boolean nullable2, @NotNull List<? extends TypeProjection> arguments2, @NotNull JetScope memberScope2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "<init>"));
        }
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "<init>"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "<init>"));
        }
        if (memberScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberScope", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "<init>"));
        }
        this.annotations = annotations2;
        if (memberScope2 instanceof ErrorUtils.ErrorScope) {
            throw new IllegalStateException("JetTypeImpl should not be created for error type: " + memberScope2 + "\n" + constructor2);
        }
        this.constructor = constructor2;
        this.nullable = nullable2;
        this.arguments = arguments2;
        this.memberScope = memberScope2;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "getAnnotations"));
        }
        return annotations2;
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor2 = this.constructor;
        if (typeConstructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "getConstructor"));
        }
        return typeConstructor2;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/types/JetTypeImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return false;
    }
}

