/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class CommandLineWrapperUtil {
    @NotNull
    public static File createClasspathJarFile(Manifest manifest, List<String> pathList) throws IOException {
        File file = CommandLineWrapperUtil.createClasspathJarFile(manifest, pathList, false);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineWrapperUtil", "createClasspathJarFile"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File createClasspathJarFile(Manifest manifest, List<String> pathList, final boolean notEscape) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        final Ref ex = new Ref();
        String classPathAttribute = StringUtil.join(pathList, new Function<String, String>(){

            @Override
            public String fun(String path) {
                File classpathElement = new File(path);
                try {
                    return (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
                }
                catch (IOException e) {
                    ex.set(e);
                    return null;
                }
            }
        }, " ");
        IOException thrownException = (IOException)ex.get();
        if (thrownException != null) {
            throw thrownException;
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPathAttribute);
        File jarFile = FileUtil.createTempFile("classpath", ".jar");
        ZipOutputStream jarPlugin = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jarFile));
            jarPlugin = new JarOutputStream((OutputStream)out, manifest);
        }
        finally {
            if (jarPlugin != null) {
                jarPlugin.close();
            }
        }
        File file = jarFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineWrapperUtil", "createClasspathJarFile"));
        }
        return file;
    }
}

