/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    protected final Meta<T> meta;
    protected final Function<T, ? extends Iterable<? extends T>> tree;

    protected FilteredTraverserBase(@Nullable Meta<T> meta, Function<T, ? extends Iterable<? extends T>> tree) {
        this.tree = tree;
        this.meta = meta == null ? Meta.empty() : meta;
    }

    @NotNull
    public T getRoot() {
        Object t = this.meta.roots.iterator().next();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "getRoot"));
        }
        return t;
    }

    @NotNull
    public Iterable<? extends T> getRoots() {
        Iterable iterable = this.meta.roots;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "getRoots"));
        }
        return iterable;
    }

    @Override
    public Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public JBIterable<T> traverse(TreeTraversal traversal) {
        Function adjusted = new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> fun(T t) {
                return FilteredTraverserBase.this.children(t);
            }
        };
        JBIterable jBIterable = traversal.traversal(this.getRoots(), adjusted).filter(this.meta.resultFilter);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "traverse"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<T> traverse() {
        JBIterable<T> jBIterable = this.traverse(this.meta.traversal);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "traverse"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PRE_ORDER_DFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "preOrderDfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.POST_ORDER_DFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "postOrderDfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> leavesOnlyDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.LEAVES_ONLY_DFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "leavesOnlyDfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PLAIN_BFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "bfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.TRACING_BFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "tracingBfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> leavesOnlyBfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.LEAVES_ONLY_BFS);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "leavesOnlyBfsTraversal"));
        }
        return jBIterable;
    }

    @NotNull
    public Self reset() {
        Self Self2 = this.newInstance(Meta.empty().forceExclude(this.meta.forceExclude).forceExpandAndSkip(this.meta.forceExpandAndSkip).withRoots(this.meta.roots));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "reset"));
        }
        return Self2;
    }

    @NotNull
    public Self withRoot(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/util/containers/FilteredTraverserBase", "withRoot"));
        }
        Self Self2 = this.newInstance(this.meta.withRoots(Collections.singleton(root)));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withRoot"));
        }
        return Self2;
    }

    @NotNull
    public Self withRoots(@NotNull Iterable<? extends T> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase", "withRoots"));
        }
        Self Self2 = this.newInstance(this.meta.withRoots(roots));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withRoots"));
        }
        return Self2;
    }

    @NotNull
    public Self withTraversal(TreeTraversal type) {
        Self Self2 = this.newInstance(this.meta.withTraversal(type));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "withTraversal"));
        }
        return Self2;
    }

    @NotNull
    public Self expand(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase", "expand"));
        }
        Self Self2 = this.newInstance(this.meta.expand(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expand"));
        }
        return Self2;
    }

    @NotNull
    public Self expandAndFilter(Condition<? super T> filter) {
        Self Self2 = this.newInstance(this.meta.expand(filter).filter(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expandAndFilter"));
        }
        return Self2;
    }

    @NotNull
    public Self expandAndSkip(Condition<? super T> filter) {
        Self Self2 = this.newInstance(this.meta.expand(filter).filter(Conditions.not(filter)));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "expandAndSkip"));
        }
        return Self2;
    }

    @NotNull
    public Self children(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase", "children"));
        }
        Self Self2 = this.newInstance(this.meta.children(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
        }
        return Self2;
    }

    @NotNull
    public Self filter(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        Self Self2 = this.newInstance(this.meta.filter(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        return Self2;
    }

    @NotNull
    public <C> JBIterable<C> filter(@NotNull Class<C> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        JBIterable<C> jBIterable = this.traverse().filter(type);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "filter"));
        }
        return jBIterable;
    }

    @NotNull
    public Self forceExclude(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase", "forceExclude"));
        }
        Self Self2 = this.newInstance(this.meta.forceExclude(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "forceExclude"));
        }
        return Self2;
    }

    @NotNull
    public Self forceExpandAndSkip(@NotNull Condition<? super T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase", "forceExpandAndSkip"));
        }
        Self Self2 = this.newInstance(this.meta.forceExpandAndSkip(filter));
        if (Self2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "forceExpandAndSkip"));
        }
        return Self2;
    }

    @NotNull
    public JBIterable<T> children(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/containers/FilteredTraverserBase", "children"));
        }
        if (this.isAlwaysLeaf(node)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
            }
            return jBIterable;
        }
        JBIterable<T> children = JBIterable.from(this.tree.fun(node));
        if (this.meta.childFilter == Conditions.TRUE && this.meta.forceExpandAndSkip == Condition.FALSE) {
            JBIterable jBIterable = children.filter(Conditions.not(this.meta.forceExclude));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
            }
            return jBIterable;
        }
        JBIterable<T> jBIterable = ((FilteredTraverserBase)this.newInstance(this.meta.forChildren(children))).traverse();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "children"));
        }
        return jBIterable;
    }

    protected boolean isAlwaysLeaf(@NotNull T node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/containers/FilteredTraverserBase", "isAlwaysLeaf"));
        }
        return !this.meta.expandFilter.value(node);
    }

    @NotNull
    public List<T> toList() {
        List<T> list = this.traverse().toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FilteredTraverserBase", "toList"));
        }
        return list;
    }

    public String toString() {
        return this.traverse().toString();
    }

    protected static class Meta<T> {
        public final Iterable<? extends T> roots;
        public final TreeTraversal traversal;
        public final Condition<? super T> expandFilter;
        public final Condition<? super T> childFilter;
        public final Condition<? super T> resultFilter;
        public final Condition<? super T> forceExclude;
        public final Condition<? super T> forceExpandAndSkip;
        private static final Meta<?> EMPTY = new Meta<Object>(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, Conditions.TRUE, Conditions.TRUE, Conditions.TRUE, Conditions.FALSE, Conditions.FALSE);

        public Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Condition<? super T> expandFilter, @NotNull Condition<? super T> childFilter, @NotNull Condition<? super T> resultFilter, @NotNull Condition<? super T> forceExclude, @NotNull Condition<? super T> forceExpandAndSkip) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (traversal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traversal", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (expandFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandFilter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (childFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFilter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (resultFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultFilter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (forceExclude == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forceExclude", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            if (forceExpandAndSkip == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forceExpandAndSkip", "com/intellij/util/containers/FilteredTraverserBase$Meta", "<init>"));
            }
            this.roots = roots;
            this.traversal = traversal;
            this.expandFilter = expandFilter;
            this.childFilter = childFilter;
            this.resultFilter = resultFilter;
            this.forceExclude = forceExclude;
            this.forceExpandAndSkip = forceExpandAndSkip;
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/util/containers/FilteredTraverserBase$Meta", "withRoots"));
            }
            return new Meta<T>(roots, this.traversal, this.expandFilter, this.childFilter, this.resultFilter, this.forceExclude, this.forceExpandAndSkip);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.expandFilter, this.childFilter, this.resultFilter, this.forceExclude, this.forceExpandAndSkip);
        }

        public Meta<T> expand(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "expand"));
            }
            return new Meta<T>(this.roots, this.traversal, Conditions.and2(this.expandFilter, filter), this.childFilter, this.resultFilter, this.forceExclude, this.forceExpandAndSkip);
        }

        public Meta<T> children(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "children"));
            }
            return new Meta<T>(this.roots, this.traversal, this.expandFilter, Conditions.and2(this.childFilter, filter), this.resultFilter, this.forceExclude, this.forceExpandAndSkip);
        }

        public Meta<T> filter(@NotNull Condition<? super T> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/containers/FilteredTraverserBase$Meta", "filter"));
            }
            return new Meta<T>(this.roots, this.traversal, this.expandFilter, this.childFilter, Conditions.and2(this.resultFilter, filter), this.forceExclude, this.forceExpandAndSkip);
        }

        public Meta<T> forceExclude(Condition<? super T> filter) {
            return new Meta<T>(this.roots, this.traversal, this.expandFilter, this.childFilter, this.resultFilter, Conditions.or2(this.forceExclude, filter), this.forceExpandAndSkip);
        }

        public Meta<T> forceExpandAndSkip(Condition<? super T> filter) {
            return new Meta<T>(this.roots, this.traversal, this.expandFilter, this.childFilter, this.resultFilter, this.forceExclude, Conditions.or2(this.forceExpandAndSkip, filter));
        }

        public Meta<T> forChildren(JBIterable<T> children) {
            Condition<? super T> expand = Conditions.or2(this.forceExpandAndSkip, Conditions.not(this.childFilter));
            return new Meta<Object>(children, TreeTraversal.LEAVES_ONLY_DFS, expand, Conditions.TRUE, Conditions.not(Conditions.or2(expand, this.forceExclude)), Conditions.FALSE, Conditions.FALSE);
        }

        public static <T> Meta<T> empty() {
            return EMPTY;
        }
    }
}

