/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.AndroidRootComponent;
import com.android.tools.idea.editors.navigation.Assoc;
import com.android.tools.idea.editors.navigation.Event;
import com.android.tools.idea.editors.navigation.HierarchyUtils;
import com.android.tools.idea.editors.navigation.Listener;
import com.android.tools.idea.editors.navigation.NavigationEditor;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.SelectionModel;
import com.android.tools.idea.editors.navigation.Selections;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.editors.navigation.macros.CodeGenerator;
import com.android.tools.idea.editors.navigation.macros.FragmentEntry;
import com.android.tools.idea.editors.navigation.model.ActivityState;
import com.android.tools.idea.editors.navigation.model.Locator;
import com.android.tools.idea.editors.navigation.model.MenuState;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.android.tools.idea.editors.navigation.model.ModelPoint;
import com.android.tools.idea.editors.navigation.model.NavigationModel;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.ShadowPainter;
import com.android.tools.idea.wizard.NewAndroidActivityWizard;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationView
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)NavigationView.class.getName());
    public static final ModelDimension GAP = new ModelDimension(500, 100);
    private static final Color BACKGROUND_COLOR = new JBColor((Color)Gray.get((int)192), (Color)Gray.get((int)70));
    private static final Color TRIGGER_BACKGROUND_COLOR = new JBColor((Color)Gray.get((int)200), (Color)Gray.get((int)60));
    private static final Color SNAP_GRID_LINE_COLOR_MINOR = new JBColor((Color)Gray.get((int)180), (Color)Gray.get((int)60));
    private static final Color SNAP_GRID_LINE_COLOR_MIDDLE = new JBColor((Color)Gray.get((int)170), (Color)Gray.get((int)50));
    private static final Color SNAP_GRID_LINE_COLOR_MAJOR = new JBColor((Color)Gray.get((int)160), (Color)Gray.get((int)40));
    public static final float ZOOM_FACTOR = 1.1f;
    private static final int MINOR_SNAP = 32;
    private static final int MIDDLE_COUNT = 5;
    private static final int MAJOR_COUNT = 10;
    public static final Dimension MINOR_SNAP_GRID = new Dimension(32, 32);
    public static final Dimension MIDDLE_SNAP_GRID = Utilities.scale(MINOR_SNAP_GRID, 5.0f);
    public static final Dimension MAJOR_SNAP_GRID = Utilities.scale(MINOR_SNAP_GRID, 10.0f);
    public static final int MIN_GRID_LINE_SEPARATION = 8;
    public static final int LINE_WIDTH = 12;
    private static final Point MULTIPLE_DROP_STRIDE = Utilities.point(MAJOR_SNAP_GRID);
    private static final Condition<Component> SCREENS = Utilities.instanceOf(AndroidRootComponent.class);
    private static final Condition<Component> EDITORS = Utilities.not(SCREENS);
    private static final boolean DRAW_DESTINATION_RECTANGLES = false;
    private static final boolean DEBUG = false;
    private static final Color GESTURE_ICON_COLOR = new JBColor(new Color(15092647), new Color(15092647));
    private static final String DEVICE_DEFAULT_THEME_NAME = "@android:style/Theme.DeviceDefault";
    public static final int RESOURCE_SUFFIX_LENGTH = ".xml".length();
    public static final String LIST_VIEW_ID = "list_view";
    public static final int FAKE_OVERFLOW_MENU_WIDTH = 10;
    public static final boolean SHOW_FAKE_OVERFLOW_MENUS = true;
    private final RenderingParameters myRenderingParams;
    private final NavigationModel myNavigationModel;
    private final SelectionModel mySelectionModel;
    private final CodeGenerator myCodeGenerator;
    private final Assoc<State, AndroidRootComponent> myStateComponentAssociation = new Assoc();
    private final Assoc<Transition, Component> myTransitionEditorAssociation = new Assoc();
    private boolean myStateCacheIsValid;
    private boolean myTransitionEditorCacheIsValid;
    private Map<State, Map<String, RenderedView>> myNameToRenderedView = new IdentityHashMap<State, Map<String, RenderedView>>();
    private Image myBackgroundImage;
    private Point myMouseLocation;
    private Transform myTransform = new Transform(0.25f);
    private boolean myShowRollover = false;
    private boolean myDrawGrid = false;

    public NavigationView(RenderingParameters renderingParams, NavigationModel model, SelectionModel selectionModel, CodeGenerator codeGenerator) {
        this.myRenderingParams = renderingParams;
        this.myNavigationModel = model;
        this.mySelectionModel = selectionModel;
        this.myCodeGenerator = codeGenerator;
        this.setFocusable(true);
        this.setLayout(null);
        MyMouseListener mouseListener = new MyMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NavigationView.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NavigationView.this.repaint();
            }
        });
        DnDManager dndManager = DnDManager.getInstance();
        dndManager.registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this);
        AbstractAction remove = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationView.this.mySelectionModel.getSelection().remove();
                NavigationView.this.setSelection(Selections.NULL);
            }
        };
        this.registerKeyBinding(127, "delete", remove);
        this.registerKeyBinding(8, "backspace", remove);
        this.myNavigationModel.getListeners().add(new Listener<Event>(){

            @Override
            public void notify(@NotNull Event event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationView$3", "notify"));
                }
                if (event.operandType.isAssignableFrom(State.class)) {
                    NavigationView.this.myStateCacheIsValid = false;
                }
                if (event.operandType.isAssignableFrom(Transition.class)) {
                    NavigationView.this.myTransitionEditorCacheIsValid = false;
                }
                if (event == NavigationEditor.PROJECT_READ) {
                    NavigationView.this.setSelection(Selections.NULL);
                }
                NavigationView.this.revalidate();
                NavigationView.this.repaint();
            }
        });
    }

    @Nullable
    private static RenderedView getRenderedView(AndroidRootComponent c, Point location) {
        return c.getRenderedView(Utilities.diff(location, c.getLocation()));
    }

    @Nullable
    private String getFragmentClassName(State sourceState, @Nullable RenderedView namedSourceLeaf) {
        if (namedSourceLeaf == null) {
            return null;
        }
        if (sourceState instanceof ActivityState) {
            ActivityState sourceActivityState = (ActivityState)sourceState;
            XmlTag tag = namedSourceLeaf.tag;
            if (tag == null) {
                return null;
            }
            PsiFile fragmentFile = tag.getContainingFile();
            String resourceFileName = fragmentFile.getName();
            String resourceName = resourceFileName.substring(0, resourceFileName.length() - RESOURCE_SUFFIX_LENGTH);
            for (FragmentEntry fragment : sourceActivityState.getFragments()) {
                String fragmentClassName;
                Module module = this.myRenderingParams.facet.getModule();
                String resource = Analyser.getXMLFileName(module, fragmentClassName = fragment.className, false);
                if (resource == null) {
                    PsiClass listClass = Utilities.getPsiClass(module, "android.app.ListFragment");
                    if (listClass == null) {
                        LOG.warn("Can't find: android.app.ListFragment");
                        continue;
                    }
                    PsiClass psiClass = Utilities.getPsiClass(module, fragmentClassName);
                    if (psiClass != null && psiClass.isInheritor(listClass, true) && tag.getName().equals("ListView")) {
                        return fragmentClassName;
                    }
                }
                if (!resourceName.equals(resource)) continue;
                return fragmentClassName;
            }
        }
        return null;
    }

    void createTransition(AndroidRootComponent sourceComponent, @Nullable RenderedView namedSourceLeaf, Point mouseUpLocation) {
        Component destComponent = this.getComponentAt(mouseUpLocation);
        if (sourceComponent != destComponent && destComponent instanceof AndroidRootComponent) {
            AndroidRootComponent destinationRoot = (AndroidRootComponent)destComponent;
            if (destinationRoot.isMenu) {
                return;
            }
            RenderedView endLeaf = NavigationView.getRenderedView(destinationRoot, mouseUpLocation);
            RenderedView namedEndLeaf = HierarchyUtils.getNamedParent(endLeaf);
            Map rootComponentToState = this.getStateComponentAssociation().valueToKey;
            State sourceState = (State)rootComponentToState.get(sourceComponent);
            String fragmentClassName = this.getFragmentClassName(sourceState, namedSourceLeaf);
            Locator sourceLocator = Locator.of(sourceState, fragmentClassName, HierarchyUtils.getViewId(namedSourceLeaf));
            Locator destinationLocator = Locator.of((State)rootComponentToState.get(destComponent), HierarchyUtils.getViewId(namedEndLeaf));
            this.myCodeGenerator.implementTransition(new Transition("Press", sourceLocator, destinationLocator));
        }
    }

    static Rectangle getBounds(AndroidRootComponent c, @Nullable RenderedView leaf) {
        if (leaf == null) {
            return c.getBounds();
        }
        Rectangle r = c.transform.getBounds(leaf);
        return new Rectangle(c.getX() + r.x, c.getY() + r.y, r.width, r.height);
    }

    Rectangle getNamedLeafBoundsAt(Component sourceComponent, Point location, boolean penetrate) {
        Component destComponent = this.getComponentAt(location);
        if (sourceComponent != destComponent && destComponent instanceof AndroidRootComponent) {
            AndroidRootComponent destinationRoot = (AndroidRootComponent)destComponent;
            if (!destinationRoot.isMenu) {
                if (!penetrate) {
                    return destinationRoot.getBounds();
                }
                RenderedView endLeaf = NavigationView.getRenderedView(destinationRoot, location);
                RenderedView namedEndLeaf = HierarchyUtils.getNamedParent(endLeaf);
                return NavigationView.getBounds(destinationRoot, namedEndLeaf);
            }
        }
        return new Rectangle(location);
    }

    public float getScale() {
        return this.myTransform.myScale;
    }

    public void setScale(float scale) {
        this.myTransform = new Transform(scale);
        this.myBackgroundImage = null;
        for (AndroidRootComponent root : this.getStateComponentAssociation().keyToValue.values()) {
            root.setScale(scale);
        }
        this.setPreferredSize();
        this.revalidate();
        this.repaint();
    }

    public void zoom(int n) {
        this.setScale(this.myTransform.myScale * (float)Math.pow(1.1f, n));
    }

    private Assoc<State, AndroidRootComponent> getStateComponentAssociation() {
        if (!this.myStateCacheIsValid) {
            this.syncStateCache(this.myStateComponentAssociation);
            this.myStateCacheIsValid = true;
        }
        return this.myStateComponentAssociation;
    }

    private Assoc<Transition, Component> getTransitionEditorAssociation() {
        if (!this.myTransitionEditorCacheIsValid) {
            this.syncTransitionCache(this.myTransitionEditorAssociation);
            this.myTransitionEditorCacheIsValid = true;
        }
        return this.myTransitionEditorAssociation;
    }

    private static Map<String, RenderedView> computeNameToRenderedView(RenderedViewHierarchy hierarchy) {
        HashMap<String, RenderedView> result = new HashMap<String, RenderedView>();
        for (RenderedView root : hierarchy.getRoots()) {
            result.putAll(NavigationView.createViewNameToRenderedView(root));
        }
        return result;
    }

    private Map<String, RenderedView> getNameToRenderedView(State state) {
        Map<String, RenderedView> result = this.myNameToRenderedView.get(state);
        if (result == null) {
            AndroidRootComponent androidRootComponent = (AndroidRootComponent)this.getStateComponentAssociation().keyToValue.get(state);
            if (androidRootComponent == null) {
                return Collections.emptyMap();
            }
            RenderResult renderResult = androidRootComponent.getRenderResult();
            if (renderResult == null) {
                return Collections.emptyMap();
            }
            RenderedViewHierarchy hierarchy = renderResult.getHierarchy();
            if (hierarchy == null) {
                return Collections.emptyMap();
            }
            result = NavigationView.computeNameToRenderedView(hierarchy);
            this.myNameToRenderedView.put(state, result);
        }
        return result;
    }

    private static Map<String, RenderedView> createViewNameToRenderedView(@NotNull RenderedView root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/editors/navigation/NavigationView", "createViewNameToRenderedView"));
        }
        final HashMap<String, RenderedView> result = new HashMap<String, RenderedView>();
        int w = 10;
        result.put("$overflow_menu$", new RenderedView(root, null, null, root.x + root.w - w, 0, w, w));
        new Object(){

            void walk(RenderedView parent) {
                for (RenderedView child : parent.getChildren()) {
                    XmlTag tag;
                    String id = HierarchyUtils.getViewId(child);
                    if (id != null) {
                        result.put(id, child);
                    }
                    if ((tag = child.tag) != null && tag.getName().equals("ListView")) {
                        result.put(NavigationView.LIST_VIEW_ID, child);
                    }
                    this.walk(child);
                }
            }
        }.walk(root);
        return result;
    }

    private static Map<String, ViewInfo> createViewNameToViewInfo(@NotNull ViewInfo root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/editors/navigation/NavigationView", "createViewNameToViewInfo"));
        }
        final HashMap<String, ViewInfo> result = new HashMap<String, ViewInfo>();
        new Object(){

            void walk(ViewInfo parent) {
                for (ViewInfo child : parent.getChildren()) {
                    String id = HierarchyUtils.getViewId(child);
                    if (id != null) {
                        result.put(id, child);
                    }
                    this.walk(child);
                }
            }
        }.walk(root);
        return result;
    }

    static void paintLeaf(Graphics g, @Nullable RenderedView leaf, Color color, AndroidRootComponent component) {
        if (leaf != null) {
            Color oldColor = g.getColor();
            g.setColor(color);
            Utilities.drawRectangle(g, NavigationView.getBounds(component, leaf));
            g.setColor(oldColor);
        }
    }

    private void registerKeyBinding(int keyCode, String name, Action action) {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(keyCode, 0), name);
        this.getActionMap().put(name, action);
    }

    private void setSelection(@NotNull Selections.Selection selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/editors/navigation/NavigationView", "setSelection"));
        }
        this.mySelectionModel.setSelection(selection);
        this.revalidate();
        this.repaint();
    }

    private void moveSelection(Point location) {
        this.mySelectionModel.getSelection().moveTo(location);
        this.revalidate();
        this.repaint();
    }

    private void setMouseLocation(Point mouseLocation) {
        this.myMouseLocation = mouseLocation;
        if (this.myShowRollover) {
            this.repaint();
        }
    }

    private void finaliseSelectionLocation(Point location) {
        this.mySelectionModel.setSelection(this.mySelectionModel.getSelection().finaliseSelectionLocation(location));
        this.revalidate();
        this.repaint();
    }

    private void drawGrid(Graphics g, Color c, Dimension modelSize, int width, int height) {
        g.setColor(c);
        Dimension viewSize = this.myTransform.modelToView(ModelDimension.create(modelSize));
        if (viewSize.width < 8 || viewSize.height < 8) {
            return;
        }
        for (int x = 0; x < this.myTransform.viewToModelW(width); x += modelSize.width) {
            int vx = this.myTransform.modelToViewX(x);
            g.drawLine(vx, 0, vx, this.getHeight());
        }
        for (int y = 0; y < this.myTransform.viewToModelH(height); y += modelSize.height) {
            int vy = this.myTransform.modelToViewY(y);
            g.drawLine(0, vy, this.getWidth(), vy);
        }
    }

    private void drawBackground(Graphics g, int width, int height) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MINOR, MINOR_SNAP_GRID, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MIDDLE, MIDDLE_SNAP_GRID, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MAJOR, MAJOR_SNAP_GRID, width, height);
    }

    private Image getBackGroundImage() {
        if (this.myBackgroundImage == null || this.myBackgroundImage.getWidth(null) != this.getWidth() || this.myBackgroundImage.getHeight(null) != this.getHeight()) {
            this.myBackgroundImage = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)1);
            this.drawBackground(this.myBackgroundImage.getGraphics(), this.getWidth(), this.getHeight());
        }
        return this.myBackgroundImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myDrawGrid) {
            g.drawImage(this.getBackGroundImage(), 0, 0, null);
        } else {
            Color tmp = this.getBackground();
            g.setColor(BACKGROUND_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        for (Component c : this.getStateComponentAssociation().keyToValue.values()) {
            Rectangle r = c.getBounds();
            ShadowPainter.drawRectangleShadow(g, r.x, r.y, r.width, r.height);
        }
    }

    static Point[] getControlPoints(Rectangle src, Rectangle dst, Utilities.Line midLine) {
        Point a = midLine.a;
        Point b = midLine.b;
        return new Point[]{Utilities.project(a, src), a, b, Utilities.project(b, dst)};
    }

    private Point[] getControlPoints(Transition t) {
        Rectangle srcBounds = this.getBounds(t.getSource());
        Rectangle dstBounds = this.getBounds(t.getDestination());
        return NavigationView.getControlPoints(srcBounds, dstBounds, Utilities.getMidLine(srcBounds, dstBounds));
    }

    private static int getTurnLength(Point[] points, float scale) {
        int N = points.length;
        int cornerDiameter = (int)((float)Math.min(NavigationView.MAJOR_SNAP_GRID.width, NavigationView.MAJOR_SNAP_GRID.height) * scale);
        for (int i = 0; i < N - 1; ++i) {
            Point a = points[i];
            Point b = points[i + 1];
            int length = (int)Utilities.length(Utilities.diff(b, a));
            if (i != 0 && i != N - 2) {
                length /= 2;
            }
            cornerDiameter = Math.min(cornerDiameter, length);
        }
        return cornerDiameter;
    }

    private static void drawCurve(Graphics g, Point[] points, float scale) {
        int N = points.length;
        int cornerDiameter = NavigationView.getTurnLength(points, scale);
        boolean horizontal = points[0].x != points[1].x;
        Point previous = points[0];
        for (int i = 1; i < N - 1; ++i) {
            Rectangle turn = Utilities.getCorner(points[i], cornerDiameter);
            Point startTurn = Utilities.project(previous, turn);
            Utilities.drawLine(g, previous, startTurn);
            Point endTurn = Utilities.project(points[i + 1], turn);
            NavigationView.drawCorner(g, startTurn, endTurn, horizontal);
            previous = endTurn;
            horizontal = !horizontal;
        }
        Point endPoint = points[N - 1];
        if (Utilities.length(Utilities.diff(previous, endPoint)) > 1.0) {
            Utilities.drawArrow(g, previous, endPoint, (int)(12.0f * scale));
        }
    }

    public void drawTransition(Graphics g, Rectangle src, Rectangle dst, Point[] controlPoints) {
        Utilities.drawRectangle(g, src);
        NavigationView.drawCurve(g, controlPoints, this.myTransform.myScale);
    }

    private void drawTransition(Graphics g, Transition t) {
        this.drawTransition(g, this.getBounds(t.getSource()), this.getBounds(t.getDestination()), this.getControlPoints(t));
    }

    public void paintTransitions(Graphics g) {
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            this.drawTransition(g, transition);
        }
    }

    private static int angle(Point p) {
        return p.x > 0 ? 0 : (p.y < 0 ? 90 : (p.x < 0 ? 180 : 270));
    }

    private static void drawCorner(Graphics g, Point a, Point b, boolean horizontal) {
        int radiusX = Math.abs(a.x - b.x);
        int radiusY = Math.abs(a.y - b.y);
        Point centre = horizontal ? new Point(a.x, b.y) : new Point(b.x, a.y);
        int startAngle = NavigationView.angle(Utilities.diff(a, centre));
        int endAngle = NavigationView.angle(Utilities.diff(b, centre));
        int dangle = endAngle - startAngle;
        int angle = dangle - (Math.abs(dangle) <= 180 ? 0 : 360 * Utilities.sign(dangle));
        g.drawArc(centre.x - radiusX, centre.y - radiusY, radiusX * 2, radiusY * 2, startAngle, angle);
    }

    private RenderedView getRenderedView(Locator locator) {
        return this.getNameToRenderedView(locator.getState()).get(locator.getViewId());
    }

    private void paintRollover(Graphics2D lineGraphics) {
        if (this.myMouseLocation == null || !this.myShowRollover) {
            return;
        }
        Component component = this.getComponentAt(this.myMouseLocation);
        if (component instanceof AndroidRootComponent) {
            Stroke oldStroke = lineGraphics.getStroke();
            lineGraphics.setStroke(new BasicStroke(1.0f));
            AndroidRootComponent androidRootComponent = (AndroidRootComponent)component;
            RenderedView leaf = NavigationView.getRenderedView(androidRootComponent, this.myMouseLocation);
            RenderedView namedLeaf = HierarchyUtils.getNamedParent(leaf);
            NavigationView.paintLeaf(lineGraphics, leaf, (Color)JBColor.RED, androidRootComponent);
            NavigationView.paintLeaf(lineGraphics, namedLeaf, (Color)JBColor.BLUE, androidRootComponent);
            lineGraphics.setStroke(oldStroke);
        }
    }

    private void paintSelection(Graphics g) {
        this.mySelectionModel.getSelection().paint(g, this.hasFocus());
        this.mySelectionModel.getSelection().paintOver(g);
    }

    private void paintChildren(Graphics g, Condition<Component> condition) {
        Rectangle bounds = new Rectangle();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component child = this.getComponent(i);
            if (!condition.value((Object)child)) continue;
            child.getBounds(bounds);
            Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            child.paint(cg);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.paintChildren(g, SCREENS);
        Graphics2D lineGraphics = Utilities.createLineGraphics(g, this.myTransform.modelToViewW(12));
        this.paintTransitions(lineGraphics);
        this.paintRollover(lineGraphics);
        this.paintSelection(g);
        this.paintChildren(g, EDITORS);
    }

    private Rectangle getBounds(Locator source) {
        Map stateToComponent = this.getStateComponentAssociation().keyToValue;
        AndroidRootComponent component = (AndroidRootComponent)stateToComponent.get(source.getState());
        return NavigationView.getBounds(component, this.getRenderedView(source));
    }

    @Override
    public void doLayout() {
        Map transitionToEditor = this.getTransitionEditorAssociation().keyToValue;
        Map stateToComponent = this.getStateComponentAssociation().keyToValue;
        for (State state : stateToComponent.keySet()) {
            AndroidRootComponent root = (AndroidRootComponent)stateToComponent.get(state);
            root.setLocation(this.myTransform.modelToView(this.myNavigationModel.getStateToLocation().get(state)));
            root.setSize(root.getPreferredSize());
        }
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            Component editor;
            String gesture = transition.getType();
            if (gesture == null || (editor = (Component)transitionToEditor.get(transition)) == null) continue;
            if (editor.getParent() == null) {
                this.add(editor);
            }
            Dimension preferredSize = editor.getPreferredSize();
            Point[] points = this.getControlPoints(transition);
            Point location = Utilities.diff(Utilities.midPoint(points[1], points[2]), Utilities.midPoint(preferredSize));
            editor.setLocation(location);
            editor.setSize(preferredSize);
        }
    }

    private <K, V extends Component> void removeLeftovers(Assoc<K, V> assoc, Collection<K> a) {
        for (Map.Entry e : new ArrayList(assoc.keyToValue.entrySet())) {
            Object k = e.getKey();
            Component v = (Component)e.getValue();
            if (a.contains(k)) continue;
            assoc.remove(k, v);
            this.remove(v);
            this.repaint();
        }
    }

    private JComponent getPressGestureIcon() {
        return new JComponent(){
            private ModelDimension SIZE = new ModelDimension(100, 100);

            @Override
            public Dimension getPreferredSize() {
                return NavigationView.this.myTransform.modelToView(this.SIZE);
            }

            @Override
            public void paintComponent(Graphics g) {
                RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHints(rh);
                g.setColor(GESTURE_ICON_COLOR);
                g.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
    }

    private static JLabel getSwipeGestureIcon() {
        JLabel result = new JLabel("<->");
        result.setFont(result.getFont().deriveFont(20.0f));
        result.setForeground(Utilities.TRANSITION_LINE_COLOR);
        result.setBackground(TRIGGER_BACKGROUND_COLOR);
        result.setBorder(new LineBorder(Utilities.TRANSITION_LINE_COLOR, 1));
        result.setOpaque(true);
        return result;
    }

    private Component createEditorFor(Transition transition) {
        String gesture = transition.getType();
        return gesture.equals("Press") ? this.getPressGestureIcon() : NavigationView.getSwipeGestureIcon();
    }

    private void syncTransitionCache(Assoc<Transition, Component> assoc) {
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            if (assoc.keyToValue.containsKey(transition)) continue;
            Component editor = this.createEditorFor(transition);
            this.add(editor);
            assoc.add(transition, editor);
        }
        this.removeLeftovers(assoc, this.myNavigationModel.getTransitions());
    }

    @Nullable
    private static VirtualFile getLayoutXmlVirtualFile(boolean menu, @Nullable String resourceName, Configuration configuration) {
        ResourceType resourceType = menu ? ResourceType.MENU : ResourceType.LAYOUT;
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver == null) {
            return null;
        }
        ResourceValue projectResource = resourceResolver.getProjectResource(resourceType, resourceName);
        if (projectResource == null) {
            return null;
        }
        return Utilities.virtualFile(new File(projectResource.getValue()));
    }

    @Nullable
    public static PsiFile getLayoutXmlFile(boolean menu, @Nullable String resourceName, Configuration configuration, Project project) {
        VirtualFile file = NavigationView.getLayoutXmlVirtualFile(menu, resourceName, configuration);
        return file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
    }

    private RenderingParameters getActivityRenderingParameters(Module module, String className) {
        ManifestInfo manifestInfo = ManifestInfo.get(module, false);
        Configuration newConfiguration = this.myRenderingParams.configuration.clone();
        String theme = manifestInfo.getManifestTheme();
        ManifestInfo.ActivityAttributes activityAttributes = manifestInfo.getActivityAttributes(className);
        if (activityAttributes != null) {
            String activityTheme = activityAttributes.getTheme();
            theme = activityTheme != null ? activityTheme : theme;
        }
        newConfiguration.setTheme(theme);
        return this.myRenderingParams.withConfiguration(newConfiguration);
    }

    private RenderingParameters getMenuRenderingParameters() {
        Configuration newConfiguration = this.myRenderingParams.configuration.clone();
        newConfiguration.setTheme(DEVICE_DEFAULT_THEME_NAME);
        return this.myRenderingParams.withConfiguration(newConfiguration);
    }

    private AndroidRootComponent createUnscaledRootComponentFor(State state) {
        boolean isMenu = state instanceof MenuState;
        Module module = this.myRenderingParams.facet.getModule();
        String resourceName = isMenu ? ((MenuState)state).getXmlResourceName() : Analyser.getXMLFileName(module, state.getClassName(), true);
        VirtualFile virtualFile = NavigationView.getLayoutXmlVirtualFile(isMenu, resourceName, this.myRenderingParams.configuration);
        if (virtualFile == null) {
            return new AndroidRootComponent(this.myRenderingParams, null, isMenu);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myRenderingParams.project).findFile(virtualFile);
        RenderingParameters params = isMenu ? this.getMenuRenderingParameters() : this.getActivityRenderingParameters(module, state.getClassName());
        return new AndroidRootComponent(params, psiFile, isMenu);
    }

    private AndroidRootComponent createRootComponentFor(State state) {
        AndroidRootComponent result = this.createUnscaledRootComponentFor(state);
        result.setScale(this.myTransform.myScale);
        return result;
    }

    private void syncStateCache(Assoc<State, AndroidRootComponent> assoc) {
        assoc.clear();
        this.removeAll();
        for (State state : this.myNavigationModel.getStates()) {
            if (assoc.keyToValue.containsKey(state)) continue;
            AndroidRootComponent root = this.createRootComponentFor(state);
            assoc.add(state, root);
            this.add(root);
        }
        this.setPreferredSize();
    }

    private static ModelPoint getMaxLoc(Collection<ModelPoint> locations) {
        int maxX = 0;
        int maxY = 0;
        for (ModelPoint location : locations) {
            maxX = Math.max(maxX, location.x);
            maxY = Math.max(maxY, location.y);
        }
        return new ModelPoint(maxX, maxY);
    }

    private void setPreferredSize() {
        ModelDimension size = this.myRenderingParams.getDeviceScreenSize();
        ModelDimension gridSize = new ModelDimension(size.width + NavigationView.GAP.width, size.height + NavigationView.GAP.height);
        ModelPoint maxLoc = NavigationView.getMaxLoc(this.myNavigationModel.getStateToLocation().values());
        Dimension max = this.myTransform.modelToView(new ModelDimension(maxLoc.x + gridSize.width, maxLoc.y + gridSize.height));
        this.setPreferredSize(max);
    }

    private void bringToFront(@Nullable State state) {
        AndroidRootComponent menuComponent;
        if (state != null && (menuComponent = (AndroidRootComponent)this.getStateComponentAssociation().keyToValue.get(state)) != null) {
            this.setComponentZOrder(menuComponent, 0);
        }
    }

    private static void debug(@Nullable String s) {
        LOG.debug(s);
    }

    private static void debug(String name, @Nullable RenderedView view) {
    }

    private Selections.Selection createSelection(Point mouseDownLocation, boolean shiftDown) {
        Component component = this.getComponentAt(mouseDownLocation);
        if (component instanceof NavigationView) {
            return Selections.NULL;
        }
        Transition transition = (Transition)this.getTransitionEditorAssociation().valueToKey.get(component);
        if (component instanceof AndroidRootComponent) {
            AndroidRootComponent androidRootComponent = (AndroidRootComponent)component;
            State state = (State)this.getStateComponentAssociation().valueToKey.get(androidRootComponent);
            if (!shiftDown) {
                if (state == null) {
                    return Selections.NULL;
                }
                this.bringToFront(state);
                if (state instanceof ActivityState) {
                    this.bringToFront(this.myNavigationModel.findAssociatedMenuState((ActivityState)state));
                }
                return new Selections.AndroidRootComponentSelection(this.myNavigationModel, androidRootComponent, transition, this.myRenderingParams, mouseDownLocation, state, this.myTransform);
            }
            RenderedView leaf = NavigationView.getRenderedView(androidRootComponent, mouseDownLocation);
            if (leaf == null) {
                return Selections.NULL;
            }
            NavigationView.debug("root", HierarchyUtils.getRoot(leaf));
            NavigationView.debug("leaf", leaf);
            RenderedView namedParent = HierarchyUtils.getNamedParent(leaf);
            if (namedParent == null) {
                return Selections.NULL;
            }
            NavigationView.debug("namedParent", namedParent);
            if (this.myNavigationModel.findTransitionWithSource(Locator.of(state, HierarchyUtils.getViewId(namedParent))) != null) {
                return Selections.NULL;
            }
            return new Selections.ViewSelection(androidRootComponent, mouseDownLocation, namedParent, this);
        }
        return new Selections.ComponentSelection<Component>(this.myRenderingParams, this.myNavigationModel, component, transition);
    }

    private class MyDnDTarget
    implements DnDTarget {
        private int applicableDropCount = 0;

        private MyDnDTarget() {
        }

        private void execute(State state, boolean execute) {
            if (!((NavigationView)NavigationView.this).getStateComponentAssociation().keyToValue.containsKey(state)) {
                if (execute) {
                    NavigationView.this.myNavigationModel.addState(state);
                } else {
                    ++this.applicableDropCount;
                }
            }
        }

        private void dropOrPrepareToDrop(DnDEvent anEvent, boolean execute) {
            Object attachedObject = anEvent.getAttachedObject();
            if (attachedObject instanceof TransferableWrapper) {
                TransferableWrapper wrapper = (TransferableWrapper)attachedObject;
                PsiElement[] psiElements = wrapper.getPsiElements();
                Point dropLoc = anEvent.getPointOn((Component)NavigationView.this);
                if (psiElements != null) {
                    for (PsiElement element : psiElements) {
                        PsiQualifiedNamedElement namedElement;
                        String qualifiedName;
                        PsiFile containingFile;
                        PsiDirectory dir;
                        if (element instanceof XmlFileImpl && (dir = (containingFile = element.getContainingFile()).getParent()) != null && dir.getName().equals("menu")) {
                            String resourceName = ResourceHelper.getResourceName(containingFile);
                            MenuState state = new MenuState(resourceName);
                            this.execute(state, execute);
                        }
                        if (!(element instanceof PsiQualifiedNamedElement) || (qualifiedName = (namedElement = (PsiQualifiedNamedElement)element).getQualifiedName()) == null) continue;
                        ActivityState state = new ActivityState(qualifiedName);
                        Dimension size = NavigationView.this.myRenderingParams.getDeviceScreenSizeFor(NavigationView.this.myTransform);
                        Point dropLocation = Utilities.diff(dropLoc, Utilities.midPoint(size));
                        NavigationView.this.myNavigationModel.getStateToLocation().put(state, NavigationView.this.myTransform.viewToModel(Utilities.snap(dropLocation, MIDDLE_SNAP_GRID)));
                        this.execute(state, execute);
                        dropLoc = Utilities.sum(dropLocation, MULTIPLE_DROP_STRIDE);
                    }
                }
            }
            if (execute) {
                NavigationView.this.revalidate();
                NavigationView.this.repaint();
            }
        }

        public boolean update(DnDEvent anEvent) {
            this.applicableDropCount = 0;
            this.dropOrPrepareToDrop(anEvent, false);
            anEvent.setDropPossible(this.applicableDropCount > 0);
            return false;
        }

        public void drop(DnDEvent anEvent) {
            this.dropOrPrepareToDrop(anEvent, true);
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        private void showPopup(MouseEvent e) {
            JBPopupMenu menu = new JBPopupMenu();
            JBMenuItem anItem = new JBMenuItem("New Activity...");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Module module = ((NavigationView)NavigationView.this).myRenderingParams.facet.getModule();
                    NewAndroidActivityWizard dialog = new NewAndroidActivityWizard(module, null, null);
                    dialog.init();
                    dialog.setOpenCreatedFiles(false);
                    dialog.show();
                }
            });
            menu.add((JMenuItem)anItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            Point location = e.getPoint();
            boolean modified = e.isShiftDown() || e.isControlDown() || e.isMetaDown();
            NavigationView.this.setSelection(NavigationView.this.createSelection(location, modified));
            NavigationView.this.requestFocus();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.setMouseLocation(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.moveSelection(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component child;
            if (e.getClickCount() == 2 && (child = NavigationView.this.getComponentAt(e.getPoint())) instanceof AndroidRootComponent) {
                AndroidRootComponent androidRootComponent = (AndroidRootComponent)child;
                androidRootComponent.launchLayoutEditor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.finaliseSelectionLocation(e.getPoint());
        }
    }
}

