/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.customizer.AbstractContentRootModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;

public class ContentRootModuleCustomizer
extends AbstractContentRootModuleCustomizer<IdeaJavaProject> {
    @Override
    @NotNull
    protected Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel model, @NotNull IdeaJavaProject javaProject) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        ArrayList allEntries = Lists.newArrayList();
        for (IdeaContentRoot ideaContentRoot : javaProject.getContentRoots()) {
            File rootDirPath = ideaContentRoot.getRootDirectory();
            ContentEntry contentEntry = model.addContentEntry(FilePaths.pathToIdeaUrl(rootDirPath));
            allEntries.add(contentEntry);
        }
        ArrayList arrayList = allEntries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "findOrCreateContentEntries"));
        }
        return arrayList;
    }

    @Override
    protected void setUpContentEntries(@NotNull Module module, @NotNull Collection<ContentEntry> contentEntries, @NotNull IdeaJavaProject javaProject, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "setUpContentEntries"));
        }
        boolean isTopLevelJavaModule = Projects.isGradleProjectModule(module);
        File buildFolderPath = javaProject.getBuildFolderPath();
        boolean buildFolderUnexcluded = buildFolderPath == null;
        for (IdeaContentRoot ideaContentRoot : javaProject.getContentRoots()) {
            if (ideaContentRoot == null) continue;
            this.addSourceFolders(contentEntries, (Set<? extends IdeaSourceDirectory>)ideaContentRoot.getSourceDirectories(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, orphans);
            this.addSourceFolders(contentEntries, (Set<? extends IdeaSourceDirectory>)ideaContentRoot.getTestDirectories(), (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE, orphans);
            if (ideaContentRoot instanceof ExtIdeaContentRoot) {
                ExtIdeaContentRoot extContentRoot = (ExtIdeaContentRoot)ideaContentRoot;
                this.addSourceFolders(contentEntries, (Set<? extends IdeaSourceDirectory>)extContentRoot.getResourceDirectories(), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE, orphans);
                this.addSourceFolders(contentEntries, (Set<? extends IdeaSourceDirectory>)extContentRoot.getTestResourceDirectories(), (JpsModuleSourceRootType)JavaResourceRootType.TEST_RESOURCE, orphans);
            }
            for (File excluded : ideaContentRoot.getExcludeDirectories()) {
                ContentEntry contentEntry;
                if (excluded == null || (contentEntry = FilePaths.findParentContentEntry(excluded, contentEntries)) == null) continue;
                if (isTopLevelJavaModule && !buildFolderUnexcluded && FileUtil.filesEqual((File)excluded, (File)buildFolderPath)) {
                    buildFolderUnexcluded = true;
                    continue;
                }
                this.addExcludedFolder(contentEntry, excluded);
            }
        }
    }

    private void addSourceFolders(@NotNull Collection<ContentEntry> contentEntries, @Nullable Set<? extends IdeaSourceDirectory> sourceFolders, @NotNull JpsModuleSourceRootType type, @NotNull List<AbstractContentRootModuleCustomizer.RootSourceFolder> orphans) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntries", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orphans", "com/android/tools/idea/gradle/customizer/java/ContentRootModuleCustomizer", "addSourceFolders"));
        }
        if (sourceFolders == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : sourceFolders) {
            File path = ideaSourceDirectory.getDirectory();
            this.addSourceFolder(contentEntries, path, type, false, orphans);
        }
    }
}

