/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.idea.gradle.structure.ConfigurableHost;
import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.android.tools.idea.gradle.structure.ValidationAwareConfigurable;
import com.android.tools.idea.sdk.DefaultSdks;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSdksConfigurable
extends BaseConfigurable
implements ValidationAwareConfigurable {
    private static final String CHOOSE_VALID_JDK_DIRECTORY_ERR = "Please choose a valid JDK directory.";
    private static final String CHOOSE_VALID_SDK_DIRECTORY_ERR = "Please choose a valid Android SDK directory.";
    @Nullable
    private final ConfigurableHost myHost;
    @Nullable
    private final Project myProject;
    private String myOriginalJdkHomePath;
    private String myOriginalSdkHomePath;
    private TextFieldWithBrowseButton mySdkLocationTextField;
    private TextFieldWithBrowseButton myJdkLocationTextField;
    private JPanel myWholePanel;
    private DetailsComponent myDetailsComponent;

    public DefaultSdksConfigurable(@Nullable ConfigurableHost host, @Nullable Project project) {
        this.myHost = host;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myWholePanel.setPreferredSize(new Dimension(700, 500));
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myWholePanel);
        this.myDetailsComponent.setText(new String[]{"SDK Location"});
    }

    public void disposeUIResources() {
    }

    public void reset() {
        this.myOriginalSdkHomePath = DefaultSdksConfigurable.getDefaultSdkPath();
        this.myOriginalJdkHomePath = DefaultSdksConfigurable.getDefaultJdkPath();
        this.mySdkLocationTextField.setText(this.myOriginalSdkHomePath);
        this.myJdkLocationTextField.setText(this.myOriginalJdkHomePath);
    }

    public void apply() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                DefaultSdks.setDefaultJavaHome(DefaultSdksConfigurable.this.getJdkLocation());
                DefaultSdks.setDefaultAndroidHome(DefaultSdksConfigurable.this.getSdkLocation(), DefaultSdksConfigurable.this.myProject);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    RunAndroidSdkManagerAction.updateInWelcomePage(DefaultSdksConfigurable.this.myDetailsComponent.getComponent());
                }
            }
        });
    }

    private void createUIComponents() {
        this.createSdkLocationTextField();
        this.createJdkLocationTextField();
    }

    private void createSdkLocationTextField() {
        final FileChooserDescriptor descriptor = DefaultSdksConfigurable.createSingleFolderDescriptor("Choose Android SDK Location", new Function<File, Void>(){

            public Void fun(File file) {
                if (!DefaultSdks.isValidAndroidSdkPath(file)) {
                    throw new IllegalArgumentException(DefaultSdksConfigurable.CHOOSE_VALID_SDK_DIRECTORY_ERR);
                }
                return null;
            }
        });
        JTextField textField = new JTextField(10);
        this.mySdkLocationTextField = new TextFieldWithBrowseButton(textField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile chosen;
                VirtualFile suggestedDir = null;
                File sdkLocation = DefaultSdksConfigurable.this.getSdkLocation();
                if (sdkLocation.isDirectory()) {
                    suggestedDir = VfsUtil.findFileByIoFile((File)sdkLocation, (boolean)false);
                }
                if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (VirtualFile)suggestedDir)) != null) {
                    File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
                    DefaultSdksConfigurable.this.mySdkLocationTextField.setText(f.getPath());
                }
            }
        });
        this.installValidationListener(textField);
    }

    private void createJdkLocationTextField() {
        JTextField textField = new JTextField(10);
        this.myJdkLocationTextField = new TextFieldWithBrowseButton(textField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSdksConfigurable.this.chooseJdkLocation();
            }
        });
        this.installValidationListener(textField);
    }

    public void chooseJdkLocation() {
        VirtualFile chosen;
        this.myJdkLocationTextField.getTextField().requestFocus();
        VirtualFile suggestedDir = null;
        File jdkLocation = this.getJdkLocation();
        if (jdkLocation.isDirectory()) {
            suggestedDir = VfsUtil.findFileByIoFile((File)jdkLocation, (boolean)false);
        }
        if ((chosen = FileChooser.chooseFile((FileChooserDescriptor)DefaultSdksConfigurable.createSingleFolderDescriptor("Choose JDK Location", new Function<File, Void>(){

            public Void fun(File file) {
                if (!DefaultSdksConfigurable.this.validateAndUpdateJdkPath(file)) {
                    throw new IllegalArgumentException(DefaultSdksConfigurable.CHOOSE_VALID_JDK_DIRECTORY_ERR);
                }
                return null;
            }
        }), null, (VirtualFile)suggestedDir)) != null) {
            File f = VfsUtilCore.virtualToIoFile((VirtualFile)chosen);
            this.myJdkLocationTextField.setText(f.getPath());
        }
    }

    private void installValidationListener(@NotNull JTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "installValidationListener"));
        }
        if (this.myHost != null) {
            textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    DefaultSdksConfigurable.this.myHost.requestValidation();
                }
            });
        }
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(@NotNull String title, final @NotNull Function<File, Void> validation) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        if (validation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validation", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                for (VirtualFile virtualFile : files) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor.withShowHiddenFiles(true);
        }
        descriptor.setTitle(title);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "createSingleFolderDescriptor"));
        }
        return fileChooserDescriptor;
    }

    public String getDisplayName() {
        return "SDK Location";
    }

    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myDetailsComponent.getComponent();
    }

    @NotNull
    public JComponent getContentPanel() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getContentPanel"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return !this.myOriginalSdkHomePath.equals(this.getSdkLocation().getPath()) || !this.myOriginalJdkHomePath.equals(this.getJdkLocation().getPath());
    }

    @Nullable
    private static Sdk getFirstDefaultAndroidSdk(boolean create) {
        List<Sdk> allAndroidSdks = DefaultSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        if (!create) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        List<Sdk> sdks = DefaultSdks.createAndroidSdksForAllTargets(sdkData.getLocation());
        return !sdks.isEmpty() ? sdks.get(0) : null;
    }

    @NotNull
    private static String getDefaultSdkPath() {
        String sdkHome;
        File path = DefaultSdks.getDefaultAndroidHome();
        if (path != null) {
            String string = path.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
            }
            return string;
        }
        Sdk sdk = DefaultSdksConfigurable.getFirstDefaultAndroidSdk(true);
        if (sdk != null && (sdkHome = sdk.getHomePath()) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkHome);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getDefaultSdkPath"));
        }
        return "";
    }

    @NotNull
    private static String getDefaultJdkPath() {
        File javaHome = DefaultSdks.getDefaultJavaHome();
        String string = javaHome != null ? javaHome.getPath() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getDefaultJdkPath"));
        }
        return string;
    }

    @NotNull
    private File getSdkLocation() {
        String sdkLocation = this.mySdkLocationTextField.getText();
        File file = new File(FileUtilRt.toSystemDependentName((String)sdkLocation));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getSdkLocation"));
        }
        return file;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.mySdkLocationTextField.getTextField();
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getPreferredFocusedComponent"));
        }
        return jTextField;
    }

    public boolean validate() throws ConfigurationException {
        if (!DefaultSdks.isValidAndroidSdkPath(this.getSdkLocation())) {
            throw new ConfigurationException(CHOOSE_VALID_SDK_DIRECTORY_ERR);
        }
        if (!this.validateAndUpdateJdkPath(this.getJdkLocation())) {
            throw new ConfigurationException(CHOOSE_VALID_JDK_DIRECTORY_ERR);
        }
        return true;
    }

    @Override
    @NotNull
    public List<ProjectConfigurationError> validateState() {
        ProjectConfigurationError error;
        ArrayList errors = Lists.newArrayList();
        if (!DefaultSdks.isValidAndroidSdkPath(this.getSdkLocation())) {
            error = new ProjectConfigurationError(CHOOSE_VALID_SDK_DIRECTORY_ERR, this.mySdkLocationTextField.getTextField());
            errors.add(error);
        }
        if (!this.validateAndUpdateJdkPath(this.getJdkLocation())) {
            error = new ProjectConfigurationError(CHOOSE_VALID_JDK_DIRECTORY_ERR, this.myJdkLocationTextField.getTextField());
            errors.add(error);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "validateState"));
        }
        return arrayList;
    }

    @NotNull
    private File getJdkLocation() {
        String jdkLocation = this.myJdkLocationTextField.getText();
        File file = new File(FileUtilRt.toSystemDependentName((String)jdkLocation));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "getJdkLocation"));
        }
        return file;
    }

    private boolean validateAndUpdateJdkPath(@NotNull File file) {
        File potentialPath;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/structure/DefaultSdksConfigurable", "validateAndUpdateJdkPath"));
        }
        if (JavaSdk.checkForJdk((File)file)) {
            return true;
        }
        if (SystemInfo.isMac && (potentialPath = new File(file, "/Contents/Home")).isDirectory() && JavaSdk.checkForJdk((File)potentialPath)) {
            this.myJdkLocationTextField.setText(potentialPath.getPath());
            return true;
        }
        return false;
    }

    public static boolean isNeeded() {
        String jdkPath = DefaultSdksConfigurable.getDefaultJdkPath();
        String sdkPath = DefaultSdksConfigurable.getDefaultSdkPath();
        boolean validJdk = !jdkPath.isEmpty() && JavaSdk.checkForJdk((File)new File(jdkPath));
        boolean validSdk = !sdkPath.isEmpty() && DefaultSdks.isValidAndroidSdkPath(new File(sdkPath));
        return !validJdk || !validSdk;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(14, 4, 4, 4), -1, 10, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><b>Android SDK location:</b><br> The directory where the Android SDK is located. This location will be used for new projects, and for existing projects that do not have a local.properties file with a sdk.dir property.</html>");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySdkLocationTextField;
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>JDK location:</b><br> The directory where the Java Development Kit (JDK) is located.</html>");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myJdkLocationTextField;
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, new Dimension(215, -1), null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

