/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.AndroidStatisticsService;
import com.android.tools.idea.stats.BuildRecord;
import com.android.tools.idea.stats.KeyString;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@State(name="StudioBuildStatistic", storages={@Storage(file="$APP_CONFIG$/studio.build.statistics.xml", roamingType=RoamingType.DISABLED)})
public class StudioBuildStatsPersistenceComponent
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private static final int MAX_RECORDS = 1000;
    private static final String TAG_RECORD = "record";
    private static final String TAG_VALUE = "value";
    private static final String ATTR_UTC_MS = "utc_ms";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private final LinkedList<BuildRecord> myRecords = new LinkedList();
    private final SequentialTaskExecutor myTaskExecutor = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);

    @Nullable
    public static StudioBuildStatsPersistenceComponent getInstance() {
        Application app = ApplicationManager.getApplication();
        return app == null ? null : (StudioBuildStatsPersistenceComponent)app.getComponent(StudioBuildStatsPersistenceComponent.class);
    }

    public void addBuildRecord(final @NotNull BuildRecord newRecord) {
        if (newRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRecord", "com/android/tools/idea/stats/StudioBuildStatsPersistenceComponent", "addBuildRecord"));
        }
        this.myTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                StudioBuildStatsPersistenceComponent.this.addBuildRecordImmediately(newRecord);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBuildRecordImmediately(@NotNull BuildRecord newRecord) {
        StatisticsResult code;
        if (newRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRecord", "com/android/tools/idea/stats/StudioBuildStatsPersistenceComponent", "addBuildRecordImmediately"));
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isUnitTestMode() && (code = AndroidStatisticsService.areStatisticsAuthorized()).getCode() != StatisticsResult.ResultCode.SEND) {
            return;
        }
        LinkedList<BuildRecord> linkedList = this.myRecords;
        synchronized (linkedList) {
            this.myRecords.add(newRecord);
            while (this.myRecords.size() > 1000) {
                this.myRecords.removeFirst();
            }
        }
    }

    @NotNull
    LinkedList<BuildRecord> getRecords() {
        LinkedList<BuildRecord> linkedList = this.myRecords;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/StudioBuildStatsPersistenceComponent", "getRecords"));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    BuildRecord getFirstRecord() {
        LinkedList<BuildRecord> linkedList = this.myRecords;
        synchronized (linkedList) {
            if (!this.myRecords.isEmpty()) {
                return this.myRecords.removeFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRecords() {
        LinkedList<BuildRecord> linkedList = this.myRecords;
        synchronized (linkedList) {
            return !this.myRecords.isEmpty();
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("StudioBuildStatsPersistenceComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/StudioBuildStatsPersistenceComponent", "getComponentName"));
        }
        return "StudioBuildStatsPersistenceComponent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/stats/StudioBuildStatsPersistenceComponent", "loadState"));
        }
        LinkedList<BuildRecord> linkedList = this.myRecords;
        synchronized (linkedList) {
            for (Object record : state.getChildren(TAG_RECORD)) {
                Element recordElement = (Element)record;
                long timestampMs = Long.valueOf(recordElement.getAttributeValue(ATTR_UTC_MS));
                ArrayList<KeyString> data = new ArrayList<KeyString>();
                for (Object kv : recordElement.getChildren("value")) {
                    Element valueElement = (Element)kv;
                    data.add(new KeyString(valueElement.getAttributeValue(ATTR_KEY), valueElement.getAttributeValue("value")));
                }
                this.myRecords.add(new BuildRecord(timestampMs, data));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        Element element = new Element("state");
        LinkedList<BuildRecord> linkedList = this.myRecords;
        synchronized (linkedList) {
            for (BuildRecord record : this.myRecords) {
                KeyString[] data = record.getData();
                if (data.length == 0) continue;
                Element recordElement = new Element(TAG_RECORD);
                recordElement.setAttribute(ATTR_UTC_MS, Long.toString(record.getUtcTimestampMs()));
                for (KeyString kv : data) {
                    Element valueElement = new Element("value");
                    valueElement.setAttribute(ATTR_KEY, kv.getKey());
                    valueElement.setAttribute("value", kv.getValue());
                    recordElement.addContent(valueElement);
                }
                element.addContent(recordElement);
            }
        }
        return element;
    }
}

