/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = new IdDisplay("intel", "");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    private static final ScopedStateStore.Key<Boolean> KEY_INSTALL_HAXM = ScopedStateStore.createKey("install.haxm", ScopedStateStore.Scope.PATH, Boolean.class);
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static long memorySize = -1L;
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ScopedStateStore myState;
    private ProgressStep myProgressStep;

    public Haxm(ScopedStateStore.Key<Boolean> isCustomInstall) {
        super("Performance (Intel \u00ae HAXM)", 0x233333L, "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", KEY_INSTALL_HAXM);
        this.myIsCustomInstall = isCustomInstall;
    }

    public static boolean canRun() {
        if (Boolean.getBoolean("install.haxm") && SystemInfo.isWindows || SystemInfo.isMac) {
            return Haxm.getMemorySize() >= Storage.Unit.GiB.getNumberOfBytes();
        }
        return false;
    }

    @NotNull
    private static GeneralCommandLine getMacHaxmInstallCommandLine(File source, int memorySize) {
        String shellScript = Haxm.getAbsolutePathString(source, "silent_install.sh");
        Object[] installerInvocation = new String[]{"/bin/bash", shellScript, "-m", String.valueOf(memorySize)};
        String appleScript = String.format("do shell script \"%s\" with administrator privileges", Joiner.on((String)" ").join(installerInvocation));
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath("/usr/bin/osascript");
        commandLine.setWorkDirectory(source);
        commandLine.addParameters(new String[]{"-e", appleScript});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getMacHaxmInstallCommandLine"));
        }
        return generalCommandLine;
    }

    private static String getAbsolutePathString(File source, String filename) {
        return "'" + new File(source, filename).getAbsolutePath() + "'";
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmInstallCommandLine(File source, int memorySize) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(new File(source, "silent_install.bat").getAbsolutePath());
        commandLine.setWorkDirectory(source);
        commandLine.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getWindowsHaxmInstallCommandLine"));
        }
        return generalCommandLine;
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(Haxm.getMemorySize());
    }

    public static long getMemorySize() {
        if (memorySize < 0L) {
            memorySize = Haxm.checkMemorySize();
        }
        return memorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException oracleSpecificMXBean) {
        }
        catch (NoSuchMethodException oracleSpecificMXBean) {
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    @NotNull
    private static IPkgDesc createExtra(@NotNull IdDisplay vendor, @NotNull String path) {
        if (vendor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vendor", "com/android/tools/idea/welcome/Haxm", "createExtra"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/Haxm", "createExtra"));
        }
        IPkgDesc iPkgDesc = PkgDesc.Builder.newExtra((IdDisplay)vendor, (String)path, (String)"", null, (NoPreviewRevision)new NoPreviewRevision(0)).create();
        if (iPkgDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "createExtra"));
        }
        return iPkgDesc;
    }

    @Override
    public void init(@NotNull ScopedStateStore state, @NotNull ProgressStep progressStep) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/welcome/Haxm", "init"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/Haxm", "init"));
        }
        this.myState = state;
        this.myProgressStep = progressStep;
        state.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        state.put(KEY_INSTALL_HAXM, true);
    }

    @Override
    public DynamicWizardStep[] createSteps() {
        return new DynamicWizardStep[]{new HaxmInstallSettingsStep(this.myIsCustomInstall, KEY_INSTALL_HAXM, KEY_EMULATOR_MEMORY_MB)};
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/Haxm", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/Haxm", "configure"));
        }
        if (!Haxm.canRun()) {
            Logger.getInstance(this.getClass()).error("Tried to install HAXM on %s OS with %s memory size", new String[]{Platform.current().name(), String.valueOf(Haxm.getMemorySize())});
            installContext.print("Unable to install Intel HAXM", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        GeneralCommandLine commandLine = this.getCommandLine(sdk);
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                this.myProgressStep.print("HAXM installation failed. To install HAXM follow the instructions found at http://www.intel.com/software/android/.\n", ConsoleViewContentType.ERROR_OUTPUT);
            }
            progressIndicator.setFraction(1.0);
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getCommandLine(File sdk) {
        int memorySize = this.myState.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = Haxm.getMacHaxmInstallCommandLine(sourceLocation, memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getCommandLine"));
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = Haxm.getWindowsHaxmInstallCommandLine(sourceLocation, memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getCommandLine"));
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        ImmutableList immutableList = ImmutableList.of((Object)Haxm.createExtra(ID_INTEL, COMPONENT_PATH));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getRequiredSdkPackages"));
        }
        return immutableList;
    }
}

