/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesGetter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AllClassesGetter");
    public static final InsertHandler<JavaPsiClassReferenceElement> TRY_SHORTENING = new InsertHandler<JavaPsiClassReferenceElement>(){

        private void _handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            boolean insertFqn;
            RangeMarker toDelete;
            Document document;
            block15: {
                Editor editor = context.getEditor();
                PsiClass psiClass = item.getObject();
                if (!psiClass.isValid()) {
                    return;
                }
                int endOffset = editor.getCaretModel().getOffset();
                String qname = psiClass.getQualifiedName();
                if (qname == null) {
                    return;
                }
                if (endOffset == 0) {
                    return;
                }
                document = editor.getDocument();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiClass.getProject());
                PsiFile file = context.getFile();
                if (file.findElementAt(endOffset - 1) == null) {
                    return;
                }
                OffsetKey key = OffsetKey.create((String)"endOffset", (boolean)false);
                context.getOffsetMap().addOffset(key, endOffset);
                PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                int newOffset = context.getOffsetMap().getOffset(key);
                if (newOffset >= 0) {
                    endOffset = newOffset;
                } else {
                    LOG.error(endOffset + " became invalid: " + context.getOffsetMap() + "; inserting " + qname);
                }
                toDelete = JavaCompletionUtil.insertTemporary(endOffset, document, " ");
                psiDocumentManager.commitAllDocuments();
                PsiReference psiReference = file.findReferenceAt(endOffset - 1);
                insertFqn = true;
                if (psiReference != null) {
                    PsiManager psiManager = file.getManager();
                    if (psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(psiReference))) {
                        insertFqn = false;
                    } else if (psiClass.isValid()) {
                        try {
                            PsiElement psiElement;
                            context.setTailOffset(psiReference.getRangeInElement().getEndOffset() + psiReference.getElement().getTextRange().getStartOffset());
                            PsiElement newUnderlying = psiReference.bindToElement((PsiElement)psiClass);
                            if (newUnderlying == null || (psiElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newUnderlying)) == null) break block15;
                            for (PsiReference reference : psiElement.getReferences()) {
                                if (!psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(reference))) continue;
                                insertFqn = false;
                                break;
                            }
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (toDelete.isValid()) {
                document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                context.setTailOffset(toDelete.getStartOffset());
            }
            if (insertFqn) {
                INSERT_FQN.handleInsert(context, (LookupElement)item);
            }
        }

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            this._handleInsert(context, item);
            item.getTailType().processTail(context.getEditor(), context.getEditor().getCaretModel().getOffset());
        }
    };
    public static final InsertHandler<JavaPsiClassReferenceElement> INSERT_FQN = new InsertHandler<JavaPsiClassReferenceElement>(){

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            String qName = item.getQualifiedName();
            if (qName != null) {
                char ch;
                int start;
                for (start = context.getTailOffset() - 1; start >= 0 && (Character.isJavaIdentifierPart(ch = context.getDocument().getCharsSequence().charAt(start)) || ch == '.'); --start) {
                }
                context.getDocument().replaceString(start + 1, context.getTailOffset(), (CharSequence)qName);
                LOG.assertTrue(context.getTailOffset() >= 0);
            }
        }
    };

    public static void processJavaClasses(final @NotNull CompletionParameters parameters, @NotNull PrefixMatcher prefixMatcher, final boolean filterByScope, final @NotNull Consumer<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (prefixMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        final PsiElement context = parameters.getPosition();
        Project project = context.getProject();
        GlobalSearchScope scope = filterByScope ? context.getContainingFile().getResolveScope() : GlobalSearchScope.allScope((Project)project);
        Processor<PsiClass> processor = new Processor<PsiClass>(){
            final Set<String> qNames = new THashSet();
            final boolean pkgContext = JavaCompletionUtil.inSomePackage(context);
            final String packagePrefix = AllClassesGetter.access$100(context, parameters.getOffset());

            public boolean process(PsiClass psiClass) {
                String qName;
                if (parameters.getInvocationCount() < 2) {
                    if (PsiReferenceExpressionImpl.seemsScrambled(psiClass)) {
                        return true;
                    }
                    if (!StringUtil.isCapitalized((String)psiClass.getName()) && !Registry.is((String)"ide.completion.show.lower.case.classes")) {
                        return true;
                    }
                }
                assert (psiClass != null);
                if (AllClassesGetter.isAcceptableInContext(context, psiClass, filterByScope, this.pkgContext) && (qName = psiClass.getQualifiedName()) != null && qName.startsWith(this.packagePrefix) && this.qNames.add(qName)) {
                    consumer.consume((Object)psiClass);
                }
                return true;
            }
        };
        AllClassesGetter.processJavaClasses(prefixMatcher, project, scope, processor);
    }

    public static void processJavaClasses(final @NotNull PrefixMatcher prefixMatcher, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiClass> processor) {
        if (prefixMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(project, scope, new Consumer<String>((Set)names){
            final /* synthetic */ Set val$names;
            {
                this.val$names = set;
            }

            public void consume(String s) {
                if (prefixMatcher.prefixMatches(s)) {
                    this.val$names.add(s);
                }
            }
        });
        LinkedHashSet<String> sorted = CompletionUtil.sortMatching(prefixMatcher, (Collection<String>)names);
        AllClassesSearchExecutor.processClassesByNames(project, scope, sorted, processor);
    }

    private static String getPackagePrefix(PsiElement context, int offset) {
        char c;
        int i;
        CharSequence fileText = context.getContainingFile().getViewProvider().getContents();
        for (i = offset - 1; i >= 0 && (Character.isJavaIdentifierPart(c = fileText.charAt(i)) || c == '.'); --i) {
        }
        String prefix = fileText.subSequence(i + 1, offset).toString();
        int j = prefix.lastIndexOf(46);
        return j > 0 ? prefix.substring(0, j) : "";
    }

    public static boolean isAcceptableInContext(@NotNull PsiElement context, @NotNull PsiClass psiClass, boolean filterByScope, boolean pkgContext) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/AllClassesGetter", "isAcceptableInContext"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/AllClassesGetter", "isAcceptableInContext"));
        }
        ProgressManager.checkCanceled();
        if (JavaCompletionUtil.isInExcludedPackage((PsiMember)psiClass, false)) {
            return false;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (!filterByScope && !(psiClass instanceof PsiCompiledElement)) {
            return true;
        }
        return JavaCompletionUtil.isSourceLevelAccessible(context, psiClass, pkgContext);
    }

    public static JavaPsiClassReferenceElement createLookupItem(@NotNull PsiClass psiClass, InsertHandler<JavaPsiClassReferenceElement> insertHandler) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/AllClassesGetter", "createLookupItem"));
        }
        JavaPsiClassReferenceElement item = new JavaPsiClassReferenceElement(psiClass);
        item.setInsertHandler((InsertHandler)insertHandler);
        return item;
    }

    static /* synthetic */ String access$100(PsiElement x0, int x1) {
        return AllClassesGetter.getPackagePrefix(x0, x1);
    }
}

