/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "addCompletions"));
        }
        result.addAllElements(FunctionalExpressionCompletionProvider.getLambdaVariants(parameters, false));
    }

    static List<LookupElement> getLambdaVariants(@NotNull CompletionParameters parameters, boolean prioritize) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/FunctionalExpressionCompletionProvider", "getLambdaVariants"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameters.getOriginalFile())) {
            return Collections.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (ExpectedTypeInfo expectedType : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
            PsiClass paramClass;
            PsiType expectedReturnType;
            PsiType functionalInterfaceType;
            PsiMethod functionalInterfaceMethod;
            PsiType defaultType = expectedType.getDefaultType();
            if (!LambdaUtil.isFunctionalType((PsiType)defaultType) || (functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(defaultType)))) == null) continue;
            assert (functionalInterfaceType != null);
            Object[] params = new PsiParameter[]{};
            final PsiElement originalPosition = parameters.getPosition();
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)functionalInterfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
            if (!functionalInterfaceMethod.hasTypeParameters()) {
                params = functionalInterfaceMethod.getParameterList().getParameters();
                Project project = functionalInterfaceMethod.getProject();
                JVMElementFactory jvmElementFactory = JVMElementFactories.getFactory((Language)originalPosition.getLanguage(), (Project)project);
                final JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                if (jvmElementFactory != null) {
                    params = GenerateMembersUtil.overriddenParameters((PsiParameter[])params, jvmElementFactory, javaCodeStyleManager, substitutor, originalPosition);
                }
                String paramsString = params.length == 1 ? FunctionalExpressionCompletionProvider.getParamName(params[0], javaCodeStyleManager, originalPosition) : "(" + StringUtil.join((Object[])params, (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter parameter) {
                        return FunctionalExpressionCompletionProvider.getParamName(parameter, javaCodeStyleManager, originalPosition);
                    }
                }, (String)",") + ")";
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(paramsString + " -> {}", null);
                lambdaExpression = (PsiLambdaExpression)codeStyleManager.reformat((PsiElement)lambdaExpression);
                paramsString = lambdaExpression.getParameterList().getText();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)functionalInterfaceMethod, (String)paramsString).withPresentableText(paramsString + " -> {}").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" -> ");
                    }
                }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.Function);
                LookupElement lambdaElement = builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                if (prioritize) {
                    lambdaElement = PrioritizedLookupElement.withPriority((LookupElement)lambdaElement, (double)1.0);
                }
                result.add(lambdaElement);
            }
            if (params.length != 1 || (expectedReturnType = substitutor.substitute(functionalInterfaceMethod.getReturnType())) == null || (paramClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)params[0].getType())) == null || paramClass.hasTypeParameters()) continue;
            HashSet<String> visited = new HashSet<String>();
            for (PsiMethod psiMethod : paramClass.getAllMethods()) {
                PsiType returnType = psiMethod.getReturnType();
                if (returnType == null || psiMethod.getParameterList().getParametersCount() != 0 || !visited.add(psiMethod.getName()) || psiMethod.hasModifierProperty("static") || !JavaResolveUtil.isAccessible((PsiMember)psiMethod, null, psiMethod.getModifierList(), originalPosition, null, null) || !TypeConversionUtil.isAssignable((PsiType)expectedReturnType, (PsiType)returnType)) continue;
                LookupElement methodRefLookupElement = LookupElementBuilder.create((PsiNamedElement)psiMethod).withPresentableText(paramClass.getName() + "::" + psiMethod.getName()).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        int startOffset = context.getStartOffset();
                        Document document = context.getDocument();
                        PsiFile file = context.getFile();
                        document.insertString(startOffset, (CharSequence)"::");
                        JavaCompletionUtil.insertClassReference(paramClass, file, startOffset);
                    }
                }).withTypeText(functionalInterfaceType.getPresentableText()).withIcon(AllIcons.Nodes.MethodReference).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                if (prioritize && psiMethod.getContainingClass() == paramClass) {
                    methodRefLookupElement = PrioritizedLookupElement.withPriority((LookupElement)methodRefLookupElement, (double)1.0);
                }
                result.add(methodRefLookupElement);
            }
        }
        return result;
    }

    private static String getParamName(PsiParameter param, JavaCodeStyleManager javaCodeStyleManager, PsiElement originalPosition) {
        return javaCodeStyleManager.suggestUniqueVariableName(param.getName(), originalPosition, true);
    }
}

