/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.InputEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GutterIntentionAction
extends AbstractIntentionAction
implements Comparable<IntentionAction> {
    private final AnAction myAction;
    private final int myOrder;
    private String myText;

    private GutterIntentionAction(AnAction action, int order) {
        this.myAction = action;
        this.myOrder = order;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "invoke"));
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        this.myAction.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), ((EditorEx)editor).getDataContext(), this.myText, new Presentation(), ActionManager.getInstance(), 0));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "isAvailable"));
        }
        if (this.myText == null) {
            AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)((EditorEx)editor).getDataContext());
            this.myAction.update(event);
            this.myText = event.getPresentation().getText();
            if (this.myText == null) {
                this.myText = this.myAction.getTemplatePresentation().getText();
            }
            if (this.myText == null) {
                this.myText = "";
            } else {
                ShortcutSet shortcutSet = this.myAction.getShortcutSet();
                Object[] shortcuts = shortcutSet.getShortcuts();
                Shortcut element = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcuts);
                if (element != null) {
                    String text = KeymapUtil.getShortcutText((Shortcut)element);
                    this.myText = this.myText + " (" + text + ")";
                }
            }
        }
        return StringUtil.isNotEmpty((String)this.myText);
    }

    @NotNull
    public String getText() {
        String string = StringUtil.notNullize((String)this.myText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "getText"));
        }
        return string;
    }

    static void addActions(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull RangeHighlighterEx info, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        GutterIconRenderer renderer = info.getGutterIconRenderer();
        if (renderer == null || DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)renderer)) {
            return;
        }
        GutterIntentionAction.addActions(project, editor, psiFile, renderer.getClickAction(), descriptors, renderer, 0);
        GutterIntentionAction.addActions(project, editor, psiFile, renderer.getMiddleButtonClickAction(), descriptors, renderer, 0);
        GutterIntentionAction.addActions(project, editor, psiFile, renderer.getRightButtonClickAction(), descriptors, renderer, 0);
        GutterIntentionAction.addActions(project, editor, psiFile, (AnAction)renderer.getPopupMenuActions(), descriptors, renderer, 0);
    }

    private static void addActions(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @Nullable AnAction action, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, int order) {
        GutterIntentionAction gutterAction;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (action == null) {
            return;
        }
        if (action instanceof ActionGroup) {
            AnAction[] children = ((ActionGroup)action).getChildren(null);
            for (int i = 0; i < children.length; ++i) {
                AnAction child = children[i];
                GutterIntentionAction.addActions(project, editor, psiFile, child, descriptors, renderer, i + order);
            }
        }
        if (!(gutterAction = new GutterIntentionAction(action, order)).isAvailable(project, editor, psiFile)) {
            return;
        }
        Icon icon = action.getTemplatePresentation().getIcon();
        if (icon == null) {
            icon = renderer.getIcon();
        }
        if (icon.getIconWidth() < 16) {
            icon = IconUtil.toSize((Icon)icon, (int)16, (int)16);
        }
        HighlightInfo.IntentionActionDescriptor descriptor = new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon, (IntentionAction)gutterAction){
            final /* synthetic */ IntentionAction val$gutterAction;
            {
                this.val$gutterAction = intentionAction;
                super(arg0, arg1, arg2, arg3);
            }

            @Override
            @Nullable
            public String getDisplayName() {
                return this.val$gutterAction.getText();
            }
        };
        descriptors.add(descriptor);
    }

    @Override
    public int compareTo(@NotNull IntentionAction o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "compareTo"));
        }
        if (o instanceof GutterIntentionAction) {
            return this.myOrder - ((GutterIntentionAction)o).myOrder;
        }
        return 0;
    }
}

