/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupActionsStep;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupOffsets;
import com.intellij.codeInsight.lookup.impl.LookupUi;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupImpl
extends LightweightHint
implements LookupEx,
Disposable,
WeighingContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupImpl");
    private final LookupOffsets myOffsets;
    private final Project myProject;
    private final Editor myEditor;
    private final JBList myList;
    final LookupCellRenderer myCellRenderer;
    private final List<LookupListener> myListeners;
    private long myStampShown;
    private boolean myShown;
    private boolean myDisposed;
    private boolean myHidden;
    private boolean mySelectionTouched;
    private FocusDegree myFocusDegree;
    private volatile boolean myCalculating;
    private final Advertiser myAdComponent;
    volatile int myLookupTextWidth;
    private boolean myChangeGuard;
    private volatile LookupArranger myArranger;
    private LookupArranger myPresentableArranger;
    private final Map<LookupElement, PrefixMatcher> myMatchers;
    private final Map<LookupElement, Font> myCustomFonts;
    private boolean myStartCompletionWhenNothingMatches;
    boolean myResizePending;
    private boolean myFinishing;
    boolean myUpdating;
    private LookupUi myUi;
    private static String staticDisposeTrace = null;
    private String disposeTrace;

    public LookupImpl(Project project, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arranger", "com/intellij/codeInsight/lookup/impl/LookupImpl", "<init>"));
        }
        super(new JPanel(new BorderLayout()));
        this.myList = new JBList((ListModel)new CollectionListModel((Object[])new LookupElement[0])){

            protected void processKeyEvent(final @NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "processKeyEvent"));
                }
                char keyChar = e.getKeyChar();
                if (keyChar == '\n' || keyChar == '\t') {
                    IdeFocusManager.getInstance((Project)LookupImpl.this.myProject).requestFocus((Component)LookupImpl.this.myEditor.getContentComponent(), true).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            IdeEventQueue.getInstance().getKeyEventDispatcher().dispatchKeyEvent(e);
                        }
                    });
                    return;
                }
                super.processKeyEvent(e);
            }

            @NotNull
            protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
                CompletionExtender completionExtender = new CompletionExtender((JList)((Object)this));
                if (completionExtender == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl$1", "createExpandableItemsHandler"));
                }
                return completionExtender;
            }
        };
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myStampShown = 0L;
        this.myShown = false;
        this.myDisposed = false;
        this.myHidden = false;
        this.myFocusDegree = FocusDegree.FOCUSED;
        this.myLookupTextWidth = 50;
        this.myMatchers = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myCustomFonts = ContainerUtil.createConcurrentWeakMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.disposeTrace = null;
        this.setForceShowAsPopup(true);
        this.setCancelOnClickOutside(false);
        this.setResizable(true);
        AbstractPopup.suppressMacCornerFor((JComponent)this.getComponent());
        this.myProject = project;
        this.myEditor = editor;
        this.myArranger = arranger;
        this.myPresentableArranger = arranger;
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        this.myCellRenderer = new LookupCellRenderer(this);
        this.myList.setCellRenderer((ListCellRenderer)this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setFixedCellWidth(50);
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myList.getExpandableItemsHandler();
        this.myAdComponent = new Advertiser();
        this.myOffsets = new LookupOffsets(editor);
        CollectionListModel<LookupElement> model = this.getListModel();
        this.addEmptyItem(model);
        this.updateListHeight((ListModel)model);
        this.addListeners();
    }

    private CollectionListModel<LookupElement> getListModel() {
        return (CollectionListModel)this.myList.getModel();
    }

    public void setArranger(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    public FocusDegree getFocusDegree() {
        return this.myFocusDegree;
    }

    public boolean isFocused() {
        return this.getFocusDegree() == FocusDegree.FOCUSED;
    }

    public void setFocusDegree(FocusDegree focusDegree) {
        this.myFocusDegree = focusDegree;
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
        if (this.myUi != null) {
            this.myUi.setCalculating(calculating);
        }
    }

    public void markSelectionTouched() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.mySelectionTouched = true;
        this.myList.repaint();
    }

    public void setSelectionTouched(boolean selectionTouched) {
        this.mySelectionTouched = selectionTouched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resort(boolean addAgain) {
        List<LookupElement> items = this.getItems();
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
            this.getListModel().removeAll();
        }
        if (addAgain) {
            for (LookupElement item : items) {
                this.addItem(item, this.itemMatcher(item));
            }
        }
        this.refreshUi(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(LookupElement item, PrefixMatcher matcher) {
        LookupElementPresentation presentation = LookupImpl.renderItemApproximately(item);
        if (LookupImpl.containsDummyIdentifier(presentation.getItemText()) || LookupImpl.containsDummyIdentifier(presentation.getTailText()) || LookupImpl.containsDummyIdentifier(presentation.getTypeText())) {
            return false;
        }
        this.myMatchers.put(item, matcher);
        this.updateLookupWidth(item, presentation);
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myArranger.addElement(this, item, presentation);
        }
        return true;
    }

    private static boolean containsDummyIdentifier(@Nullable String s) {
        return s != null && s.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    public void updateLookupWidth(LookupElement item) {
        this.updateLookupWidth(item, LookupImpl.renderItemApproximately(item));
    }

    private void updateLookupWidth(LookupElement item, LookupElementPresentation presentation) {
        Font customFont = this.myCellRenderer.getFontAbleToDisplay(presentation);
        if (customFont != null) {
            this.myCustomFonts.put(item, customFont);
        }
        int maxWidth = this.myCellRenderer.updateMaximumWidth(presentation, item);
        this.myLookupTextWidth = Math.max(maxWidth, this.myLookupTextWidth);
    }

    @Nullable
    public Font getCustomFont(LookupElement item, boolean bold) {
        Font font = this.myCustomFonts.get(item);
        return font == null ? null : (bold ? font.deriveFont(1) : font);
    }

    public void requestResize() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myResizePending = true;
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element) {
        CollectConsumer consumer = new CollectConsumer();
        for (LookupActionProvider provider : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider.fillActions(element, this, (Consumer<LookupElementAction>)consumer);
        }
        if (!consumer.getResult().isEmpty()) {
            consumer.consume((Object)new ShowHideIntentionIconLookupAction());
        }
        return consumer.getResult();
    }

    public JList getList() {
        return this.myList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LookupElement> getItems() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            return ContainerUtil.findAll((Collection)this.getListModel().toList(), (Condition)new Condition<LookupElement>(){

                public boolean value(LookupElement element) {
                    return !(element instanceof EmptyLookupItem);
                }
            });
        }
    }

    public String getAdditionalPrefix() {
        return this.myOffsets.getAdditionalPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendPrefix(char c) {
        this.checkValid();
        this.myOffsets.appendPrefix(c);
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
        }
        this.requestResize();
        this.refreshUi(false, true);
        this.ensureSelectionVisible(true);
    }

    public void setStartCompletionWhenNothingMatches(boolean startCompletionWhenNothingMatches) {
        this.myStartCompletionWhenNothingMatches = startCompletionWhenNothingMatches;
    }

    public boolean isStartCompletionWhenNothingMatches() {
        return this.myStartCompletionWhenNothingMatches;
    }

    public void ensureSelectionVisible(boolean forceTopSelection) {
        int firstVisibleIndex;
        if (this.isSelectionVisible() && !forceTopSelection) {
            return;
        }
        if (!forceTopSelection) {
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)this.myList.getSelectedIndex(), (int)1);
            return;
        }
        int top = this.myList.getSelectedIndex();
        if (top > 0) {
            --top;
        }
        if ((firstVisibleIndex = this.myList.getFirstVisibleIndex()) == top) {
            return;
        }
        ScrollingUtil.ensureRangeIsVisible((JList)this.myList, (int)top, (int)(top + this.myList.getLastVisibleIndex() - firstVisibleIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncatePrefix(boolean preserveSelection) {
        boolean shouldUpdate;
        if (!this.myOffsets.truncatePrefix()) {
            return false;
        }
        if (preserveSelection) {
            this.markSelectionTouched();
        }
        JBList jBList = this.myList;
        synchronized (jBList) {
            shouldUpdate = this.myPresentableArranger == this.myArranger;
            this.myPresentableArranger.prefixChanged(this);
        }
        this.requestResize();
        if (shouldUpdate) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateList(boolean onExplicitAction, boolean reused) {
        Pair<List<LookupElement>, Integer> pair;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.checkValid();
        CollectionListModel<LookupElement> listModel = this.getListModel();
        JBList jBList = this.myList;
        synchronized (jBList) {
            pair = this.myPresentableArranger.arrangeItems(this, onExplicitAction || reused);
        }
        List items = (List)pair.first;
        Integer toSelect = (Integer)pair.second;
        if (toSelect == null || toSelect < 0 || items.size() > 0 && toSelect >= items.size()) {
            LOG.error("Arranger " + this.myPresentableArranger + " returned invalid selection index=" + toSelect + "; items=" + items);
            toSelect = 0;
        }
        this.myOffsets.checkMinPrefixLengthChanges(items, this);
        List oldModel = listModel.toList();
        listModel.removeAll();
        if (!items.isEmpty()) {
            listModel.add(items);
        } else {
            this.addEmptyItem(listModel);
        }
        this.updateListHeight((ListModel)listModel);
        this.myList.setSelectedIndex(toSelect.intValue());
        return !ContainerUtil.equalsIdentity((List)oldModel, (List)items);
    }

    private boolean isSelectionVisible() {
        return ScrollingUtil.isIndexFullyVisible((JList)this.myList, (int)this.myList.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkReused() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            if (this.myPresentableArranger != this.myArranger) {
                this.myPresentableArranger = this.myArranger;
                this.myOffsets.clearAdditionalPrefix();
                this.myPresentableArranger.prefixChanged(this);
                return true;
            }
            return false;
        }
    }

    private void updateListHeight(ListModel model) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, model.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model.getSize(), UISettings.getInstance().MAX_LOOKUP_LIST_HEIGHT));
    }

    private void addEmptyItem(CollectionListModel<LookupElement> model) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message("completion.no.suggestions", new Object[0]), false);
        this.myMatchers.put((LookupElement)item, new CamelHumpMatcher(""));
        model.add((Object)item);
        this.updateLookupWidth((LookupElement)item);
        this.requestResize();
    }

    private static LookupElementPresentation renderItemApproximately(LookupElement item) {
        LookupElementPresentation p = new LookupElementPresentation();
        item.renderElement(p);
        return p;
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.getAdditionalPrefix();
        String string = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemPattern"));
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        PrefixMatcher matcher = this.itemMatcherNullable(item);
        if (matcher == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + item + "; lookup items=" + this.getItems()));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "itemMatcher"));
        }
        return prefixMatcher;
    }

    public PrefixMatcher itemMatcherNullable(LookupElement item) {
        return this.myMatchers.get(item);
    }

    public void finishLookup(char completionChar) {
        this.finishLookup(completionChar, (LookupElement)this.myList.getSelectedValue());
    }

    public void finishLookup(char completionChar, final @Nullable LookupElement item) {
        boolean writableOk;
        if (item == null || item instanceof EmptyLookupItem || item.getObject() instanceof DeferredUserLookupValue && item.as(LookupItem.CLASS_CONDITION_KEY) != null && !((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY), this.myProject)) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        if (this.myDisposed) {
            return;
        }
        PsiFile file = this.getPsiFile();
        boolean bl = writableOk = file == null || FileModificationService.getInstance().prepareFileForWrite(file);
        if (this.myDisposed) {
            return;
        }
        if (!writableOk) {
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        final String prefix = this.itemPattern(item);
        boolean plainMatch = ContainerUtil.or((Iterable)item.getAllLookupStrings(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return StringUtil.containsIgnoreCase((String)s, (String)prefix);
            }
        });
        if (!plainMatch) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
        }
        this.myFinishing = true;
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                LookupImpl.this.myEditor.getDocument().startGuardedBlockChecking();
                try {
                    LookupImpl.this.insertLookupString(item, LookupImpl.this.getPrefixLength(item));
                }
                finally {
                    LookupImpl.this.myEditor.getDocument().stopGuardedBlockChecking();
                }
            }
        });
        if (this.myDisposed) {
            return;
        }
        this.doHide(false, true);
        this.fireItemSelected(item, completionChar);
    }

    public int getPrefixLength(LookupElement item) {
        return this.myOffsets.getPrefixLength(item, this);
    }

    private void insertLookupString(LookupElement item, final int prefix) {
        final String lookupString = this.getCaseCorrectedLookupString(item);
        final Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(this.myEditor);
        hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                EditorModificationUtil.deleteSelectedText((Editor)hostEditor);
                int caretOffset = hostEditor.getCaretModel().getOffset();
                int lookupStart = Math.min(caretOffset, Math.max(caretOffset - prefix, 0));
                int len = hostEditor.getDocument().getTextLength();
                LOG.assertTrue(lookupStart >= 0 && lookupStart <= len, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len));
                LOG.assertTrue(caretOffset >= 0 && caretOffset <= len, (Object)("co: " + caretOffset + " doc: " + len));
                hostEditor.getDocument().replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
                int offset = lookupStart + lookupString.length();
                hostEditor.getCaretModel().moveToOffset(offset);
                hostEditor.getSelectionModel().removeSelection();
            }
        });
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private String getCaseCorrectedLookupString(LookupElement item) {
        String lookupString = item.getLookupString();
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        String prefix = this.itemPattern(item);
        int length = prefix.length();
        if (length == 0 || !this.itemMatcher(item).prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        for (int i = 0; i < length && (isAllLower || isAllUpper || sameCase); ++i) {
            char c = prefix.charAt(i);
            boolean isLower = Character.isLowerCase(c);
            boolean isUpper = Character.isUpperCase(c);
            if (!isLower && !isUpper) continue;
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && isLower == Character.isLowerCase(lookupString.charAt(i));
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            return lookupString.toLowerCase();
        }
        if (isAllUpper) {
            return StringUtil.toUpperCase((String)lookupString);
        }
        return lookupString;
    }

    public int getLookupStart() {
        return this.myOffsets.getLookupStart(this.disposeTrace);
    }

    public int getLookupOriginalStart() {
        return this.myOffsets.getLookupOriginalStart();
    }

    public boolean performGuardedChange(Runnable change) {
        boolean result;
        this.checkValid();
        assert (!this.myChangeGuard) : "already in change";
        this.myEditor.getDocument().startGuardedBlockChecking();
        this.myChangeGuard = true;
        try {
            result = this.myOffsets.performGuardedChange(change);
        }
        finally {
            this.myEditor.getDocument().stopGuardedBlockChecking();
            this.myChangeGuard = false;
        }
        if (!result || this.myDisposed) {
            this.hide();
            return false;
        }
        if (this.isVisible()) {
            HintManagerImpl.updateLocation(this, this.myEditor, this.myUi.calculatePosition().getLocation());
        }
        this.checkValid();
        return true;
    }

    @Override
    public boolean vetoesHiding() {
        return this.myChangeGuard;
    }

    public boolean isAvailableToUser() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myShown;
        }
        return this.isVisible();
    }

    public boolean isShown() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return this.myShown;
    }

    public boolean showLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkValid();
        LOG.assertTrue(!this.myShown);
        this.myShown = true;
        this.myStampShown = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!this.myEditor.getContentComponent().isShowing()) {
            this.hide();
            return false;
        }
        this.myAdComponent.showRandomText();
        this.myUi = new LookupUi(this, this.myAdComponent, this.myList, this.myProject);
        this.myUi.setCalculating(this.myCalculating);
        Point p = this.myUi.calculatePosition().getLocation();
        try {
            HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myEditor, p, 129, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, this, (short)2).setAwtTooltip(false));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (!this.isVisible() || !this.myList.isShowing()) {
            this.hide();
            return false;
        }
        return true;
    }

    public Advertiser getAdvertiser() {
        return this.myAdComponent;
    }

    public boolean mayBeNoticed() {
        return this.myStampShown > 0L && System.currentTimeMillis() - this.myStampShown > 300L;
    }

    private void addListeners() {
        this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        }, (Disposable)this);
        CaretAdapter caretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hide();
                }
            }
        };
        EditorMouseAdapter mouseListener = new EditorMouseAdapter(){

            public void mouseClicked(EditorMouseEvent e) {
                e.consume();
                LookupImpl.this.hide();
            }
        };
        this.myEditor.getCaretModel().addCaretListener((CaretListener)caretListener);
        this.myEditor.getSelectionModel().addSelectionListener(selectionListener);
        this.myEditor.addEditorMouseListener((EditorMouseListener)mouseListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable((CaretListener)caretListener, selectionListener, (EditorMouseListener)mouseListener){
            final /* synthetic */ CaretListener val$caretListener;
            final /* synthetic */ SelectionListener val$selectionListener;
            final /* synthetic */ EditorMouseListener val$mouseListener;
            {
                this.val$caretListener = caretListener;
                this.val$selectionListener = selectionListener;
                this.val$mouseListener = editorMouseListener;
            }

            public void dispose() {
                LookupImpl.this.myEditor.getCaretModel().removeCaretListener(this.val$caretListener);
                LookupImpl.this.myEditor.getSelectionModel().removeSelectionListener(this.val$selectionListener);
                LookupImpl.this.myEditor.removeEditorMouseListener(this.val$mouseListener);
            }
        });
        JComponent editorComponent = this.myEditor.getContentComponent();
        if (editorComponent.isShowing()) {
            Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editorComponent, new Activatable(){

                public void showNotify() {
                }

                public void hideNotify() {
                    LookupImpl.this.hideLookup(false);
                }
            }));
        }
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$12", "valueChanged"));
                }
                if (!LookupImpl.this.myUpdating) {
                    LookupElement item = LookupImpl.this.getCurrentItem();
                    LookupImpl.this.fireCurrentItemChanged(this.oldItem, item);
                    this.oldItem = item;
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$13", "onClick"));
                }
                LookupImpl.this.setFocusDegree(FocusDegree.FOCUSED);
                LookupImpl.this.markSelectionTouched();
                if (clickCount == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            LookupImpl.this.finishLookup('\n');
                        }
                    }, "", null);
                }
                return true;
            }
        }.installOn((Component)this.myList);
    }

    @Nullable
    public LookupElement getCurrentItem() {
        LookupElement item = (LookupElement)this.myList.getSelectedValue();
        return item instanceof EmptyLookupItem ? null : item;
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        this.markSelectionTouched();
        this.myList.setSelectedValue((Object)item, false);
    }

    public void addLookupListener(LookupListener listener) {
        this.myListeners.add(listener);
    }

    public void removeLookupListener(LookupListener listener) {
        this.myListeners.remove(listener);
    }

    public Rectangle getCurrentItemBounds() {
        Rectangle itmBounds;
        int index = this.myList.getSelectedIndex();
        if (index < 0) {
            LOG.error("No selected element, size=" + this.getListModel().getSize() + "; items" + this.getItems());
        }
        if ((itmBounds = this.myList.getCellBounds(index, index)) == null) {
            LOG.error("No bounds for " + index + "; size=" + this.getListModel().getSize());
            return null;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint((Component)this.myList, itmBounds.x, itmBounds.y, this.getComponent());
        itmBounds.x = layeredPanePoint.x;
        itmBounds.y = layeredPanePoint.y;
        return itmBounds;
    }

    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener : this.myListeners) {
                try {
                    listener.itemSelected(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireLookupCanceled(boolean explicitly) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, explicitly);
            for (LookupListener listener : this.myListeners) {
                try {
                    listener.lookupCanceled(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireCurrentItemChanged(@Nullable LookupElement oldItem, @Nullable LookupElement currentItem) {
        if (oldItem != currentItem && !this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, currentItem, '\u0000');
            for (LookupListener listener : this.myListeners) {
                listener.currentItemChanged(event);
            }
        }
    }

    public boolean fillInCommonPrefix(boolean explicitlyInvoked) {
        LookupElement item;
        int i;
        if (explicitlyInvoked) {
            this.setFocusDegree(FocusDegree.FOCUSED);
        }
        if (explicitlyInvoked && this.myCalculating) {
            return false;
        }
        if (!explicitlyInvoked && this.mySelectionTouched) {
            return false;
        }
        CollectionListModel<LookupElement> listModel = this.getListModel();
        if (listModel.getSize() <= 1) {
            return false;
        }
        if (listModel.getSize() == 0) {
            return false;
        }
        LookupElement firstItem = (LookupElement)listModel.getElementAt(0);
        if (listModel.getSize() == 1 && firstItem instanceof EmptyLookupItem) {
            return false;
        }
        PrefixMatcher firstItemMatcher = this.itemMatcher(firstItem);
        String oldPrefix = firstItemMatcher.getPrefix();
        String presentPrefix = oldPrefix + this.getAdditionalPrefix();
        String commonPrefix = this.getCaseCorrectedLookupString(firstItem);
        for (i = 1; i < listModel.getSize(); ++i) {
            item = (LookupElement)listModel.getElementAt(i);
            if (item instanceof EmptyLookupItem) {
                return false;
            }
            if (!oldPrefix.equals(this.itemMatcher(item).getPrefix())) {
                return false;
            }
            String lookupString = this.getCaseCorrectedLookupString(item);
            int length = Math.min(commonPrefix.length(), lookupString.length());
            if (length < commonPrefix.length()) {
                commonPrefix = commonPrefix.substring(0, length);
            }
            for (int j = 0; j < length; ++j) {
                if (commonPrefix.charAt(j) == lookupString.charAt(j)) continue;
                commonPrefix = lookupString.substring(0, j);
                break;
            }
            if (commonPrefix.length() != 0 && commonPrefix.length() >= presentPrefix.length()) continue;
            return false;
        }
        if (commonPrefix.equals(presentPrefix)) {
            return false;
        }
        for (i = 0; i < listModel.getSize(); ++i) {
            item = (LookupElement)listModel.getElementAt(i);
            if (this.itemMatcher(item).cloneWithPrefix(commonPrefix).prefixMatches(item)) continue;
            return false;
        }
        this.myOffsets.setInitialPrefix(presentPrefix, explicitlyInvoked);
        this.replacePrefix(presentPrefix, commonPrefix);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePrefix(final String presentPrefix, final String newPrefix) {
        if (!this.performGuardedChange(new Runnable(){

            @Override
            public void run() {
                EditorModificationUtil.deleteSelectedText((Editor)LookupImpl.this.myEditor);
                int offset = LookupImpl.this.myEditor.getCaretModel().getOffset();
                int start = offset - presentPrefix.length();
                LookupImpl.this.myEditor.getDocument().replaceString(start, offset, (CharSequence)newPrefix);
                HashMap<LookupElement, PrefixMatcher> newMatchers = new HashMap<LookupElement, PrefixMatcher>();
                for (LookupElement item : LookupImpl.this.getItems()) {
                    PrefixMatcher matcher;
                    if (!item.isValid() || !(matcher = LookupImpl.this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
                    newMatchers.put(item, matcher);
                }
                LookupImpl.this.myMatchers.clear();
                LookupImpl.this.myMatchers.putAll(newMatchers);
                LookupImpl.this.myOffsets.clearAdditionalPrefix();
                LookupImpl.this.myEditor.getCaretModel().moveToOffset(start + newPrefix.length());
            }
        })) {
            return;
        }
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myPresentableArranger.prefixChanged(this);
        }
        this.refreshUi(true, true);
    }

    @Nullable
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
    }

    public boolean isCompletion() {
        return this.myArranger instanceof CompletionLookupArranger;
    }

    public PsiElement getPsiElement() {
        PsiFile file = this.getPsiFile();
        if (file == null) {
            return null;
        }
        int offset = this.getLookupStart();
        if (offset > 0) {
            return file.findElementAt(offset - 1);
        }
        return file.findElementAt(0);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupImpl", "getEditor"));
        }
        return editor;
    }

    public boolean isPositionedAboveCaret() {
        return this.myUi != null && this.myUi.isPositionedAboveCaret();
    }

    public boolean isSelectionTouched() {
        return this.mySelectionTouched;
    }

    public List<String> getAdvertisements() {
        return this.myAdComponent.getAdvertisements();
    }

    @Override
    public void hide() {
        this.hideLookup(true);
    }

    public void hideLookup(boolean explicitly) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHidden) {
            return;
        }
        this.doHide(true, explicitly);
    }

    private void doHide(boolean fireCanceled, boolean explicitly) {
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
        } else {
            this.myHidden = true;
            try {
                super.hide();
                Disposer.dispose((Disposable)this);
                assert (this.myDisposed);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (fireCanceled) {
            this.fireLookupCanceled(explicitly);
        }
    }

    public void restorePrefix() {
        this.myOffsets.restorePrefix();
    }

    public static String getLastLookupDisposeTrace() {
        return staticDisposeTrace;
    }

    public void dispose() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        assert (this.myHidden);
        if (this.myDisposed) {
            LOG.error(this.disposeTrace);
            return;
        }
        this.myOffsets.disposeMarkers();
        this.myDisposed = true;
        staticDisposeTrace = this.disposeTrace = DebugUtil.currentStackTrace() + "\n============";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        assert (!this.myUpdating);
        LookupElement prevItem = this.getCurrentItem();
        this.myUpdating = true;
        try {
            boolean reused = mayCheckReused && this.checkReused();
            boolean selectionVisible = this.isSelectionVisible();
            boolean itemsChanged = this.updateList(onExplicitAction, reused);
            if (this.isVisible()) {
                LOG.assertTrue(!ApplicationManager.getApplication().isUnitTestMode());
                this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
            }
        }
        finally {
            this.myUpdating = false;
            this.fireCurrentItemChanged(prevItem, this.getCurrentItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markReused() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            this.myArranger = this.myArranger.createEmptyCopy();
        }
        this.requestResize();
    }

    public void addAdvertisement(@NotNull String text, @Nullable Color bgColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/lookup/impl/LookupImpl", "addAdvertisement"));
        }
        if (LookupImpl.containsDummyIdentifier(text)) {
            return;
        }
        this.myAdComponent.addAdvertisement(text, bgColor);
        this.requestResize();
    }

    public boolean isLookupDisposed() {
        return this.myDisposed;
    }

    public void checkValid() {
        if (this.myDisposed) {
            throw new AssertionError((Object)("Disposed at: " + this.disposeTrace));
        }
    }

    @Override
    public void showItemPopup(JBPopup hint) {
        Rectangle bounds = this.getCurrentItemBounds();
        hint.show(new RelativePoint(this.getComponent(), new Point(bounds.x + bounds.width, bounds.y)));
    }

    @Override
    public boolean showElementActions() {
        if (!this.isVisible()) {
            return false;
        }
        LookupElement element = this.getCurrentItem();
        if (element == null) {
            return false;
        }
        Collection<LookupElementAction> actions2 = this.getActionsFor(element);
        if (actions2.isEmpty()) {
            return false;
        }
        this.showItemPopup((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LookupActionsStep(actions2, this, element)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LookupElement, StringBuilder> getRelevanceStrings() {
        JBList jBList = this.myList;
        synchronized (jBList) {
            return this.myPresentableArranger.getRelevanceStrings();
        }
    }

    public static enum FocusDegree {
        FOCUSED,
        SEMI_FOCUSED,
        UNFOCUSED;

    }
}

