/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.java18StreamApi.GuavaFluentIterableMethodConverters;
import com.intellij.codeInspection.java18StreamApi.GuavaOptionalConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFluentIterableInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(GuavaFluentIterableInspection.class);
    private static final String PROBLEM_DESCRIPTION = "FluentIterable is used while Stream API is accessible";
    public static final String GUAVA_FLUENT_ITERABLE = "com.google.common.collect.FluentIterable";
    public static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    public static final String GUAVA_IMMUTABLE_MAP = "com.google.common.collect.ImmutableMap";
    public static final String FLUENT_ITERABLE_FROM = "from";

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection", "checkFile"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)file)) {
            return null;
        }
        Project project = manager.getProject();
        PsiClass fluentIterable = JavaPsiFacade.getInstance((Project)project).findClass(GUAVA_FLUENT_ITERABLE, GlobalSearchScope.allScope((Project)project));
        if (fluentIterable == null) {
            return null;
        }
        final SmartPointerManager mySmartPointerManager = SmartPointerManager.getInstance((Project)project);
        THashSet myMethodCallsToIgnore = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        MultiMap localVariablesUsages = new MultiMap();
        THashSet unconvertibleVariables = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor((Set)unconvertibleVariables, fluentIterable, localVariablesUsages, (Set)myMethodCallsToIgnore, mySmartPointerManager, descriptors, manager, isOnTheFly){
            final /* synthetic */ Set val$unconvertibleVariables;
            final /* synthetic */ PsiClass val$fluentIterable;
            final /* synthetic */ MultiMap val$localVariablesUsages;
            final /* synthetic */ Set val$myMethodCallsToIgnore;
            final /* synthetic */ SmartPointerManager val$mySmartPointerManager;
            final /* synthetic */ List val$descriptors;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$unconvertibleVariables = set;
                this.val$fluentIterable = psiClass;
                this.val$localVariablesUsages = multiMap;
                this.val$myMethodCallsToIgnore = set2;
                this.val$mySmartPointerManager = smartPointerManager;
                this.val$descriptors = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public void visitLocalVariable(PsiLocalVariable localVariable) {
                super.visitLocalVariable(localVariable);
                PsiType type = localVariable.getType();
                if (!(type instanceof PsiClassType) || this.val$unconvertibleVariables.contains(localVariable)) {
                    return;
                }
                PsiClass variableClass = ((PsiClassType)type).resolve();
                if (variableClass == null) {
                    return;
                }
                String qualifiedName = variableClass.getQualifiedName();
                if (!GuavaFluentIterableInspection.GUAVA_FLUENT_ITERABLE.equals(qualifiedName)) {
                    return;
                }
                PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiCodeBlock.class);
                if (context == null || !this.checkDeclaration(localVariable.getInitializer())) {
                    this.val$unconvertibleVariables.add(localVariable);
                }
            }

            private boolean checkDeclaration(PsiExpression declaration) {
                PsiClass aClass;
                PsiMethod method;
                PsiExpression qualifier;
                if (declaration == null) {
                    return true;
                }
                if (!(declaration instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression currentCallExpression = (PsiMethodCallExpression)declaration;
                while ((qualifier = currentCallExpression.getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
                    method = currentCallExpression.resolveMethod();
                    if (method == null || GuavaFluentIterableMethodConverters.isStopMethod(method.getName())) {
                        return false;
                    }
                    aClass = method.getContainingClass();
                    if (aClass == null || !aClass.isEquivalentTo((PsiElement)this.val$fluentIterable)) {
                        return false;
                    }
                    currentCallExpression = (PsiMethodCallExpression)qualifier;
                }
                if (qualifier instanceof PsiReferenceExpression) {
                    method = currentCallExpression.resolveMethod();
                    if (method == null || !GuavaFluentIterableInspection.FLUENT_ITERABLE_FROM.equals(method.getName())) {
                        return false;
                    }
                    aClass = method.getContainingClass();
                    return aClass != null && GuavaFluentIterableInspection.GUAVA_FLUENT_ITERABLE.equals(aClass.getQualifiedName());
                }
                return false;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement resolvedElement = expression.resolve();
                if (resolvedElement instanceof PsiLocalVariable) {
                    PsiLocalVariable fluentIterableVariable = (PsiLocalVariable)resolvedElement;
                    if (!this.val$fluentIterable.isEquivalentTo((PsiElement)PsiTypesUtil.getPsiClass((PsiType)fluentIterableVariable.getType())) || this.val$unconvertibleVariables.contains(fluentIterableVariable)) {
                        return;
                    }
                    this.analyzeExpression((PsiExpression)expression, fluentIterableVariable);
                }
            }

            private void addToUnconvertible(PsiLocalVariable variable) {
                this.val$unconvertibleVariables.add(variable);
                this.val$localVariablesUsages.remove((Object)variable);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiElement resolvedElement;
                super.visitMethodCallExpression(expression);
                if (!this.val$myMethodCallsToIgnore.add(expression)) {
                    return;
                }
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (GuavaFluentIterableInspection.FLUENT_ITERABLE_FROM.equals(methodName)) {
                    PsiType type;
                    PsiClass resolvedClass;
                    PsiType containingMethodReturnType;
                    PsiMethod method = expression.resolveMethod();
                    if (method == null || !method.hasModifierProperty("static") || !this.val$fluentIterable.isEquivalentTo((PsiElement)method.getContainingClass())) {
                        return;
                    }
                    PsiMethodCallExpression currentExpression = expression;
                    while (true) {
                        PsiMethod parentCallMethod;
                        this.val$myMethodCallsToIgnore.add(currentExpression);
                        PsiMethodCallExpression parentMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)currentExpression, PsiMethodCallExpression.class);
                        if (parentMethodCall == null || parentMethodCall.getMethodExpression().getQualifierExpression() != currentExpression || (parentCallMethod = parentMethodCall.resolveMethod()) == null || !this.val$fluentIterable.isEquivalentTo((PsiElement)parentCallMethod.getContainingClass())) break;
                        if (GuavaFluentIterableMethodConverters.isStopMethod(parentCallMethod.getName())) {
                            return;
                        }
                        currentExpression = parentMethodCall;
                    }
                    PsiElement expressionParent = currentExpression.getParent();
                    if (expressionParent instanceof PsiReturnStatement ? (containingMethodReturnType = GuavaFluentIterableInspection.findContainingMethodReturnType((PsiReturnStatement)expressionParent)) instanceof PsiClassType && ((resolvedClass = ((PsiClassType)containingMethodReturnType).resolve()) == null || !(resolvedClass.getResolveScope() instanceof JdkScope)) : (expressionParent instanceof PsiLocalVariable ? (type = ((PsiLocalVariable)expressionParent).getType()) instanceof PsiClassType && ((resolvedClass = ((PsiClassType)type).resolve()) == null || !(resolvedClass.getResolveScope() instanceof JdkScope)) : expressionParent instanceof PsiExpressionList && expressionParent.getParent() instanceof PsiMethodCallExpression && !GuavaFluentIterableInspection.isMethodWithParamAcceptsConversion((PsiMethodCallExpression)expressionParent.getParent(), (PsiExpression)currentExpression, this.val$fluentIterable))) {
                        return;
                    }
                    List exprAsList = ContainerUtil.list((Object[])new SmartPsiElementPointer[]{this.val$mySmartPointerManager.createSmartPsiElementPointer((PsiElement)currentExpression)});
                    this.val$descriptors.add(this.val$manager.createProblemDescriptor((PsiElement)currentExpression, GuavaFluentIterableInspection.PROBLEM_DESCRIPTION, (LocalQuickFix)new ConvertGuavaFluentIterableQuickFix(null, exprAsList), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.val$isOnTheFly));
                    return;
                }
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (GuavaFluentIterableMethodConverters.isFluentIterableMethod(methodName) && qualifierExpression instanceof PsiReferenceExpression && (resolvedElement = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiLocalVariable) {
                    PsiLocalVariable fluentIterableLocalVariable = (PsiLocalVariable)resolvedElement;
                    if (!this.val$fluentIterable.isEquivalentTo((PsiElement)PsiTypesUtil.getPsiClass((PsiType)fluentIterableLocalVariable.getType())) || this.val$unconvertibleVariables.contains(fluentIterableLocalVariable)) {
                        return;
                    }
                    this.analyzeExpression((PsiExpression)expression, fluentIterableLocalVariable);
                }
            }

            private void analyzeExpression(PsiExpression expression, PsiLocalVariable fluentIterableLocalVariable) {
                PsiElement parent;
                String currentMethodName;
                PsiMethodCallExpression methodCallExpression;
                PsiExpression baseExpression = expression;
                while ((methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)baseExpression, PsiMethodCallExpression.class)) != null && methodCallExpression.getMethodExpression().getQualifierExpression() == baseExpression && GuavaFluentIterableMethodConverters.isFluentIterableMethod(currentMethodName = methodCallExpression.getMethodExpression().getReferenceName())) {
                    if (GuavaFluentIterableMethodConverters.isStopMethod(currentMethodName)) {
                        this.addToUnconvertible(fluentIterableLocalVariable);
                        return;
                    }
                    PsiMethod method = methodCallExpression.resolveMethod();
                    if (method == null || method.getContainingClass() == null || !method.getContainingClass().isEquivalentTo((PsiElement)this.val$fluentIterable)) break;
                    baseExpression = methodCallExpression;
                    this.val$myMethodCallsToIgnore.add(methodCallExpression);
                }
                if ((parent = baseExpression.getParent()) instanceof PsiExpressionList) {
                    boolean suitable;
                    this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                    boolean bl = suitable = parent.getParent() instanceof PsiMethodCallExpression && GuavaFluentIterableInspection.isMethodWithParamAcceptsConversion((PsiMethodCallExpression)parent.getParent(), baseExpression, this.val$fluentIterable);
                    if (!suitable) {
                        this.addToUnconvertible(fluentIterableLocalVariable);
                    }
                } else if (parent instanceof PsiReferenceExpression) {
                    PsiMethodCallExpression parentMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)baseExpression, PsiMethodCallExpression.class);
                    if (parentMethodCall != null && parentMethodCall.getMethodExpression().getQualifier() == baseExpression) {
                        if (GuavaOptionalConverter.isConvertibleIfOption(parentMethodCall)) {
                            this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                        } else {
                            this.addToUnconvertible(fluentIterableLocalVariable);
                        }
                    }
                } else if (parent instanceof PsiLocalVariable) {
                    this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                    PsiExpression lExpression = assignment.getLExpression();
                    if (lExpression instanceof PsiReferenceExpression) {
                        if (((PsiReferenceExpression)lExpression).isReferenceTo((PsiElement)fluentIterableLocalVariable)) {
                            if (GuavaFluentIterableInspection.isSelfAssignment(assignment, fluentIterableLocalVariable)) {
                                this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                                return;
                            }
                            if (this.checkDeclaration(assignment.getRExpression())) {
                                this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)assignment.getRExpression());
                                return;
                            }
                            this.addToUnconvertible(fluentIterableLocalVariable);
                        } else {
                            this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                        }
                    } else {
                        this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                    }
                } else if (parent instanceof PsiReturnStatement) {
                    PsiType containingMethodReturnType = GuavaFluentIterableInspection.findContainingMethodReturnType((PsiReturnStatement)parent);
                    if (!(containingMethodReturnType instanceof PsiClassType)) {
                        this.addToUnconvertible(fluentIterableLocalVariable);
                        return;
                    }
                    PsiClass resolvedClass = ((PsiClassType)containingMethodReturnType).resolve();
                    if (resolvedClass == null || !"java.lang.Iterable".equals(resolvedClass.getQualifiedName()) && !"java.lang.Object".equals(resolvedClass.getQualifiedName())) {
                        this.addToUnconvertible(fluentIterableLocalVariable);
                    } else {
                        this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                    }
                } else if (parent instanceof PsiExpressionStatement) {
                    this.val$localVariablesUsages.putValue((Object)fluentIterableLocalVariable, (Object)baseExpression);
                }
            }
        };
        file.accept((PsiElementVisitor)visitor);
        for (Map.Entry e : localVariablesUsages.entrySet()) {
            PsiLocalVariable localVariable = (PsiLocalVariable)e.getKey();
            Collection foundUsages = (Collection)e.getValue();
            SmartPsiElementPointer variablePointer = mySmartPointerManager.createSmartPsiElementPointer((PsiElement)localVariable);
            ConvertGuavaFluentIterableQuickFix quickFix = new ConvertGuavaFluentIterableQuickFix((SmartPsiElementPointer<PsiLocalVariable>)variablePointer, ContainerUtil.map((Collection)new THashSet(foundUsages), (Function)new Function<PsiExpression, SmartPsiElementPointer<PsiExpression>>(){

                public SmartPsiElementPointer<PsiExpression> fun(PsiExpression expression) {
                    return mySmartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
                }
            }));
            descriptors.add(manager.createProblemDescriptor((PsiElement)localVariable, PROBLEM_DESCRIPTION, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            for (PsiExpression usage : foundUsages) {
                descriptors.add(manager.createProblemDescriptor((PsiElement)usage, PROBLEM_DESCRIPTION, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    public static boolean isMethodWithParamAcceptsConversion(PsiMethodCallExpression methodCallExpression, PsiExpression baseExpression, PsiClass fluentIterable) {
        PsiExpressionList argList = methodCallExpression.getArgumentList();
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return true;
        }
        PsiParameterList paramList = method.getParameterList();
        if (paramList.getParametersCount() != argList.getExpressions().length && !(paramList.getParameters()[paramList.getParametersCount() - 1].getType() instanceof PsiEllipsisType)) {
            return false;
        }
        int index = -1;
        PsiExpression[] expressions = argList.getExpressions();
        int length = expressions.length;
        for (int i = 0; i < length; ++i) {
            if (expressions[i] != baseExpression) continue;
            index = i;
            break;
        }
        LOG.assertTrue(index >= 0);
        PsiType parameterType = index > paramList.getParametersCount() - 1 ? paramList.getParameters()[paramList.getParametersCount() - 1].getType() : paramList.getParameters()[index].getType();
        if (parameterType instanceof PsiEllipsisType) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        if (parameterType instanceof PsiClassType) {
            PsiClass resolvedParameterClass = ((PsiClassType)parameterType).resolve();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)methodCallExpression.getProject());
            PsiClass optional = javaPsiFacade.findClass(GUAVA_OPTIONAL, scope);
            PsiClass immutableMap = javaPsiFacade.findClass(GUAVA_IMMUTABLE_MAP, scope);
            if (resolvedParameterClass != null && (InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedParameterClass, (PsiClass)fluentIterable, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedParameterClass, (PsiClass)optional, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedParameterClass, (PsiClass)immutableMap, (boolean)true))) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static PsiType findContainingMethodReturnType(PsiReturnStatement returnStatement) {
        PsiType containingMethodReturnType;
        NavigatablePsiElement contextElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (contextElement == null) {
            return null;
        }
        PsiType psiType = containingMethodReturnType = contextElement instanceof PsiMethod ? ((PsiMethod)contextElement).getReturnType() : LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)contextElement));
        if (containingMethodReturnType == null) {
            return null;
        }
        return containingMethodReturnType;
    }

    private static boolean isSelfAssignment(PsiAssignmentExpression expression, PsiLocalVariable localVariable) {
        PsiExpression qualifier;
        PsiExpression rExpression = expression.getRExpression();
        if (!(rExpression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)rExpression;
        while ((qualifier = methodCall.getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression) {
            methodCall = (PsiMethodCallExpression)qualifier;
        }
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        return !(qualifierExpression instanceof PsiReferenceExpression) || ((PsiReferenceExpression)qualifierExpression).isReferenceTo((PsiElement)localVariable);
    }

    public static class ConvertGuavaFluentIterableQuickFix
    implements LocalQuickFix {
        @Nullable
        private final SmartPsiElementPointer<PsiLocalVariable> myVariable;
        @NotNull
        private final List<SmartPsiElementPointer<PsiExpression>> myFoundUsages;

        protected ConvertGuavaFluentIterableQuickFix(@Nullable SmartPsiElementPointer<PsiLocalVariable> variable, @NotNull List<SmartPsiElementPointer<PsiExpression>> foundUsages) {
            if (foundUsages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection$ConvertGuavaFluentIterableQuickFix", "<init>"));
            }
            this.myVariable = variable;
            this.myFoundUsages = foundUsages;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection$ConvertGuavaFluentIterableQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Convert Guava's FluentIterable to java.util.stream.Stream" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection$ConvertGuavaFluentIterableQuickFix", "getFamilyName"));
            }
            return "Convert Guava's FluentIterable to java.util.stream.Stream";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLocalVariable element;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection$ConvertGuavaFluentIterableQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18StreamApi/GuavaFluentIterableInspection$ConvertGuavaFluentIterableQuickFix", "applyFix"));
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = javaPsiFacade.getElementFactory();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            for (SmartPsiElementPointer<PsiExpression> usage : this.myFoundUsages) {
                PsiExpression element2 = (PsiExpression)usage.getElement();
                if (element2 == null) continue;
                GuavaFluentIterableMethodConverters.convert(element2, elementFactory, codeStyleManager);
            }
            if (this.myVariable != null && (element = (PsiLocalVariable)this.myVariable.getElement()) != null) {
                GuavaFluentIterableMethodConverters.convert(element, elementFactory, codeStyleManager);
            }
        }
    }
}

