/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFunctionAndPredicateConverter {
    private static final Logger LOG = Logger.getInstance(GuavaFunctionAndPredicateConverter.class);

    @Nullable
    public static Boolean isClassConditionPredicate(PsiExpression expression) {
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            if (InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"com.google.common.base.Function") || InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"com.google.common.base.Predicate")) {
                return Boolean.FALSE;
            }
            if (InheritanceUtil.isInheritor((PsiClass)resolvedClass, (String)"java.lang.Class")) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @NotNull
    public static String convertFunctionOrPredicateParameter(@NotNull PsiExpression expression, boolean role) {
        PsiAnonymousClass anonymousClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/java18StreamApi/GuavaFunctionAndPredicateConverter", "convertFunctionOrPredicateParameter"));
        }
        if (role) {
            String pattern = expression instanceof PsiMethodCallExpression || expression instanceof PsiReferenceExpression ? "%s::isInstance" : "(%s)::isInstance";
            String string = String.format(pattern, expression.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaFunctionAndPredicateConverter", "convertFunctionOrPredicateParameter"));
            }
            return string;
        }
        if (expression instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)expression).getAnonymousClass()) != null && AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymousClass, true)) {
            PsiLambdaExpression lambdaExpression = AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, true);
            LOG.assertTrue(lambdaExpression != null);
            String string = lambdaExpression.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaFunctionAndPredicateConverter", "convertFunctionOrPredicateParameter"));
            }
            return string;
        }
        String qualifierText = expression.getText();
        if (!(expression instanceof PsiMethodCallExpression) && !(expression instanceof PsiReferenceExpression)) {
            qualifierText = "(" + qualifierText + ")";
        }
        String string = qualifierText + "::apply";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/GuavaFunctionAndPredicateConverter", "convertFunctionOrPredicateParameter"));
        }
        return string;
    }
}

