/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ConfigurationStorePackage$ComponentStoreImpl$1ecd1316;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ConfigurationStorePackage$XmlElementStorage$5a6a907e {
    @Nullable
    public static final Element save(@JetValueParameter(name="states") @NotNull StateMap states, @JetValueParameter(name="newLiveStates") @NotNull Map<String, ? extends Element> newLiveStates, @JetValueParameter(name="rootElementName") @NotNull String rootElementName) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        Intrinsics.checkParameterIsNotNull(newLiveStates, (String)"newLiveStates");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        if (states.isEmpty()) {
            return null;
        }
        Element rootElement = new Element(rootElementName);
        String[] stringArray = states.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String componentName = stringArray[i];
            Element element = states.getElement(componentName, newLiveStates);
            List elementAttributes = element.getAttributes();
            if (elementAttributes.isEmpty()) {
                element.setAttribute(FileStorageCoreUtil.NAME, componentName);
            } else {
                Attribute nameAttribute = element.getAttribute(FileStorageCoreUtil.NAME);
                if (nameAttribute == null) {
                    nameAttribute = new Attribute(FileStorageCoreUtil.NAME, componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue(componentName);
                    if (Intrinsics.areEqual((Object)((Attribute)elementAttributes.get(0)), (Object)nameAttribute) ^ true) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            rootElement.addContent(element);
        }
        return rootElement;
    }

    @Nullable
    public static final Map<String, Object> setStateAndCloneIfNeed(@JetValueParameter(name="componentName") @NotNull String componentName, @JetValueParameter(name="newState", type="?") @Nullable Element newState, @JetValueParameter(name="oldStates") @NotNull StateMap oldStates, @JetValueParameter(name="newLiveStates") @NotNull Map<String, Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)oldStates, (String)"oldStates");
        Intrinsics.checkParameterIsNotNull(newLiveStates, (String)"newLiveStates");
        Object oldState = oldStates.get(componentName);
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            if (oldState == null) {
                return null;
            }
            Map<String, Object> newStates = oldStates.toMutableMap();
            newStates.remove(componentName);
            return newStates;
        }
        ConfigurationStorePackage$XmlElementStorage$5a6a907e.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        byte[] newBytes = null;
        if (oldState instanceof Element) {
            if (JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState)) {
                return null;
            }
        } else if (oldState != null) {
            Object object = oldState;
            if (object == null) {
                throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.ByteArray");
            }
            newBytes = StateMap.Companion.getNewByteIfDiffers(componentName, newState, (byte[])object);
            if (newBytes == null) {
                return null;
            }
        }
        Map<String, Object> newStates = oldStates.toMutableMap();
        newStates.put(componentName, newBytes != null ? (Cloneable)newBytes : (Cloneable)newState);
        return newStates;
    }

    public static final void prepareElement(@JetValueParameter(name="state") @NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state.getParent() != null) {
            ConfigurationStorePackage$ComponentStoreImpl$1ecd1316.LOG.warn("State element must not have parent " + JDOMUtil.writeElement((Element)state));
            state.detach();
        }
        state.setName(FileStorageCoreUtil.COMPONENT);
    }

    public static final void updateState(@JetValueParameter(name="states") @NotNull Map<String, Object> states, @JetValueParameter(name="componentName") @NotNull String componentName, @JetValueParameter(name="newState", type="?") @Nullable Element newState, @JetValueParameter(name="newLiveStates") @NotNull Map<String, Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull(states, (String)"states");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull(newLiveStates, (String)"newLiveStates");
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            states.remove(componentName);
            return;
        }
        ConfigurationStorePackage$XmlElementStorage$5a6a907e.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        Object oldState = states.get(componentName);
        byte[] newBytes = null;
        if (oldState instanceof Element) {
            if (JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState)) {
                return;
            }
        } else if (oldState != null) {
            Object object = oldState;
            if (object == null) {
                throw new TypeCastException("kotlin.Any? cannot be cast to kotlin.ByteArray");
            }
            byte[] byArray = StateMap.Companion.getNewByteIfDiffers(componentName, newState, (byte[])object);
            if (byArray == null) {
                return;
            }
            newBytes = byArray;
        }
        states.put(componentName, newBytes != null ? (Cloneable)newBytes : (Cloneable)newState);
    }

    @NotNull
    public static final Set<String> getChangedComponentNames(@JetValueParameter(name="$receiver") StateMap $receiver, @JetValueParameter(name="newStates") @NotNull StateMap newStates) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Set bothStates = KotlinPackage.toMutableSet((Object[])$receiver.keys());
        KotlinPackage.retainAll((Collection)bothStates, (Object[])newStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        KotlinPackage.addAll((Collection)((Collection)diffs), (Object[])newStates.keys());
        KotlinPackage.addAll((Collection)((Collection)diffs), (Object[])$receiver.keys());
        diffs.removeAll((Collection)bothStates);
        for (String componentName : bothStates) {
            $receiver.compare(componentName, newStates, (Set)diffs);
        }
        return (Set)diffs;
    }
}

