/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.PsiMethodListPopupStep;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JvmSmartStepIntoHandler {
    public static ExtensionPointName<JvmSmartStepIntoHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.jvmSmartStepIntoHandler");

    @NotNull
    public abstract List<SmartStepTarget> findSmartStepTargets(SourcePosition var1);

    public abstract boolean isAvailable(SourcePosition var1);

    public boolean doSmartStep(SourcePosition position, final DebuggerSession session, TextEditor fileEditor) {
        List<SmartStepTarget> targets = this.findSmartStepTargets(position);
        if (!targets.isEmpty()) {
            SmartStepTarget firstTarget = targets.get(0);
            if (targets.size() == 1) {
                session.stepInto(true, this.createMethodFilter(firstTarget));
            } else {
                Editor editor = fileEditor.getEditor();
                final PsiMethodListPopupStep popupStep = new PsiMethodListPopupStep(editor, targets, new PsiMethodListPopupStep.OnChooseRunnable(){

                    @Override
                    public void execute(SmartStepTarget chosenTarget) {
                        session.stepInto(true, JvmSmartStepIntoHandler.this.createMethodFilter(chosenTarget));
                    }
                });
                ListPopupImpl popup = new ListPopupImpl(popupStep);
                DebuggerUIUtil.registerExtraHandleShortcuts(popup, "StepInto");
                DebuggerUIUtil.registerExtraHandleShortcuts(popup, "SmartStepInto");
                popup.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        SmartStepTarget selectedTarget;
                        popupStep.getScopeHighlighter().dropHighlight();
                        if (!e.getValueIsAdjusting() && (selectedTarget = (SmartStepTarget)((JBList)e.getSource()).getSelectedValue()) != null) {
                            JvmSmartStepIntoHandler.highlightTarget(popupStep, selectedTarget);
                        }
                    }
                });
                JvmSmartStepIntoHandler.highlightTarget(popupStep, firstTarget);
                RelativePoint point = DebuggerUIUtil.calcPopupLocation(editor, position.getLine());
                popup.show(point);
            }
            return true;
        }
        return false;
    }

    private static void highlightTarget(PsiMethodListPopupStep popupStep, SmartStepTarget target) {
        PsiElement highlightElement = target.getHighlightElement();
        if (highlightElement != null) {
            popupStep.getScopeHighlighter().highlight(highlightElement, Collections.singletonList(highlightElement));
        }
    }

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        if (stepTarget instanceof MethodSmartStepTarget) {
            PsiMethod method = ((MethodSmartStepTarget)stepTarget).getMethod();
            return stepTarget.needsBreakpointRequest() ? new AnonymousClassMethodFilter(method, stepTarget.getCallingExpressionLines()) : new BasicStepMethodFilter(method, stepTarget.getCallingExpressionLines());
        }
        if (stepTarget instanceof LambdaSmartStepTarget) {
            LambdaSmartStepTarget lambdaTarget = (LambdaSmartStepTarget)stepTarget;
            return new LambdaMethodFilter(lambdaTarget.getLambda(), lambdaTarget.getOrdinal(), stepTarget.getCallingExpressionLines());
        }
        return null;
    }
}

