/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.actions.JumpToObjectAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class JavaValue
extends XNamedValue
implements NodeDescriptorProvider,
XValueTextProvider {
    private static final Logger LOG = Logger.getInstance(JavaValue.class);
    private final JavaValue myParent;
    private final ValueDescriptorImpl myValueDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;
    private final boolean myContextSet;
    private int myCurrentChildrenStart;
    private volatile XExpression evaluationExpression;

    protected JavaValue(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/debugger/engine/JavaValue", "<init>"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/JavaValue", "<init>"));
        }
        super(valueDescriptor.calcValueName());
        this.myCurrentChildrenStart = 0;
        this.evaluationExpression = null;
        this.myParent = parent;
        this.myValueDescriptor = valueDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
        this.myContextSet = contextSet;
    }

    static JavaValue create(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/debugger/engine/JavaValue", "create"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/JavaValue", "create"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new JavaValue(parent, valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    static JavaValue create(@NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/debugger/engine/JavaValue", "create"));
        }
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/debugger/engine/JavaValue", "create"));
        }
        return JavaValue.create(null, valueDescriptor, evaluationContext, nodeManager, false);
    }

    public JavaValue getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl getDescriptor() {
        ValueDescriptorImpl valueDescriptorImpl = this.myValueDescriptor;
        if (valueDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue", "getDescriptor"));
        }
        return valueDescriptorImpl;
    }

    public EvaluationContextImpl getEvaluationContext() {
        return this.myEvaluationContext;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/debugger/engine/JavaValue", "computePresentation"));
        }
        SuspendContextImpl suspendContext = this.myEvaluationContext.getSuspendContext();
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                node.setPresentation(null, (XValuePresentation)new JavaValuePresentation("", null, DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]), JavaValue.this.myValueDescriptor), false);
            }

            @Override
            public void contextAction() throws Exception {
                if (!JavaValue.this.myContextSet) {
                    JavaValue.this.myValueDescriptor.setContext(JavaValue.this.myEvaluationContext);
                }
                JavaValue.this.myValueDescriptor.updateRepresentation(JavaValue.this.myEvaluationContext, new DescriptorLabelListener(){

                    @Override
                    public void labelChanged() {
                        Icon nodeIcon = DebuggerTreeRenderer.getValueIcon(JavaValue.this.myValueDescriptor);
                        String value = JavaValue.this.getValueString();
                        EvaluateException exception = JavaValue.this.myValueDescriptor.getEvaluateException();
                        JavaValuePresentation presentation = new JavaValuePresentation(value, JavaValue.this.myValueDescriptor.getIdLabel(), exception != null ? exception.getMessage() : null, JavaValue.this.myValueDescriptor);
                        if (JavaValue.this.myValueDescriptor.getLastRenderer() instanceof FullValueEvaluatorProvider) {
                            XFullValueEvaluator evaluator = ((FullValueEvaluatorProvider)((Object)JavaValue.this.myValueDescriptor.getLastRenderer())).getFullValueEvaluator(JavaValue.this.myEvaluationContext, JavaValue.this.myValueDescriptor);
                            if (evaluator != null) {
                                node.setFullValueEvaluator(evaluator);
                            }
                        } else if (value.length() > 1000) {
                            node.setFullValueEvaluator((XFullValueEvaluator)new JavaFullValueEvaluator(JavaValue.this.myEvaluationContext){

                                @Override
                                public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) throws Exception {
                                    if (callback == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$1$1$1", "evaluate"));
                                    }
                                    final ValueDescriptorImpl fullValueDescriptor = JavaValue.this.myValueDescriptor.getFullValueDescriptor();
                                    fullValueDescriptor.updateRepresentation(this.myEvaluationContext, new DescriptorLabelListener(){

                                        @Override
                                        public void labelChanged() {
                                            callback.evaluated(fullValueDescriptor.getValueText());
                                        }
                                    });
                                }
                            });
                        }
                        node.setPresentation(nodeIcon, (XValuePresentation)presentation, JavaValue.this.myValueDescriptor.isExpandable());
                    }
                });
            }
        });
    }

    private static String truncateToMaxLength(String value) {
        return value.substring(0, Math.min(value.length(), 1000));
    }

    @NotNull
    String getValueString() {
        String string = this.myValueDescriptor.getValueText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue", "getValueString"));
        }
        return string;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaValue", "computeChildren"));
        }
        JavaValue.scheduleCommand(this.myEvaluationContext, node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction() throws Exception {
                final XValueChildrenList children = new XValueChildrenList();
                NodeRenderer renderer = JavaValue.this.myValueDescriptor.getRenderer(JavaValue.this.myEvaluationContext.getDebugProcess());
                final Ref remainingNum = new Ref((Object)0);
                renderer.buildChildren(JavaValue.this.myValueDescriptor.getValue(), new ChildrenBuilder(){

                    @Override
                    public NodeDescriptorFactory getDescriptorManager() {
                        return JavaValue.this.myNodeManager;
                    }

                    @Override
                    public NodeManager getNodeManager() {
                        return JavaValue.this.myNodeManager;
                    }

                    @Override
                    public ValueDescriptor getParentDescriptor() {
                        return JavaValue.this.myValueDescriptor;
                    }

                    @Override
                    public void setRemaining(int remaining) {
                        remainingNum.set((Object)remaining);
                    }

                    @Override
                    public void initChildrenArrayRenderer(ArrayRenderer renderer) {
                        renderer.START_INDEX = JavaValue.this.myCurrentChildrenStart;
                        renderer.END_INDEX = JavaValue.this.myCurrentChildrenStart + 100 - 1;
                        JavaValue.this.myCurrentChildrenStart = JavaValue.this.myCurrentChildrenStart + 100;
                    }

                    @Override
                    public void setChildren(List<DebuggerTreeNode> nodes) {
                        for (DebuggerTreeNode node : nodes) {
                            NodeDescriptor descriptor = node.getDescriptor();
                            if (descriptor instanceof ValueDescriptorImpl) {
                                children.add((XNamedValue)JavaValue.create(JavaValue.this, (ValueDescriptorImpl)descriptor, JavaValue.this.myEvaluationContext, JavaValue.this.myNodeManager, false));
                                continue;
                            }
                            if (!(descriptor instanceof MessageDescriptor)) continue;
                            children.add((XNamedValue)new JavaStackFrame.DummyMessageValueNode(descriptor.getLabel(), null));
                        }
                    }
                }, JavaValue.this.myEvaluationContext);
                node.addChildren(children, true);
                if ((Integer)remainingNum.get() > 0) {
                    node.tooManyChildren(((Integer)remainingNum.get()).intValue());
                }
            }
        });
    }

    protected static boolean scheduleCommand(EvaluationContextImpl evaluationContext, final @NotNull XCompositeNode node, final SuspendContextCommandImpl command) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaValue", "scheduleCommand"));
        }
        evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(command.getSuspendContext()){

            @Override
            public void contextAction() throws Exception {
                command.contextAction();
            }

            @Override
            protected void commandCancelled() {
                node.setErrorMessage(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            }
        });
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/debugger/engine/JavaValue", "computeSourcePosition"));
        }
        this.computeSourcePosition(navigatable, false);
    }

    private void computeSourcePosition(final @NotNull XNavigatable navigatable, final boolean inline2) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/debugger/engine/JavaValue", "computeSourcePosition"));
        }
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return inline2 ? PrioritizedTask.Priority.LOWEST : PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                navigatable.setSourcePosition(null);
            }

            @Override
            public void contextAction() throws Exception {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        SourcePosition position = SourcePositionProvider.getSourcePosition(JavaValue.this.myValueDescriptor, JavaValue.this.getProject(), JavaValue.this.getDebuggerContext(), false);
                        if (position != null) {
                            navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(position));
                        }
                        if (inline2 && (position = SourcePositionProvider.getSourcePosition(JavaValue.this.myValueDescriptor, JavaValue.this.getProject(), JavaValue.this.getDebuggerContext(), true)) != null) {
                            navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(position));
                        }
                    }
                });
            }
        });
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(final @NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue", "computeInlineDebuggerData"));
        }
        this.computeSourcePosition(new XNavigatable(){

            public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
                callback.computed(sourcePosition);
            }
        }, true);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue", "computeInlineDebuggerData"));
        }
        return threeState;
    }

    private DebuggerContextImpl getDebuggerContext() {
        return this.myEvaluationContext.getDebugProcess().getDebuggerContext();
    }

    public Project getProject() {
        return this.myValueDescriptor.getProject();
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/debugger/engine/JavaValue", "computeTypeSourcePosition"));
        }
        if (this.myEvaluationContext.getSuspendContext().isResumed()) {
            return;
        }
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        debugProcess.getManagerThread().schedule(new JumpToObjectAction.NavigateCommand(this.getDebuggerContext(), this.myValueDescriptor, debugProcess, null){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void doAction(final @Nullable SourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition));
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public XValueModifier getModifier() {
        return this.myValueDescriptor.canSetValue() ? new JavaValueModifier(this) : null;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        if (this.evaluationExpression != null) {
            Promise promise = Promise.resolve((Object)this.evaluationExpression);
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue", "calculateEvaluationExpression"));
            }
            return promise;
        }
        final AsyncPromise res = new AsyncPromise();
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction() throws Exception {
                JavaValue.this.evaluationExpression = (XExpression)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XExpression>(){

                    public XExpression compute() {
                        try {
                            PsiElement psiExpression = JavaValue.this.getDescriptor().getTreeEvaluation(JavaValue.this, JavaValue.this.getDebuggerContext());
                            if (psiExpression != null) {
                                XExpression res = TextWithImportsImpl.toXExpression(new TextWithImportsImpl(psiExpression));
                                Set imports = (Set)psiExpression.getUserData(DebuggerTreeNodeExpression.ADDITIONAL_IMPORTS_KEY);
                                if (imports != null && res != null) {
                                    if (res.getCustomInfo() != null) {
                                        imports.add(res.getCustomInfo());
                                    }
                                    res = new XExpressionImpl(res.getExpression(), res.getLanguage(), StringUtil.join((Collection)imports, (String)","), res.getMode());
                                }
                                return res;
                            }
                        }
                        catch (EvaluateException e) {
                            LOG.info((Throwable)e);
                        }
                        return null;
                    }
                });
                res.setResult((Object)JavaValue.this.evaluationExpression);
            }
        });
        AsyncPromise asyncPromise2 = res;
        if (asyncPromise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue", "calculateEvaluationExpression"));
        }
        return asyncPromise2;
    }

    @Override
    public String getValueText() {
        return this.myValueDescriptor.getValueText();
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                return new JavaReferringObjectsValue(JavaValue.this, false);
            }
        };
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){

            public void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @NotNull XStackFrame frame) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$9", "evaluate"));
                }
                if (frame == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/debugger/engine/JavaValue$9", "evaluate"));
                }
                JavaValue.this.myEvaluationContext.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void commandCancelled() {
                        callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                    }

                    @Override
                    protected void action() throws Exception {
                        EvaluationContextImpl evaluationContext;
                        NodeDescriptor item;
                        Modifier modifier;
                        ValueDescriptorImpl inspectDescriptor = JavaValue.this.myValueDescriptor;
                        if (JavaValue.this.myValueDescriptor instanceof WatchItemDescriptor && (modifier = ((WatchItemDescriptor)JavaValue.this.myValueDescriptor).getModifier()) != null && (item = modifier.getInspectItem(JavaValue.this.getProject())) != null) {
                            inspectDescriptor = (ValueDescriptorImpl)item;
                        }
                        if ((evaluationContext = ((JavaStackFrame)frame).getFrameDebuggerContext().createEvaluationContext()) != null) {
                            callback.evaluated((XValue)JavaValue.create(inspectDescriptor, evaluationContext, JavaValue.this.myNodeManager));
                        } else {
                            callback.errorOccurred("Context is not available");
                        }
                    }
                });
            }
        };
    }

    public void setRenderer(NodeRenderer nodeRenderer, XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myValueDescriptor.setRenderer(nodeRenderer);
        this.reBuild(node);
    }

    public void reBuild(final XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myCurrentChildrenStart = 0;
        node.getTree().getLaterInvocator().offer((Object)new Runnable(){

            @Override
            public void run() {
                node.clearChildren();
                JavaValue.this.computePresentation(node, XValuePlace.TREE);
            }
        });
    }

    private static class JavaValuePresentation
    extends XValueExtendedPresentation
    implements XValueCompactPresentation {
        private final String myValue;
        private final String myType;
        private final String myError;
        private final ValueDescriptorImpl myValueDescriptor;

        public JavaValuePresentation(@NotNull String value, @Nullable String type, @Nullable String error, ValueDescriptorImpl valueDescriptor) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/engine/JavaValue$JavaValuePresentation", "<init>"));
            }
            this.myValue = value;
            this.myType = type;
            this.myError = error;
            this.myValueDescriptor = valueDescriptor;
        }

        @Nullable
        public String getType() {
            return StringUtil.nullize((String)this.myType);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/engine/JavaValue$JavaValuePresentation", "renderValue"));
            }
            this.renderValue(renderer, null);
        }

        @Override
        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
            boolean compact;
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/engine/JavaValue$JavaValuePresentation", "renderValue"));
            }
            boolean bl = compact = node != null;
            if (this.myError != null) {
                if (this.myValue.endsWith(this.myError)) {
                    renderer.renderValue(this.myValue.substring(0, this.myValue.length() - this.myError.length()));
                }
                renderer.renderError(this.myError);
            } else {
                JavaValue container;
                if (compact && node.getValueContainer() instanceof JavaValue && (container = (JavaValue)node.getValueContainer()).getDescriptor().isArray()) {
                    String typeName;
                    ArrayReference value = (ArrayReference)container.getDescriptor().getValue();
                    ArrayType type = (ArrayType)container.getDescriptor().getType();
                    if (type != null && (TypeConversionUtil.isPrimitive((String)(typeName = type.componentTypeName())) || "java.lang.String".equals(typeName))) {
                        int size = value.length();
                        int max = Math.min(size, "java.lang.String".equals(typeName) ? 5 : 10);
                        List<Value> values = value.getValues(0, max);
                        ArrayList<String> vals = new ArrayList<String>(max);
                        for (int i = 0; i < values.size(); ++i) {
                            vals.add(StringUtil.first((String)values.get(i).toString(), (int)15, (boolean)true));
                        }
                        String more = "";
                        if (vals.size() < size) {
                            more = ", + " + (size - vals.size()) + " more";
                        }
                        renderer.renderValue("{" + StringUtil.join(vals, (String)", ") + more + "}");
                        return;
                    }
                }
                String value = this.myValue;
                if (this.myValueDescriptor.isString()) {
                    renderer.renderStringValue(this.myValue, "\"\\", 1000);
                    return;
                }
                if (this.myValueDescriptor.getLastRenderer() instanceof ToStringRenderer || this.myValueDescriptor.getLastRenderer() instanceof ToStringBasedRenderer) {
                    value = StringUtil.wrapWithDoubleQuote((String)JavaValue.truncateToMaxLength(this.myValue));
                } else if (this.myValueDescriptor.getLastRenderer() instanceof CompoundReferenceRenderer) {
                    value = JavaValue.truncateToMaxLength(this.myValue);
                }
                renderer.renderValue(value);
            }
        }

        @NotNull
        public String getSeparator() {
            String declaredType = this.myValueDescriptor.getDeclaredTypeLabel();
            if (!StringUtil.isEmpty((String)declaredType)) {
                String string = declaredType + " " + " = ";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue$JavaValuePresentation", "getSeparator"));
                }
                return string;
            }
            if (" = " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaValue$JavaValuePresentation", "getSeparator"));
            }
            return " = ";
        }

        @Override
        public boolean isModified() {
            return this.myValueDescriptor.isDirty();
        }
    }

    public static abstract class JavaFullValueEvaluator
    extends XFullValueEvaluator {
        protected final EvaluationContextImpl myEvaluationContext;

        public JavaFullValueEvaluator(@NotNull String linkText, EvaluationContextImpl evaluationContext) {
            if (linkText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator", "<init>"));
            }
            super(linkText);
            this.myEvaluationContext = evaluationContext;
        }

        public JavaFullValueEvaluator(EvaluationContextImpl evaluationContext) {
            this.myEvaluationContext = evaluationContext;
        }

        public abstract void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback var1) throws Exception;

        protected EvaluationContextImpl getEvaluationContext() {
            return this.myEvaluationContext;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/engine/JavaValue$JavaFullValueEvaluator", "startEvaluation"));
            }
            if (callback.isObsolete()) {
                return;
            }
            this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                protected void commandCancelled() {
                    callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                }

                @Override
                public void contextAction() throws Exception {
                    if (callback.isObsolete()) {
                        return;
                    }
                    JavaFullValueEvaluator.this.evaluate(callback);
                }
            });
        }
    }
}

