/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public class DisableGC
implements Evaluator {
    private final Evaluator myDelegate;

    public DisableGC(@NotNull Evaluator delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/debugger/engine/evaluation/expression/DisableGC", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object result = this.myDelegate.evaluate(context);
        if (result instanceof ObjectReference) {
            context.getSuspendContext().keep((ObjectReference)result);
        }
        return result;
    }

    public Evaluator getDelegate() {
        return this.myDelegate;
    }

    @Override
    public Modifier getModifier() {
        return this.myDelegate.getModifier();
    }

    public String toString() {
        return "NoGC -> " + this.myDelegate;
    }
}

