/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.DiffTool;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestPanelImpl;
import com.intellij.diff.impl.DiffWindow;
import com.intellij.diff.merge.BinaryMergeTool;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeWindow;
import com.intellij.diff.merge.TextMergeTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryDiffTool;
import com.intellij.diff.tools.dir.DirDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.external.ExternalMergeTool;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffManagerImpl
extends DiffManagerEx {
    public void showDiff(@Nullable Project project, @NotNull DiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showDiff"));
        }
        this.showDiff(project, request, DiffDialogHints.DEFAULT);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showDiff"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/DiffManagerImpl", "showDiff"));
        }
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiff(project, (DiffRequestChain)requestChain, hints);
    }

    public void showDiff(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/diff/DiffManagerImpl", "showDiff"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/DiffManagerImpl", "showDiff"));
        }
        if (ExternalDiffTool.isDefault()) {
            ExternalDiffTool.show(project, requests, hints);
            return;
        }
        this.showDiffBuiltin(project, requests, hints);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showDiffBuiltin"));
        }
        this.showDiffBuiltin(project, request, DiffDialogHints.DEFAULT);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showDiffBuiltin"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/DiffManagerImpl", "showDiffBuiltin"));
        }
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiffBuiltin(project, (DiffRequestChain)requestChain, hints);
    }

    public void showDiffBuiltin(@Nullable Project project, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/diff/DiffManagerImpl", "showDiffBuiltin"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/DiffManagerImpl", "showDiffBuiltin"));
        }
        new DiffWindow(project, requests, hints).show();
    }

    @NotNull
    public DiffRequestPanel createRequestPanel(@Nullable Project project, @NotNull Disposable parent, @Nullable Window window) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/diff/DiffManagerImpl", "createRequestPanel"));
        }
        DiffRequestPanelImpl panel = new DiffRequestPanelImpl(project, window);
        Disposer.register((Disposable)parent, (Disposable)panel);
        DiffRequestPanelImpl diffRequestPanelImpl = panel;
        if (diffRequestPanelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffManagerImpl", "createRequestPanel"));
        }
        return diffRequestPanelImpl;
    }

    @NotNull
    public List<DiffTool> getDiffTools() {
        ArrayList<DiffTool> result = new ArrayList<DiffTool>();
        Collections.addAll(result, DiffTool.EP_NAME.getExtensions());
        result.add((DiffTool)SimpleDiffTool.INSTANCE);
        result.add((DiffTool)UnifiedDiffTool.INSTANCE);
        result.add((DiffTool)BinaryDiffTool.INSTANCE);
        result.add((DiffTool)DirDiffTool.INSTANCE);
        ArrayList<DiffTool> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffManagerImpl", "getDiffTools"));
        }
        return arrayList;
    }

    @NotNull
    public List<MergeTool> getMergeTools() {
        ArrayList<MergeTool> result = new ArrayList<MergeTool>();
        Collections.addAll(result, MergeTool.EP_NAME.getExtensions());
        result.add(TextMergeTool.INSTANCE);
        result.add(BinaryMergeTool.INSTANCE);
        ArrayList<MergeTool> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/DiffManagerImpl", "getMergeTools"));
        }
        return arrayList;
    }

    public void showMerge(@Nullable Project project, @NotNull MergeRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showMerge"));
        }
        if (ExternalMergeTool.isDefault()) {
            ExternalMergeTool.show(project, request);
            return;
        }
        this.showMergeBuiltin(project, request);
    }

    public void showMergeBuiltin(@Nullable Project project, @NotNull MergeRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/DiffManagerImpl", "showMergeBuiltin"));
        }
        new MergeWindow(project, request).show();
    }
}

