/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.ApplicationStarterBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeApplication
extends ApplicationStarterBase {
    @Override
    protected boolean checkArguments(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/MergeApplication", "checkArguments"));
        }
        return (args.length == 4 || args.length == 5) && "merge".equals(args[0]);
    }

    public String getCommandName() {
        return "merge";
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"merge.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/MergeApplication", "getUsageMessage"));
        }
        return string;
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/MergeApplication", "processCommand"));
        }
        String path1 = args[1];
        String path2 = args[2];
        String path3 = args[3];
        String path4 = args.length == 5 ? args[4] : args[3];
        VirtualFile file1 = MergeApplication.findFile(path1, currentDirectory);
        VirtualFile file2 = MergeApplication.findFile(path2, currentDirectory);
        VirtualFile file3 = MergeApplication.findFile(path3, currentDirectory);
        VirtualFile file4 = MergeApplication.findFile(path4, currentDirectory);
        if (file1 == null) {
            throw new Exception("Can't find file " + path1);
        }
        if (file2 == null) {
            throw new Exception("Can't find file " + path2);
        }
        if (file3 == null) {
            throw new Exception("Can't find file " + path3);
        }
        if (file4 == null) {
            throw new Exception("Can't find file " + path4);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file1, file2, file3, file4});
        Project project = this.getProject();
        List contents = ContainerUtil.list((Object[])new VirtualFile[]{file1, file3, file2});
        MergeRequest request = DiffRequestFactory.getInstance().createMergeRequestFromFiles(project, file4, contents, null);
        DiffManagerEx.getInstance().showMergeBuiltin(project, request);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file4);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }
}

