/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorMergeTool
implements MergeTool {
    public static final ErrorMergeTool INSTANCE = new ErrorMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/ErrorMergeTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/ErrorMergeTool", "createComponent"));
        }
        MyViewer myViewer = new MyViewer(context, request);
        if (myViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/ErrorMergeTool", "createComponent"));
        }
        return myViewer;
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/ErrorMergeTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/ErrorMergeTool", "canShow"));
        }
        return true;
    }

    private static class MyViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final MergeRequest myMergeRequest;
        @NotNull
        private final JPanel myPanel;

        public MyViewer(@NotNull MergeContext context, @NotNull MergeRequest request) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "<init>"));
            }
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)this.createComponent(), "Center");
        }

        @NotNull
        private JComponent createComponent() {
            JPanel jPanel = DiffUtil.createMessagePanel("Can't show diff");
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "createComponent"));
            }
            return jPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "getComponent"));
            }
            return jPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents toolbarComponents = new MergeTool.ToolbarComponents();
            if (toolbarComponents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "init"));
            }
            return toolbarComponents;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/merge/ErrorMergeTool$MyViewer", "getResolveAction"));
            }
            if (result == MergeResult.RESOLVED) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle(result, this.myMergeRequest, this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyViewer.this.myMergeContext.finishMerge(result);
                }
            };
        }

        public void dispose() {
        }
    }
}

