/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.KeyboardModifierListener;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(SimpleDiffViewer.class);
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final List<SimpleDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleDiffChange> myInvalidDiffChanges;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final ModifierProvider myModifierProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getEditors(), (Disposable)this);
        this.myModifierProvider = new ModifierProvider();
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        this.destroyChangedBlocks();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyHighlightPolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TwosideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction(Side.LEFT, false));
        group.add(new AppendSelectedChangesAction(Side.LEFT, false));
        group.add(new ReplaceSelectedChangesAction(Side.RIGHT, false));
        group.add(new AppendSelectedChangesAction(Side.RIGHT, false));
        group.add(new RevertSelectedChangesAction(Side.LEFT));
        group.add(new RevertSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createEditorPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getFoldingModelSettings"));
        }
        return settings;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            final Document document1 = this.getContent1().getDocument();
            final Document document2 = this.getContent2().getDocument();
            CharSequence[] texts = (CharSequence[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence[]>(){

                public CharSequence[] compute() {
                    return new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()};
                }
            });
            List<LineFragment> lineFragments = null;
            if (this.getHighlightPolicy().isShouldCompare()) {
                lineFragments = DiffUtil.compare(texts[0], texts[1], this.getDiffConfig(), indicator);
            }
            boolean isEqualContents = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)document1.getCharsSequence(), (CharSequence)document2.getCharsSequence());
            runnable = this.apply(new CompareData(lineFragments, isEqualContents));
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = this.applyNotification(DiffNotifications.DIFF_TOO_BIG);
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable apply(final @NotNull CompareData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimpleDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getFoldingModelSettings());
                SimpleDiffViewer.this.clearDiffPresentation();
                if (data.isEqualContent()) {
                    SimpleDiffViewer.this.myPanel.addNotification(DiffNotifications.EQUAL_CONTENTS);
                }
                if (data.getFragments() != null) {
                    for (LineFragment fragment : data.getFragments()) {
                        SimpleDiffViewer.this.myDiffChanges.add(new SimpleDiffChange(SimpleDiffViewer.this, fragment, SimpleDiffViewer.this.getHighlightPolicy().isFineFragments()));
                    }
                }
                SimpleDiffViewer.this.myFoldingModel.install(data.getFragments(), (UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getFoldingModelSettings());
                SimpleDiffViewer.this.myInitialScrollHelper.onRediff();
                SimpleDiffViewer.this.myContentPanel.repaintDivider();
                SimpleDiffViewer.this.myStatusPanel.update();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        return runnable;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimpleDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    SimpleDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "applyNotification"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        DiffUtil.DiffConfig diffConfig = new DiffUtil.DiffConfig(this.getTextSettings().getIgnorePolicy(), this.getHighlightPolicy());
        if (diffConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffConfig"));
        }
        return diffConfig;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy highlightPolicy = this.getTextSettings().getHighlightPolicy();
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    private void destroyChangedBlocks() {
        for (SimpleDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
        this.myFoldingModel.destroy();
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        Side side = null;
        if (e.getDocument() == this.getEditor(Side.LEFT).getDocument()) {
            side = Side.LEFT;
        }
        if (e.getDocument() == this.getEditor(Side.RIGHT).getDocument()) {
            side = Side.RIGHT;
        }
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleDiffChange> invalid = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myDiffChanges) {
            if (!change.processChange(line1, line2, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        this.myFoldingModel.onDocumentChanged(e);
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        if (scrollToPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToPolicy", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToChange"));
        }
        SimpleDiffChange targetChange = scrollToPolicy.select(this.myDiffChanges);
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    private void doScrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToChange"));
        }
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret(this.getEditor1(), line1);
        DiffUtil.moveCaret(this.getEditor2(), line2);
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToContext"));
        }
        ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT);
        NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, context);
        int line = checker.contextMatchCheck();
        if (line == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
            NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, context);
            line = checker2.contextMatchCheck();
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    protected List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSyncScrollable"));
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    @NotNull
    public ModifierProvider getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getModifierProvider"));
        }
        return modifierProvider;
    }

    @Override
    @NotNull
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.TwosideSyncScrollSupport twosideSyncScrollSupport = super.getSyncScrollSupport();
        if (twosideSyncScrollSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSyncScrollSupport"));
        }
        return twosideSyncScrollSupport;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    private List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        BitSet lines = DiffUtil.getSelectedLines(this.getEditor(side));
        ArrayList<SimpleDiffChange> affectedChanges = new ArrayList<SimpleDiffChange>();
        for (int i = this.myDiffChanges.size() - 1; i >= 0; --i) {
            int line2;
            SimpleDiffChange change = this.myDiffChanges.get(i);
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(lines, line1, line2 = change.getEndLine(side))) continue;
            affectedChanges.add(change);
        }
        ArrayList<SimpleDiffChange> arrayList = affectedChanges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        return arrayList;
    }

    @Nullable
    private SimpleDiffChange getSelectedChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChange"));
        }
        int caretLine = this.getEditor((Side)side).getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.myDiffChanges) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "replaceChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffViewer", "replaceChange"));
        }
        if (!change.isValid()) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "appendChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffViewer", "appendChange"));
        }
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        Side outputSide = sourceSide.other();
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getEndLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        SimpleDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;

        public MyFoldingModel(@NotNull List<? extends EditorEx> editors, @NotNull Disposable disposable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            super(editors.toArray(new EditorEx[2]), disposable);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
        }

        public void install(@Nullable List<LineFragment> fragments, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "install"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(fragments, new Function<LineFragment, int[]>(){

                public int[] fun(LineFragment fragment) {
                    return new int[]{fragment.getStartLine1(), fragment.getEndLine1(), fragment.getStartLine2(), fragment.getEndLine2()};
                }
            });
            this.install(it, context, settings);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }
    }

    public class ModifierProvider
    extends KeyboardModifierListener {
        public void init() {
            this.init(SimpleDiffViewer.this.myPanel, (Disposable)SimpleDiffViewer.this);
        }

        @Override
        public void onModifiersChanged() {
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(false);
            }
        }
    }

    private static class CompareData {
        @Nullable
        private final List<LineFragment> myFragments;
        private final boolean myEqualContent;

        public CompareData(@Nullable List<LineFragment> fragments, boolean equalContent) {
            this.myFragments = fragments;
            this.myEqualContent = equalContent;
        }

        @Nullable
        public List<LineFragment> getFragments() {
            return this.myFragments;
        }

        public boolean isEqualContent() {
            return this.myEqualContent;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return SimpleDiffViewer.this.myDiffChanges.size() + SimpleDiffViewer.this.myInvalidDiffChanges.size();
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), this);
            SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "process"));
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (handler.process(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), diffChange.getDiffType().getColor(SimpleDiffViewer.this.getEditor1()))) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        public int transfer(@NotNull Side baseSide, int line) {
            if (baseSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "transfer"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return line;
            }
            return super.transfer(baseSide, line);
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "processHelper"));
            }
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(SimpleDiffViewer.this.getEditor1().getDocument().getLineCount(), SimpleDiffViewer.this.getEditor2().getDocument().getLineCount());
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        private int myIndex;

        private ChangedLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.mySide = side;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.myDiffChanges.size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(this.mySide);
            int line2 = change.getEndLine(this.mySide);
            DocumentEx document = SimpleDiffViewer.this.getEditor(this.mySide).getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text);
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine;

        private AllLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AllLinesIterator", "<init>"));
            }
            this.myLine = 0;
            this.mySide = side;
            this.myDocument = SimpleDiffViewer.this.getEditor(this.mySide).getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void onSettingsChanged() {
            SimpleDiffViewer.this.rediff();
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction() {
            super(SimpleDiffViewer.this.getTextSettings());
        }

        @Override
        protected void onSettingsChanged() {
            SimpleDiffViewer.this.rediff();
        }
    }

    private class RevertSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public RevertSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "<init>"));
            }
            super(focusedSide, false);
            this.getTemplatePresentation().setText("Revert");
            this.getTemplatePresentation().setIcon(AllIcons.Diff.Remove);
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "isVisible"));
            }
            return side == this.myModifiedSide;
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "<init>"));
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Insert");
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown));
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "isVisible"));
            }
            return side == this.myModifiedSide.other();
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            if (focusedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusedSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "<init>"));
            }
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Replace");
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow));
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "isVisible"));
            }
            return side == this.myModifiedSide.other();
        }

        @Override
        protected void apply(@NotNull List<SimpleDiffChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;
        private final boolean myShortcut;

        public ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            if (modifiedSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "<init>"));
            }
            this.myModifiedSide = modifiedSide;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "update"));
            }
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != SimpleDiffViewer.this.getEditor1() && editor != SimpleDiffViewer.this.getEditor2()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Side side = Side.fromLeft((editor == SimpleDiffViewer.this.getEditor(Side.LEFT) ? 1 : 0) != 0);
            if (!this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            EditorEx modifiedEditor = SimpleDiffViewer.this.getEditor(this.myModifiedSide);
            if (!DiffUtil.isEditable(modifiedEditor)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "actionPerformed"));
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != SimpleDiffViewer.this.getEditor1() && editor != SimpleDiffViewer.this.getEditor2()) {
                return;
            }
            Side side = Side.fromLeft((editor == SimpleDiffViewer.this.getEditor(Side.LEFT) ? 1 : 0) != 0);
            final List selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            EditorEx modifiedEditor = SimpleDiffViewer.this.getEditor(this.myModifiedSide);
            if (!DiffUtil.isEditable(modifiedEditor)) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(modifiedEditor.getDocument(), e.getProject(), title, new Runnable(){

                @Override
                public void run() {
                    ApplySelectedChangesActionBase.this.apply(selectedChanges);
                }
            });
        }

        protected boolean isSomeChangeSelected(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "isSomeChangeSelected"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleDiffViewer.this.getEditor(side);
            List carets = editor.getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = editor.getDocument().getLineNumber(editor.getExpectedCaretOffset());
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                if (!change.isSelectedByLine(line, side)) continue;
                return true;
            }
            return false;
        }

        protected abstract boolean isVisible(@NotNull Side var1);

        protected abstract void apply(@NotNull List<SimpleDiffChange> var1);
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this.getContext(), SimpleDiffViewer.this.getEditableEditors());
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(true);
            }
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<SimpleDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<SimpleDiffChange> getChanges() {
            List list = SimpleDiffViewer.this.myDiffChanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "getChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = SimpleDiffViewer.this.getCurrentEditor();
            if (editorEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "getEditor"));
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "getStartLine"));
            }
            return change.getStartLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull SimpleDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "getEndLine"));
            }
            return change.getEndLine(SimpleDiffViewer.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull SimpleDiffChange change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "scrollToChange"));
            }
            SimpleDiffViewer.this.doScrollToChange(change, true);
        }
    }
}

