/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final List<? extends EditorEx> myEditors;
    @NotNull
    private final MergeLineFragment myFragment;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        super(fragment, editors, policy);
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myLineStartShifts = new int[3];
        this.myLineEndShifts = new int[3];
        this.myEditors = editors;
        this.myFragment = fragment;
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.getType().isLeftChange()) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.getType().isRightChange()) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void createHighlighter(@NotNull ThreeSide side) {
        int start;
        int end;
        int endLine;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.select(this.myEditors);
        Document document = editor.getDocument();
        TextDiffType type = this.getDiffType();
        int startLine = this.myFragment.getStartLine(side);
        if (startLine == (endLine = this.myFragment.getEndLine(side))) {
            end = startLine < DiffUtil.getLineCount(document) ? document.getLineStartOffset(startLine) : document.getTextLength();
            start = end;
        } else {
            start = document.getLineStartOffset(startLine);
            end = document.getLineEndOffset(endLine - 1);
            if (end < document.getTextLength()) {
                ++end;
            }
        }
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, start, end, type));
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true));
            }
        } else {
            this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP));
            this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM));
        }
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getStartLine"));
        }
        return this.myFragment.getStartLine(side) + side.select(this.myLineStartShifts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getEndLine"));
        }
        return this.myFragment.getEndLine(side) + side.select(this.myLineEndShifts);
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "processChange"));
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        return newRange.damaged;
    }
}

