/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffViewerBase
implements FrameDiffTool.DiffViewer,
DataProvider {
    protected static final Logger LOG = Logger.getInstance(DiffViewerBase.class);
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final ContentDiffRequest myRequest;
    @NotNull
    private final DiffTaskQueue myTaskExecutor;
    @NotNull
    private final Alarm myTaskAlarm;
    private volatile boolean myDisposed;

    public DiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/DiffViewerBase", "<init>"));
        }
        this.myTaskExecutor = new DiffTaskQueue();
        this.myTaskAlarm = new Alarm();
        this.myProject = context.getProject();
        this.myContext = context;
        this.myRequest = request;
    }

    @NotNull
    public final FrameDiffTool.ToolbarComponents init() {
        this.processContextHints();
        this.onInit();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbarActions();
        components.popupActions = this.createPopupActions();
        components.statusPanel = this.getStatusPanel();
        this.rediff(true);
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "init"));
        }
        return toolbarComponents;
    }

    public final void dispose() {
        if (this.myDisposed) {
            return;
        }
        Runnable doDispose = new Runnable(){

            @Override
            public void run() {
                if (DiffViewerBase.this.myDisposed) {
                    return;
                }
                DiffViewerBase.this.myDisposed = true;
                DiffViewerBase.this.abortRediff();
                DiffViewerBase.this.updateContextHints();
                DiffViewerBase.this.onDispose();
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            LOG.warn(new Throwable("dispose() not from EDT"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)doDispose);
    }

    protected void processContextHints() {
    }

    protected void updateContextHints() {
    }

    public final void scheduleRediff() {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.myTaskAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                DiffViewerBase.this.rediff();
            }
        }, 300);
    }

    public final void abortRediff() {
        this.myTaskExecutor.abort();
        this.myTaskAlarm.cancelAllRequests();
    }

    public final void rediff() {
        this.rediff(false);
    }

    public void rediff(boolean trySync) {
        if (this.isDisposed()) {
            return;
        }
        this.abortRediff();
        this.onBeforeRediff();
        boolean forceEDT = ApplicationManager.getApplication().isWriteAccessAllowed();
        int waitMillis = trySync || this.tryRediffSynchronously() ? 300 : 0;
        this.myTaskExecutor.executeAndTryWait(new Function<ProgressIndicator, Runnable>(){

            public Runnable fun(ProgressIndicator indicator) {
                return DiffViewerBase.this.performRediff(indicator);
            }
        }, new Runnable(){

            @Override
            public void run() {
                DiffViewerBase.this.onSlowRediff();
            }
        }, waitMillis, forceEDT);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getRequest"));
        }
        return contentDiffRequest;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffViewerBase", "getContext"));
        }
        return diffContext;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean tryRediffSynchronously() {
        return this.myContext.isWindowFocused();
    }

    @Nullable
    protected List<AnAction> createToolbarActions() {
        return null;
    }

    @Nullable
    protected List<AnAction> createPopupActions() {
        return null;
    }

    @Nullable
    protected JComponent getStatusPanel() {
        return null;
    }

    protected void onInit() {
    }

    protected void onSlowRediff() {
    }

    protected void onBeforeRediff() {
    }

    @NotNull
    protected abstract Runnable performRediff(@NotNull ProgressIndicator var1);

    protected void onDispose() {
        Disposer.dispose((Disposable)this.myTaskAlarm);
    }

    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        if (DiffDataKeys.OPEN_FILE_DESCRIPTOR.is(dataId)) {
            return this.getOpenFileDescriptor();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }
}

