/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    StopAction() {
    }

    private static boolean isPlaceGlobal(AnActionEvent e) {
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace());
    }

    public void update(AnActionEvent e) {
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getDataContext());
            List<Pair<TaskInfo, ProgressIndicator>> cancellableProcesses = StopAction.getCancellableProcesses(e.getProject());
            int todoSize = stoppableDescriptors.size() + cancellableProcesses.size();
            if (todoSize > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
            } else if (todoSize == 1) {
                if (stoppableDescriptors.size() == 1) {
                    presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{stoppableDescriptors.get(0).getDisplayName()}));
                } else {
                    TaskInfo taskInfo = (TaskInfo)cancellableProcesses.get((int)0).first;
                    presentation.setText(taskInfo.getCancelText() + " " + taskInfo.getTitle());
                }
            } else {
                presentation.setText(this.getTemplatePresentation().getText());
            }
            boolean bl = enable = todoSize > 0;
            if (todoSize > 1) {
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(todoSize));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler2 = processHandler = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler != null && !processHandler.isProcessTerminated()) {
                if (!processHandler.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{runProfile == null ? contentDescriptor.getDisplayName() : runProfile.getName()}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<Pair<TaskInfo, ProgressIndicator>> cancellableProcesses = StopAction.getCancellableProcesses(project);
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        if (StopAction.isPlaceGlobal(e)) {
            Component component;
            int todoSize = cancellableProcesses.size() + stoppableDescriptors.size();
            if (todoSize == 1) {
                if (!stoppableDescriptors.isEmpty()) {
                    StopAction.stopProcess(stoppableDescriptors.get(0));
                } else {
                    ((ProgressIndicator)cancellableProcesses.get((int)0).second).cancel();
                }
                return;
            }
            Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(cancellableProcesses, stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            final JBList list = new JBList((Collection)handlerItems.first);
            if (handlerItems.second != null) {
                list.setSelectedValue(handlerItems.second, true);
            }
            list.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter(){

                @Nullable
                public String getTextFor(Object value) {
                    return value instanceof HandlerItem ? ((HandlerItem)value).displayName : null;
                }

                @Nullable
                public Icon getIconFor(Object value) {
                    return value instanceof HandlerItem ? ((HandlerItem)value).icon : null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return value instanceof HandlerItem && ((HandlerItem)value).hasSeparator;
                }
            }));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setMovable(true).setTitle(((List)handlerItems.first).size() == 1 ? "Confirm process stop" : "Stop process").setFilteringEnabled((Function)new Function<Object, String>(){

                public String fun(Object o) {
                    return ((HandlerItem)o).displayName;
                }
            }).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    HandlerItem item = (HandlerItem)list.getSelectedValue();
                    if (item != null) {
                        item.stop();
                    }
                }
            }).setRequestFocus(true).createPopup();
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null && "MainToolbar".equals(e.getPlace())) {
                popup.showUnderneathOf(component);
            } else if (project == null) {
                popup.showInBestPositionFor(dataContext);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        } else {
            StopAction.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @NotNull
    private static List<Pair<TaskInfo, ProgressIndicator>> getCancellableProcesses(@Nullable Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            List<Pair<TaskInfo, ProgressIndicator>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getCancellableProcesses"));
            }
            return list;
        }
        List list = ContainerUtil.findAll(statusBar.getBackgroundProcesses(), (Condition)new Condition<Pair<TaskInfo, ProgressIndicator>>(){

            public boolean value(Pair<TaskInfo, ProgressIndicator> pair) {
                return ((TaskInfo)pair.first).isCancellable() && !((ProgressIndicator)pair.second).isCanceled();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getCancellableProcesses"));
        }
        return list;
    }

    @Nullable
    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<Pair<TaskInfo, ProgressIndicator>> tasks, List<RunContentDescriptor> descriptors, RunContentDescriptor toSelect) {
        if (tasks.isEmpty() && descriptors.isEmpty()) {
            return null;
        }
        ArrayList<HandlerItem> items = new ArrayList<HandlerItem>(tasks.size() + descriptors.size());
        HandlerItem selected = null;
        for (final RunContentDescriptor descriptor : descriptors) {
            ProcessHandler handler = descriptor.getProcessHandler();
            if (handler == null) continue;
            HandlerItem item = new HandlerItem(descriptor.getDisplayName(), descriptor.getIcon(), false){

                @Override
                void stop() {
                    StopAction.stopProcess(descriptor);
                }
            };
            items.add(item);
            if (descriptor != toSelect) continue;
            selected = item;
        }
        boolean hasSeparator = true;
        for (final Pair<TaskInfo, ProgressIndicator> eachPair : tasks) {
            items.add(new HandlerItem(((TaskInfo)eachPair.first).getTitle(), AllIcons.Process.Step_passive, hasSeparator){

                @Override
                void stop() {
                    ((ProgressIndicator)eachPair.second).cancel();
                }
            });
            hasSeparator = false;
        }
        return Pair.create(items, selected);
    }

    private static void stopProcess(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler;
        ProcessHandler processHandler2 = processHandler = descriptor != null ? descriptor.getProcessHandler() : null;
        if (processHandler == null) {
            return;
        }
        if (processHandler instanceof KillableProcess && processHandler.isProcessTerminating()) {
            ((KillableProcess)processHandler).killProcess();
            return;
        }
        if (processHandler.detachIsDefault()) {
            processHandler.detachProcess();
        } else {
            processHandler.destroyProcess();
        }
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/actions/StopAction", "getRecentlyStartedContentDescriptor"));
        }
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext);
        if (contentDescriptor != null) {
            return contentDescriptor;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null ? null : ExecutionManager.getInstance((Project)project).getContentManager().getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list;
        }
        ArrayList<RunContentDescriptor> activeDescriptors = new ArrayList<RunContentDescriptor>();
        for (RunContentDescriptor descriptor : runningProcesses) {
            if (!StopAction.canBeStopped(descriptor)) continue;
            activeDescriptors.add(descriptor);
        }
        ArrayList<RunContentDescriptor> arrayList = activeDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
        }
        return arrayList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler = descriptor != null ? descriptor.getProcessHandler() : null;
        return processHandler != null && !processHandler.isProcessTerminated() && (!processHandler.isProcessTerminating() || processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess());
    }

    private static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        private HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

