/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationsSettings;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.impl.TemplateConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunConfigurable
extends BaseConfigurable {
    private static final Icon ADD_ICON = IconUtil.getAddIcon();
    private static final Icon REMOVE_ICON = IconUtil.getRemoveIcon();
    private static final Icon SHARED_ICON = AllIcons.Nodes.Shared;
    private static final Icon NON_SHARED_ICON = EmptyIcon.ICON_16;
    @NonNls
    private static final Object DEFAULTS = new Object(){

        public String toString() {
            return "Defaults";
        }
    };
    private volatile boolean isDisposed = false;
    private final Project myProject;
    private RunDialogBase myRunDialog;
    @NonNls
    final DefaultMutableTreeNode myRoot = new DefaultMutableTreeNode("Root");
    final MyTreeModel myTreeModel = new MyTreeModel(this.myRoot);
    final Tree myTree = new Tree((TreeModel)this.myTreeModel);
    private final JPanel myRightPanel = new JPanel(new BorderLayout());
    private final JBSplitter mySplitter = new JBSplitter("RunConfigurable.dividerProportion", 0.3f);
    private JPanel myWholePanel;
    private Configurable mySelectedConfigurable = null;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunConfigurable");
    private final JTextField myRecentsLimit = new JTextField("5", 2);
    private final JCheckBox myConfirmation = new JCheckBox(ExecutionBundle.message((String)"rerun.confirmation.checkbox", (Object[])new Object[0]), true);
    private final List<Pair<UnnamedConfigurable, JComponent>> myAdditionalSettings = new ArrayList<Pair<UnnamedConfigurable, JComponent>>();
    private Map<ConfigurationFactory, Configurable> myStoredComponents = new HashMap();
    private ToolbarDecorator myToolbarDecorator;
    private boolean isFolderCreating;
    private MyToolbarAddAction myAddAction = new MyToolbarAddAction();

    public RunConfigurable(Project project) {
        this(project, null);
    }

    public RunConfigurable(Project project, @Nullable RunDialogBase runDialog) {
        this.myProject = project;
        this.myRunDialog = runDialog;
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"run.configurable.display.name", (Object[])new Object[0]);
    }

    private void initTree() {
        ConfigurationType[] configurationTypes;
        ConfigurationType[] factories;
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                    return ((RunnerAndConfigurationSettingsImpl)userObject).getName();
                }
                if (userObject instanceof SingleConfigurationConfigurable) {
                    return ((SingleConfigurationConfigurable)((Object)userObject)).getNameText();
                }
                if (userObject instanceof ConfigurationType) {
                    return ((ConfigurationType)userObject).getDisplayName();
                }
                if (userObject instanceof String) {
                    return (String)userObject;
                }
                return o.toString();
            }
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    Object userObject = node.getUserObject();
                    Boolean shared = null;
                    String name = RunConfigurable.getName(userObject);
                    if (userObject instanceof ConfigurationType) {
                        ConfigurationType configurationType = (ConfigurationType)userObject;
                        this.append(name, parent.isRoot() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.setIcon(configurationType.getIcon());
                    } else if (userObject == DEFAULTS) {
                        this.append(name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.setIcon(AllIcons.General.Settings);
                    } else if (userObject instanceof String) {
                        this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.setIcon(AllIcons.Nodes.Folder);
                    } else if (userObject instanceof ConfigurationFactory) {
                        this.append(name);
                        this.setIcon(((ConfigurationFactory)userObject).getIcon());
                    } else {
                        RunManagerImpl runManager = RunConfigurable.this.getRunManager();
                        RunnerAndConfigurationSettings configuration = null;
                        if (userObject instanceof SingleConfigurationConfigurable) {
                            RunnerAndConfigurationSettings configurationSettings;
                            SingleConfigurationConfigurable settings = (SingleConfigurationConfigurable)((Object)userObject);
                            configuration = configurationSettings = (RunnerAndConfigurationSettings)settings.getSettings();
                            shared = settings.isStoreProjectConfiguration();
                            this.setIcon(ProgramRunnerUtil.getConfigurationIcon(configurationSettings, !settings.isValid()));
                        } else if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)userObject;
                            shared = runManager.isConfigurationShared(settings);
                            this.setIcon(RunManagerEx.getInstanceEx(RunConfigurable.this.myProject).getConfigurationIcon(settings));
                            configuration = settings;
                        }
                        if (configuration != null) {
                            this.append(name, configuration.isTemporary() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                    }
                    if (shared != null) {
                        Icon icon = this.getIcon();
                        LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{icon, shared != false ? SHARED_ICON : NON_SHARED_ICON});
                        this.setIcon((Icon)layeredIcon);
                        this.setIconTextGap(0);
                    } else {
                        this.setIconTextGap(2);
                    }
                }
            }
        });
        final RunManagerImpl manager = this.getRunManager();
        for (ConfigurationType type : factories = manager.getConfigurationFactories()) {
            List configurations = manager.getConfigurationSettingsList(type);
            if (configurations.isEmpty()) continue;
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            this.myRoot.add(typeNode);
            HashMap folderMapping = new HashMap();
            int folderCounter = 0;
            for (RunnerAndConfigurationSettings configuration : configurations) {
                String folder = configuration.getFolderName();
                if (folder != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)folderMapping.get(folder);
                    if (node == null) {
                        node = new DefaultMutableTreeNode(folder);
                        typeNode.insert(node, folderCounter);
                        ++folderCounter;
                        folderMapping.put(folder, node);
                    }
                    node.add(new DefaultMutableTreeNode(configuration));
                    continue;
                }
                typeNode.add(new DefaultMutableTreeNode(configuration));
            }
        }
        DefaultMutableTreeNode defaults = new DefaultMutableTreeNode(DEFAULTS);
        for (ConfigurationType type : configurationTypes = RunManagerImpl.getInstanceImpl(this.myProject).getConfigurationFactories()) {
            if (type instanceof UnknownConfigurationType) continue;
            ConfigurationFactory[] configurationFactories = type.getConfigurationFactories();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            defaults.add(typeNode);
            if (configurationFactories.length == 1) continue;
            for (ConfigurationFactory factory : configurationFactories) {
                typeNode.add(new DefaultMutableTreeNode(factory));
            }
        }
        if (defaults.getChildCount() > 0) {
            this.myRoot.add(defaults);
        }
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = RunConfigurable.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    Object userObject = RunConfigurable.this.getSafeUserObject(node);
                    if (userObject instanceof SingleConfigurationConfigurable) {
                        RunConfigurable.this.updateRightPanel((Configurable)((SingleConfigurationConfigurable)((Object)userObject)));
                    } else if (userObject instanceof String) {
                        RunConfigurable.this.showFolderField(RunConfigurable.this.getSelectedConfigurationType(), node, (String)userObject);
                    } else if (userObject instanceof ConfigurationType || userObject == DEFAULTS) {
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                        if (parent.isRoot()) {
                            RunConfigurable.this.drawPressAddButtonMessage(userObject == DEFAULTS ? null : (ConfigurationType)userObject);
                        } else {
                            ConfigurationType type = (ConfigurationType)userObject;
                            ConfigurationFactory[] factories = type.getConfigurationFactories();
                            if (factories.length == 1) {
                                ConfigurationFactory factory = factories[0];
                                RunConfigurable.this.showTemplateConfigurable(factory);
                            } else {
                                RunConfigurable.this.drawPressAddButtonMessage((ConfigurationType)userObject);
                            }
                        }
                    } else if (userObject instanceof ConfigurationFactory) {
                        RunConfigurable.this.showTemplateConfigurable((ConfigurationFactory)userObject);
                    }
                }
                RunConfigurable.this.updateDialog();
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunConfigurable.this.clickDefaultButton();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RunConfigurable.this.isDisposed) {
                    return;
                }
                RunConfigurable.this.myTree.requestFocusInWindow();
                RunnerAndConfigurationSettings settings = manager.getSelectedConfiguration();
                if (settings != null) {
                    Enumeration<TreeNode> enumeration = RunConfigurable.this.myRoot.breadthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
                        Object userObject = node.getUserObject();
                        if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)userObject;
                        ConfigurationType configurationType = settings.getType();
                        if (configurationType == null || !Comparing.strEqual((String)runnerAndConfigurationSettings.getConfiguration().getType().getId(), (String)configurationType.getId()) || !Comparing.strEqual((String)runnerAndConfigurationSettings.getConfiguration().getName(), (String)settings.getName())) continue;
                        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)RunConfigurable.this.myTree);
                        return;
                    }
                } else {
                    RunConfigurable.this.mySelectedConfigurable = null;
                }
                RunConfigurable.this.drawPressAddButtonMessage(null);
            }
        });
        this.sortTopLevelBranches();
        ((DefaultTreeModel)this.myTree.getModel()).reload();
    }

    private void showTemplateConfigurable(ConfigurationFactory factory) {
        Object configurable = this.myStoredComponents.get(factory);
        if (configurable == null) {
            configurable = new TemplateConfigurable(RunManagerImpl.getInstanceImpl(this.myProject).getConfigurationTemplate(factory));
            this.myStoredComponents.put(factory, (Configurable)configurable);
            configurable.reset();
        }
        this.updateRightPanel((Configurable)configurable);
    }

    private void showFolderField(ConfigurationType type, final DefaultMutableTreeNode node, String folderName) {
        this.myRightPanel.removeAll();
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins " + this.myToolbarDecorator.getActionsPanel().getHeight() + " 5 0 0, flowx"));
        final JTextField textField = new JTextField(folderName);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                node.setUserObject(textField.getText());
                RunConfigurable.this.myTreeModel.reload(node);
            }
        });
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunConfigurable.this.myTree.requestFocus();
            }
        });
        p.add((Component)new JLabel("Folder name:"), "gapright 5");
        p.add((Component)textField, "pushx, growx, wrap");
        p.add((Component)new JLabel(ExecutionBundle.message((String)"run.configuration.rename.folder.disclaimer", (Object[])new Object[0])), "gaptop 5, spanx 2");
        this.myRightPanel.add(p);
        this.myRightPanel.revalidate();
        this.myRightPanel.repaint();
        if (this.isFolderCreating) {
            textField.selectAll();
            textField.requestFocus();
        }
    }

    private Object getSafeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
            SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = SingleConfigurationConfigurable.editSettings((RunnerAndConfigurationSettings)userObject, null);
            this.installUpdateListeners(configurationConfigurable);
            node.setUserObject(configurationConfigurable);
            return configurationConfigurable;
        }
        return userObject;
    }

    public void setRunDialog(RunDialogBase runDialog) {
        this.myRunDialog = runDialog;
    }

    private void updateRightPanel(final Configurable configurable) {
        this.myRightPanel.removeAll();
        this.mySelectedConfigurable = configurable;
        JComponent configurableComponent = configurable.createComponent();
        JBScrollPane scrollPane = new JBScrollPane((Component)configurableComponent);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.setBorder(null);
        this.myRightPanel.add((Component)scrollPane, "Center");
        if (configurable instanceof SingleConfigurationConfigurable) {
            DataProvider dataProvider;
            this.myRightPanel.add((Component)((SingleConfigurationConfigurable)configurable).getValidationComponent(), "South");
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((SingleConfigurationConfigurable)configurable).updateWarning();
                }
            });
            if (configurableComponent != null && (dataProvider = DataManager.getDataProvider((JComponent)configurableComponent)) != null) {
                DataManager.registerDataProvider((JComponent)this.myRightPanel, (DataProvider)dataProvider);
            }
        }
        this.setupDialogBounds();
    }

    private void sortTopLevelBranches() {
        List expandedPaths = TreeUtil.collectExpandedPaths((JTree)this.myTree);
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                Object userObject1 = ((DefaultMutableTreeNode)o1).getUserObject();
                Object userObject2 = ((DefaultMutableTreeNode)o2).getUserObject();
                if (userObject1 instanceof ConfigurationType && userObject2 instanceof ConfigurationType) {
                    return ((ConfigurationType)userObject1).getDisplayName().compareTo(((ConfigurationType)userObject2).getDisplayName());
                }
                if (userObject1 == DEFAULTS && userObject2 instanceof ConfigurationType) {
                    return 1;
                }
                if (userObject2 == DEFAULTS && userObject1 instanceof ConfigurationType) {
                    return -1;
                }
                return 0;
            }
        });
        TreeUtil.restoreExpandedPaths((JTree)this.myTree, (List)expandedPaths);
    }

    private void update() {
        this.updateDialog();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            this.myTreeModel.reload(node);
        }
    }

    private void installUpdateListeners(final SingleConfigurationConfigurable<RunConfiguration> info) {
        final boolean[] changed = new boolean[]{false};
        info.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettings>(){

            public void stateChanged(SettingsEditor<RunnerAndConfigurationSettings> editor) {
                LocatableConfiguration runtimeConfiguration;
                RunConfigurable.this.update();
                Object configuration = info.getConfiguration();
                if (configuration instanceof LocatableConfiguration && (runtimeConfiguration = (LocatableConfiguration)configuration).isGeneratedName() && !changed[0]) {
                    try {
                        LocatableConfiguration snapshot = (LocatableConfiguration)((RunnerAndConfigurationSettings)editor.getSnapshot()).getConfiguration();
                        String generatedName = snapshot.suggestedName();
                        if (generatedName != null && generatedName.length() > 0) {
                            info.setNameText(generatedName);
                            changed[0] = false;
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                RunConfigurable.this.setupDialogBounds();
            }
        });
        info.addNameListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                changed[0] = true;
                RunConfigurable.this.update();
            }
        });
        info.addSharedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                changed[0] = true;
                RunConfigurable.this.update();
            }
        });
    }

    private void drawPressAddButtonMessage(ConfigurationType configurationType) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.setBorder(new EmptyBorder(30, 0, 0, 0));
        panel.add(new JLabel("Press the"));
        ActionLink addIcon = new ActionLink("", ADD_ICON, (AnAction)this.myAddAction);
        addIcon.setBorder((Border)new EmptyBorder(0, 0, 0, 5));
        panel.add((Component)addIcon);
        String configurationTypeDescription = configurationType != null ? configurationType.getConfigurationTypeDescription() : ExecutionBundle.message((String)"run.configuration.default.type.description", (Object[])new Object[0]);
        panel.add(new JLabel(ExecutionBundle.message((String)"empty.run.configuration.panel.text.label3", (Object[])new Object[]{configurationTypeDescription})));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true);
        this.myRightPanel.removeAll();
        this.myRightPanel.add((Component)scrollPane, "Center");
        if (configurationType == null) {
            JPanel settingsPanel = new JPanel(new GridBagLayout());
            GridBag grid = new GridBag().setDefaultAnchor(18);
            for (Pair<UnnamedConfigurable, JComponent> each : this.myAdditionalSettings) {
                settingsPanel.add((Component)each.second, grid.nextLine().next());
            }
            settingsPanel.add((Component)this.createSettingsPanel(), grid.nextLine().next());
            JPanel wrapper = new JPanel(new BorderLayout());
            wrapper.add((Component)settingsPanel, "West");
            wrapper.add(Box.createGlue(), "Center");
            this.myRightPanel.add((Component)wrapper, "South");
        }
        this.myRightPanel.revalidate();
        this.myRightPanel.repaint();
    }

    private static String getName(Object userObject) {
        if (userObject instanceof ConfigurationType) {
            return ((ConfigurationType)userObject).getDisplayName();
        }
        if (userObject == DEFAULTS) {
            return "Defaults";
        }
        if (userObject instanceof ConfigurationFactory) {
            return ((ConfigurationFactory)userObject).getName();
        }
        if (userObject instanceof SingleConfigurationConfigurable) {
            return ((SingleConfigurationConfigurable)((Object)userObject)).getNameText();
        }
        if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
            return ((RunnerAndConfigurationSettingsImpl)userObject).getName();
        }
        return String.valueOf(userObject);
    }

    private JPanel createLeftPanel() {
        this.initTree();
        MyRemoveAction removeAction = new MyRemoveAction();
        MyMoveAction moveUpAction = new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), null, IconUtil.getMoveUpIcon(), -1);
        MyMoveAction moveDownAction = new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), null, IconUtil.getMoveDownIcon(), 1);
        this.myToolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAsUsualTopToolbar().setAddAction((AnActionButtonRunnable)this.myAddAction).setAddActionName(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0])).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction).setRemoveActionName(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0])).setMoveUpAction((AnActionButtonRunnable)moveUpAction).setMoveUpActionName(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0])).setMoveUpActionUpdater((AnActionButtonUpdater)moveUpAction).setMoveDownAction((AnActionButtonRunnable)moveDownAction).setMoveDownActionName(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0])).setMoveDownActionUpdater((AnActionButtonUpdater)moveDownAction).addExtraAction(AnActionButton.fromAction((AnAction)new MyCopyAction())).addExtraAction(AnActionButton.fromAction((AnAction)new MySaveAction())).addExtraAction(AnActionButton.fromAction((AnAction)new MyEditDefaultsAction())).addExtraAction(AnActionButton.fromAction((AnAction)new MyCreateFolderAction())).addExtraAction(AnActionButton.fromAction((AnAction)new MySortFolderAction())).setButtonComparator(new String[]{ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.text", (Object[])new Object[0]), ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0])}).setForcedDnD();
        return this.myToolbarDecorator.createPanel();
    }

    private JPanel createSettingsPanel() {
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag();
        bottomPanel.add((Component)this.myConfirmation, g.nextLine().coverLine());
        bottomPanel.add((Component)LabeledComponent.create((JComponent)this.myRecentsLimit, (String)ExecutionBundle.message((String)"temporary.configurations.limit", (Object[])new Object[0]), (String)"West"), g.nextLine().insets((Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)).anchor(17));
        this.myRecentsLimit.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                RunConfigurable.this.setModified(true);
            }
        });
        this.myConfirmation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RunConfigurable.this.setModified(true);
            }
        });
        return bottomPanel;
    }

    @Nullable
    private ConfigurationType getSelectedConfigurationType() {
        DefaultMutableTreeNode configurationTypeNode = this.getSelectedConfigurationTypeNode();
        return configurationTypeNode != null ? (ConfigurationType)configurationTypeNode.getUserObject() : null;
    }

    public JComponent createComponent() {
        for (RunConfigurationsSettings each : (RunConfigurationsSettings[])Extensions.getExtensions((ExtensionPointName)RunConfigurationsSettings.EXTENSION_POINT, (AreaInstance)this.myProject)) {
            UnnamedConfigurable configurable = each.createConfigurable();
            this.myAdditionalSettings.add((Pair<UnnamedConfigurable, JComponent>)Pair.create((Object)configurable, (Object)configurable.createComponent()));
        }
        this.myWholePanel = new JPanel(new BorderLayout());
        this.mySplitter.setFirstComponent((JComponent)this.createLeftPanel());
        this.mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.myWholePanel.add((Component)this.mySplitter, "Center");
        this.updateDialog();
        Dimension d = this.myWholePanel.getPreferredSize();
        d.width = Math.max(d.width, 800);
        d.height = Math.max(d.height, 600);
        this.myWholePanel.setPreferredSize(d);
        return this.myWholePanel;
    }

    public void reset() {
        RunManagerImpl manager = this.getRunManager();
        RunManagerConfig config = ((RunManagerEx)manager).getConfig();
        this.myRecentsLimit.setText(Integer.toString(config.getRecentsLimit()));
        this.myConfirmation.setSelected(config.isRestartRequiresConfirmation());
        for (Pair<UnnamedConfigurable, JComponent> each : this.myAdditionalSettings) {
            ((UnnamedConfigurable)each.first).reset();
        }
        this.setModified(false);
    }

    public Configurable getSelectedConfigurable() {
        return this.mySelectedConfigurable;
    }

    public void apply() throws ConfigurationException {
        this.updateActiveConfigurationFromSelected();
        RunManagerImpl manager = this.getRunManager();
        ConfigurationType[] types = manager.getConfigurationFactories();
        ArrayList<ConfigurationType> configurationTypes = new ArrayList<ConfigurationType>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            Object userObject = defaultMutableTreeNode.getUserObject();
            if (!(userObject instanceof ConfigurationType)) continue;
            configurationTypes.add((ConfigurationType)userObject);
        }
        for (ConfigurationType type : types) {
            if (configurationTypes.contains(type)) continue;
            configurationTypes.add(type);
        }
        for (ConfigurationType configurationType : configurationTypes) {
            this.applyByType(configurationType);
        }
        try {
            int i = Math.max(0, Integer.parseInt(this.myRecentsLimit.getText()));
            int n = manager.getConfig().getRecentsLimit();
            if (n != i) {
                manager.getConfig().setRecentsLimit(i);
                manager.checkRecentsLimit();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        manager.getConfig().setRestartRequiresConfirmation(this.myConfirmation.isSelected());
        for (Configurable configurable : this.myStoredComponents.values()) {
            if (!configurable.isModified()) continue;
            configurable.apply();
        }
        for (Pair pair : this.myAdditionalSettings) {
            ((UnnamedConfigurable)pair.first).apply();
        }
        manager.saveOrder();
        this.setModified(false);
        this.myTree.repaint();
    }

    protected void updateActiveConfigurationFromSelected() {
        if (this.mySelectedConfigurable != null && this.mySelectedConfigurable instanceof SingleConfigurationConfigurable) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)this.mySelectedConfigurable).getSettings();
            this.getRunManager().setSelectedConfiguration(settings);
        }
    }

    private void applyByType(@NotNull ConfigurationType type) throws ConfigurationException {
        int n;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunConfigurable", "applyByType"));
        }
        RunnerAndConfigurationSettings selectedSettings = this.getSelectedSettings();
        int indexToMove = -1;
        DefaultMutableTreeNode typeNode = this.getConfigurationTypeNode(type);
        RunManagerImpl manager = this.getRunManager();
        ArrayList<RunConfigurationBean> stableConfigurations = new ArrayList<RunConfigurationBean>();
        if (typeNode != null) {
            HashSet names = new HashSet();
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            RunConfigurable.collectNodesRecursively(typeNode, arrayList, NodeKind.CONFIGURATION, NodeKind.TEMPORARY_CONFIGURATION);
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                String nameText;
                SingleConfigurationConfigurable configurable;
                Object userObject = defaultMutableTreeNode.getUserObject();
                RunConfigurationBean configurationBean = null;
                RunnerAndConfigurationSettings settings = null;
                if (userObject instanceof SingleConfigurationConfigurable) {
                    configurable = (SingleConfigurationConfigurable)((Object)userObject);
                    settings = (RunnerAndConfigurationSettings)configurable.getSettings();
                    if (settings.isTemporary()) {
                        this.applyConfiguration(typeNode, configurable);
                    }
                    configurationBean = new RunConfigurationBean(configurable);
                } else if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                    settings = (RunnerAndConfigurationSettings)userObject;
                    configurationBean = new RunConfigurationBean(settings, manager.isConfigurationShared(settings), manager.getBeforeRunTasks(settings.getConfiguration()));
                }
                if (configurationBean == null) continue;
                configurable = configurationBean.getConfigurable();
                String string = nameText = configurable != null ? configurable.getNameText() : configurationBean.getSettings().getName();
                if (!names.add(nameText)) {
                    TreeUtil.selectNode((JTree)this.myTree, (TreeNode)defaultMutableTreeNode);
                    throw new ConfigurationException(type.getDisplayName() + " with name '" + nameText + "' already exists");
                }
                stableConfigurations.add(configurationBean);
                if (settings != selectedSettings) continue;
                indexToMove = stableConfigurations.size() - 1;
            }
            ArrayList<DefaultMutableTreeNode> folderNodes = new ArrayList<DefaultMutableTreeNode>();
            RunConfigurable.collectNodesRecursively(typeNode, folderNodes, NodeKind.FOLDER);
            names.clear();
            for (DefaultMutableTreeNode node : folderNodes) {
                String folderName = (String)node.getUserObject();
                if (folderName.isEmpty()) {
                    TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
                    throw new ConfigurationException("Folder name shouldn't be empty");
                }
                if (names.add(folderName)) continue;
                TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
                throw new ConfigurationException("Folders name '" + folderName + "' is duplicated");
            }
        }
        for (RunConfigurationBean runConfigurationBean : stableConfigurations) {
            SingleConfigurationConfigurable configurable = runConfigurationBean.getConfigurable();
            if (configurable == null) continue;
            this.applyConfiguration(typeNode, configurable);
        }
        THashSet toDeleteSettings = new THashSet();
        for (RunConfiguration each : manager.getConfigurationsList(type)) {
            ContainerUtil.addIfNotNull((Collection)toDeleteSettings, (Object)manager.getSettings(each));
        }
        boolean bl = false;
        if (selectedSettings != null && selectedSettings.getType() == type) {
            n = this.adjustOrder();
        }
        if (n != 0 && indexToMove != -1) {
            stableConfigurations.add(indexToMove - n, (RunConfigurationBean)stableConfigurations.remove(indexToMove));
        }
        for (RunConfigurationBean runConfigurationBean : stableConfigurations) {
            toDeleteSettings.remove(runConfigurationBean.getSettings());
            manager.addConfiguration(runConfigurationBean.getSettings(), runConfigurationBean.isShared(), runConfigurationBean.getStepsBeforeLaunch(), false);
        }
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : toDeleteSettings) {
            manager.removeConfiguration(runnerAndConfigurationSettings);
        }
    }

    static void collectNodesRecursively(DefaultMutableTreeNode parentNode, List<DefaultMutableTreeNode> nodes, NodeKind ... allowed) {
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (ArrayUtilRt.find((Object[])allowed, (Object)((Object)RunConfigurable.getKind(child))) != -1) {
                nodes.add(child);
            }
            RunConfigurable.collectNodesRecursively(child, nodes, allowed);
        }
    }

    @Nullable
    private DefaultMutableTreeNode getConfigurationTypeNode(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/impl/RunConfigurable", "getConfigurationTypeNode"));
        }
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            if (node.getUserObject() != type) continue;
            return node;
        }
        return null;
    }

    private void applyConfiguration(DefaultMutableTreeNode typeNode, SingleConfigurationConfigurable<?> configurable) throws ConfigurationException {
        try {
            if (configurable != null) {
                configurable.apply();
                RunManagerImpl.getInstanceImpl(this.myProject).fireRunConfigurationChanged((RunnerAndConfigurationSettings)configurable.getSettings());
            }
        }
        catch (ConfigurationException e) {
            for (int i = 0; i < typeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)typeNode.getChildAt(i);
                if (!Comparing.equal(configurable, (Object)node.getUserObject())) continue;
                TreeUtil.selectNode((JTree)this.myTree, (TreeNode)node);
                break;
            }
            throw e;
        }
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        RunManagerImpl runManager = this.getRunManager();
        List<RunConfiguration> allConfigurations = runManager.getAllConfigurationsList();
        ArrayList<Object> currentConfigurations = new ArrayList<Object>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof ConfigurationType)) continue;
            List<RunnerAndConfigurationSettings> configurationSettings = runManager.getConfigurationSettingsList((ConfigurationType)object);
            ArrayList<DefaultMutableTreeNode> configurationNodes = new ArrayList<DefaultMutableTreeNode>();
            RunConfigurable.collectNodesRecursively(defaultMutableTreeNode, configurationNodes, NodeKind.CONFIGURATION, NodeKind.TEMPORARY_CONFIGURATION);
            if (configurationSettings.size() != configurationNodes.size()) {
                return true;
            }
            for (int j = 0; j < configurationNodes.size(); ++j) {
                DefaultMutableTreeNode configurationNode = (DefaultMutableTreeNode)configurationNodes.get(j);
                Object userObject = configurationNode.getUserObject();
                if (userObject instanceof SingleConfigurationConfigurable) {
                    SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)userObject);
                    if (!Comparing.strEqual((String)configurationSettings.get(j).getConfiguration().getName(), (String)configurable.getConfiguration().getName())) {
                        return true;
                    }
                    if (configurable.isModified()) {
                        return true;
                    }
                    currentConfigurations.add(configurable.getConfiguration());
                    continue;
                }
                if (!(userObject instanceof RunnerAndConfigurationSettingsImpl)) continue;
                currentConfigurations.add(((RunnerAndConfigurationSettings)userObject).getConfiguration());
            }
        }
        if (allConfigurations.size() != currentConfigurations.size() || !allConfigurations.containsAll(currentConfigurations)) {
            return true;
        }
        for (Configurable configurable : this.myStoredComponents.values()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        for (Pair pair : this.myAdditionalSettings) {
            if (!((UnnamedConfigurable)pair.first).isModified()) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        this.isDisposed = true;
        for (Configurable configurable : this.myStoredComponents.values()) {
            configurable.disposeUIResources();
        }
        this.myStoredComponents.clear();
        for (Pair pair : this.myAdditionalSettings) {
            ((UnnamedConfigurable)pair.first).disposeUIResources();
        }
        TreeUtil.traverseDepth((TreeNode)this.myRoot, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                DefaultMutableTreeNode treeNode;
                Object userObject;
                if (node instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof SingleConfigurationConfigurable) {
                    ((SingleConfigurationConfigurable)((Object)userObject)).disposeUIResources();
                }
                return true;
            }
        });
        this.myRightPanel.removeAll();
        this.mySplitter.dispose();
    }

    private void updateDialog() {
        Executor executor;
        Executor executor2 = executor = this.myRunDialog != null ? this.myRunDialog.getExecutor() : null;
        if (executor == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(executor.getId());
        SingleConfigurationConfigurable<RunConfiguration> configuration = this.getSelectedConfiguration();
        if (configuration != null) {
            buffer.append(" - ");
            buffer.append(configuration.getNameText());
        }
        this.myRunDialog.setOKActionEnabled(RunConfigurable.canRunConfiguration(configuration, executor));
        this.myRunDialog.setTitle(buffer.toString());
    }

    private void setupDialogBounds() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtil.setupEnclosingDialogBounds((JComponent)RunConfigurable.this.myWholePanel);
            }
        });
    }

    @Nullable
    private SingleConfigurationConfigurable<RunConfiguration> getSelectedConfiguration() {
        DefaultMutableTreeNode treeNode;
        Object userObject;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && (userObject = (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof SingleConfigurationConfigurable) {
            return (SingleConfigurationConfigurable)((Object)userObject);
        }
        return null;
    }

    private static boolean canRunConfiguration(@Nullable SingleConfigurationConfigurable<RunConfiguration> configuration, @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/impl/RunConfigurable", "canRunConfiguration"));
        }
        try {
            return configuration != null && RunManagerImpl.canRunConfiguration(configuration.getSnapshot(), executor);
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    RunManagerImpl getRunManager() {
        return RunManagerImpl.getInstanceImpl(this.myProject);
    }

    public String getHelpTopic() {
        ConfigurationType type = this.getSelectedConfigurationType();
        if (type != null) {
            return "reference.dialogs.rundebug." + type.getId();
        }
        return "reference.dialogs.rundebug";
    }

    private void clickDefaultButton() {
        if (this.myRunDialog != null) {
            this.myRunDialog.clickDefaultButton();
        }
    }

    @Nullable
    private DefaultMutableTreeNode getSelectedConfigurationTypeNode() {
        DefaultMutableTreeNode node;
        TreePath selectionPath = this.myTree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = node = selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null;
        while (node != null) {
            Object userObject = node.getUserObject();
            if (userObject instanceof ConfigurationType) {
                return node;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    @NotNull
    private DefaultMutableTreeNode getNode(int row) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getPathForRow(row).getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getNode"));
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    Trinity<Integer, Integer, RowsDnDSupport.RefinedDropSupport.Position> getAvailableDropPosition(int direction) {
        int[] rows = this.myTree.getSelectionRows();
        if (rows == null || rows.length != 1) {
            return null;
        }
        int oldIndex = rows[0];
        if (!RunConfigurable.getKind((DefaultMutableTreeNode)this.myTree.getPathForRow(oldIndex).getLastPathComponent()).supportsDnD()) {
            return null;
        }
        for (int newIndex = oldIndex + direction; newIndex > 0 && newIndex < this.myTree.getRowCount(); newIndex += direction) {
            boolean allowInto;
            TreePath targetPath = this.myTree.getPathForRow(newIndex);
            boolean bl = allowInto = RunConfigurable.getKind((DefaultMutableTreeNode)targetPath.getLastPathComponent()) == NodeKind.FOLDER && !this.myTree.isExpanded(targetPath);
            RowsDnDSupport.RefinedDropSupport.Position position = allowInto && this.myTreeModel.isDropInto((JComponent)this.myTree, oldIndex, newIndex) ? RowsDnDSupport.RefinedDropSupport.Position.INTO : (direction > 0 ? RowsDnDSupport.RefinedDropSupport.Position.BELOW : RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            DefaultMutableTreeNode oldNode = this.getNode(oldIndex);
            DefaultMutableTreeNode newNode = this.getNode(newIndex);
            if (oldNode.getParent() != newNode.getParent() && RunConfigurable.getKind(newNode) != NodeKind.FOLDER) {
                RowsDnDSupport.RefinedDropSupport.Position copy = position;
                if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                    copy = RowsDnDSupport.RefinedDropSupport.Position.ABOVE;
                } else if (position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    copy = RowsDnDSupport.RefinedDropSupport.Position.BELOW;
                }
                if (this.myTreeModel.canDrop(oldIndex, newIndex, copy)) {
                    return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)copy);
                }
            }
            if (this.myTreeModel.canDrop(oldIndex, newIndex, position)) {
                return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)position);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW && newIndex < this.myTree.getRowCount() - 1 && this.myTreeModel.canDrop(oldIndex, newIndex + 1, RowsDnDSupport.RefinedDropSupport.Position.ABOVE)) {
                return Trinity.create((Object)oldIndex, (Object)(newIndex + 1), (Object)RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE && newIndex > 1 && this.myTreeModel.canDrop(oldIndex, newIndex - 1, RowsDnDSupport.RefinedDropSupport.Position.BELOW)) {
                return Trinity.create((Object)oldIndex, (Object)(newIndex - 1), (Object)RowsDnDSupport.RefinedDropSupport.Position.BELOW);
            }
            if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW && this.myTreeModel.canDrop(oldIndex, newIndex, RowsDnDSupport.RefinedDropSupport.Position.ABOVE)) {
                return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)RowsDnDSupport.RefinedDropSupport.Position.ABOVE);
            }
            if (position != RowsDnDSupport.RefinedDropSupport.Position.ABOVE || !this.myTreeModel.canDrop(oldIndex, newIndex, RowsDnDSupport.RefinedDropSupport.Position.BELOW)) continue;
            return Trinity.create((Object)oldIndex, (Object)newIndex, (Object)RowsDnDSupport.RefinedDropSupport.Position.BELOW);
        }
        return null;
    }

    @NotNull
    private static String createUniqueName(DefaultMutableTreeNode typeNode, @Nullable String baseName, NodeKind ... kinds) {
        String str = baseName == null ? ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]) : baseName;
        ArrayList<DefaultMutableTreeNode> configurationNodes = new ArrayList<DefaultMutableTreeNode>();
        RunConfigurable.collectNodesRecursively(typeNode, configurationNodes, kinds);
        ArrayList<String> currentNames = new ArrayList<String>();
        for (DefaultMutableTreeNode node : configurationNodes) {
            Object userObject = node.getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable) {
                currentNames.add(((SingleConfigurationConfigurable)((Object)userObject)).getNameText());
                continue;
            }
            if (userObject instanceof RunnerAndConfigurationSettingsImpl) {
                currentNames.add(((RunnerAndConfigurationSettings)userObject).getName());
                continue;
            }
            if (!(userObject instanceof String)) continue;
            currentNames.add((String)userObject);
        }
        String string = RunManager.suggestUniqueName((String)str, currentNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "createUniqueName"));
        }
        return string;
    }

    private SingleConfigurationConfigurable<RunConfiguration> createNewConfiguration(RunnerAndConfigurationSettings settings, DefaultMutableTreeNode node, DefaultMutableTreeNode selectedNode) {
        SingleConfigurationConfigurable<RunConfiguration> configurationConfigurable = SingleConfigurationConfigurable.editSettings(settings, null);
        this.installUpdateListeners(configurationConfigurable);
        DefaultMutableTreeNode nodeToAdd = new DefaultMutableTreeNode(configurationConfigurable);
        this.myTreeModel.insertNodeInto(nodeToAdd, node, selectedNode != null ? node.getIndex(selectedNode) + 1 : node.getChildCount());
        TreeUtil.selectNode((JTree)this.myTree, (TreeNode)nodeToAdd);
        return configurationConfigurable;
    }

    private void createNewConfiguration(ConfigurationFactory factory) {
        DefaultMutableTreeNode typeNode;
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode selectedNode = null;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        }
        if ((typeNode = this.getConfigurationTypeNode(factory.getType())) == null) {
            typeNode = new DefaultMutableTreeNode(factory.getType());
            this.myRoot.add(typeNode);
            this.sortTopLevelBranches();
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
        node = typeNode;
        if (selectedNode != null && typeNode.isNodeDescendant(selectedNode) && RunConfigurable.getKind(node = selectedNode).isConfiguration()) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        RunnerAndConfigurationSettings settings = this.getRunManager().createConfiguration(RunConfigurable.createUniqueName(typeNode, null, NodeKind.CONFIGURATION, NodeKind.TEMPORARY_CONFIGURATION), factory);
        if (factory instanceof ConfigurationFactoryEx) {
            ((ConfigurationFactoryEx)factory).onNewConfigurationCreated(settings.getConfiguration());
        }
        this.createNewConfiguration(settings, node, selectedNode);
    }

    private int adjustOrder() {
        RunnerAndConfigurationSettings settings;
        int initialPosition;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return 0;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        RunnerAndConfigurationSettings selectedSettings = RunConfigurable.getSettings(treeNode);
        if (selectedSettings == null || selectedSettings.isTemporary()) {
            return 0;
        }
        MutableTreeNode parent = (MutableTreeNode)treeNode.getParent();
        int position = initialPosition = parent.getIndex(treeNode);
        for (DefaultMutableTreeNode node = treeNode.getPreviousSibling(); node != null && (settings = RunConfigurable.getSettings(node)) != null && settings.isTemporary(); node = node.getPreviousSibling()) {
            --position;
        }
        for (int i = 0; i < initialPosition - position; ++i) {
            TreeUtil.moveSelectedRow((JTree)this.myTree, (int)-1);
        }
        return initialPosition - position;
    }

    @Nullable
    private static ConfigurationType getType(DefaultMutableTreeNode node) {
        while (node != null) {
            if (node.getUserObject() instanceof ConfigurationType) {
                return (ConfigurationType)node.getUserObject();
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return null;
    }

    @NotNull
    private DefaultMutableTreeNode[] getSelectedNodes() {
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (defaultMutableTreeNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getSelectedNodes"));
        }
        return defaultMutableTreeNodeArray;
    }

    @Nullable
    private DefaultMutableTreeNode getSelectedNode() {
        DefaultMutableTreeNode[] nodes = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        return nodes.length >= 1 ? nodes[0] : null;
    }

    @Nullable
    private RunnerAndConfigurationSettings getSelectedSettings() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return RunConfigurable.getSettings((DefaultMutableTreeNode)selectionPath.getLastPathComponent());
    }

    @Nullable
    private static RunnerAndConfigurationSettings getSettings(DefaultMutableTreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = null;
        if (treeNode.getUserObject() instanceof SingleConfigurationConfigurable) {
            settings = (RunnerAndConfigurationSettings)((SingleConfigurationConfigurable)((Object)treeNode.getUserObject())).getSettings();
        }
        if (treeNode.getUserObject() instanceof RunnerAndConfigurationSettings) {
            settings = (RunnerAndConfigurationSettings)treeNode.getUserObject();
        }
        return settings;
    }

    @NotNull
    static NodeKind getKind(@Nullable DefaultMutableTreeNode node) {
        if (node == null) {
            NodeKind nodeKind = NodeKind.UNKNOWN;
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
            }
            return nodeKind;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof SingleConfigurationConfigurable || userObject instanceof RunnerAndConfigurationSettings) {
            RunnerAndConfigurationSettings settings = RunConfigurable.getSettings(node);
            if (settings == null) {
                NodeKind nodeKind = NodeKind.UNKNOWN;
                if (nodeKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
                }
                return nodeKind;
            }
            NodeKind nodeKind = settings.isTemporary() ? NodeKind.TEMPORARY_CONFIGURATION : NodeKind.CONFIGURATION;
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
            }
            return nodeKind;
        }
        if (userObject instanceof String) {
            NodeKind nodeKind = NodeKind.FOLDER;
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
            }
            return nodeKind;
        }
        if (userObject instanceof ConfigurationType) {
            NodeKind nodeKind = NodeKind.CONFIGURATION_TYPE;
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
            }
            return nodeKind;
        }
        NodeKind nodeKind = NodeKind.UNKNOWN;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable", "getKind"));
        }
        return nodeKind;
    }

    class MyTreeModel
    extends DefaultTreeModel
    implements EditableModel,
    RowsDnDSupport.RefinedDropSupport {
        private MyTreeModel(TreeNode root) {
            super(root);
        }

        public void addRow() {
        }

        public void removeRow(int index) {
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public boolean canDrop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/impl/RunConfigurable$MyTreeModel", "canDrop"));
            }
            if (RunConfigurable.this.myTree.getRowCount() <= oldIndex || RunConfigurable.this.myTree.getRowCount() <= newIndex || oldIndex < 0 || newIndex < 0) {
                return false;
            }
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)RunConfigurable.this.myTree.getPathForRow(oldIndex).getLastPathComponent();
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)RunConfigurable.this.myTree.getPathForRow(newIndex).getLastPathComponent();
            DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)oldNode.getParent();
            DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)newNode.getParent();
            NodeKind oldKind = RunConfigurable.getKind(oldNode);
            NodeKind newKind = RunConfigurable.getKind(newNode);
            ConfigurationType oldType = this.getType(oldNode);
            ConfigurationType newType = this.getType(newNode);
            if (oldParent == newParent) {
                if (oldNode.getPreviousSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                    return false;
                }
                if (oldNode.getNextSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    return false;
                }
            }
            if (oldType == null) {
                return false;
            }
            if (oldType != newType) {
                DefaultMutableTreeNode typeNode = RunConfigurable.this.getConfigurationTypeNode(oldType);
                if (RunConfigurable.getKind(oldParent) == NodeKind.FOLDER && typeNode != null && typeNode.getNextSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                    return true;
                }
                return RunConfigurable.getKind(oldParent) == NodeKind.CONFIGURATION_TYPE && oldKind == NodeKind.FOLDER && typeNode != null && typeNode.getNextSibling() == newNode && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE && oldParent.getLastChild() != oldNode && RunConfigurable.getKind((DefaultMutableTreeNode)oldParent.getLastChild()) == NodeKind.FOLDER;
            }
            if (newParent == oldNode || oldParent == newNode) {
                return false;
            }
            if (oldKind == NodeKind.FOLDER && newKind != NodeKind.FOLDER) {
                return newKind.isConfiguration() && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE && RunConfigurable.getKind(newParent) == NodeKind.CONFIGURATION_TYPE && newIndex > 1 && RunConfigurable.getKind((DefaultMutableTreeNode)RunConfigurable.this.myTree.getPathForRow(newIndex - 1).getParentPath().getLastPathComponent()) == NodeKind.FOLDER;
            }
            if (!oldKind.supportsDnD() || !newKind.supportsDnD()) {
                return false;
            }
            if (oldKind.isConfiguration() && newKind == NodeKind.FOLDER && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                return false;
            }
            if (oldKind == NodeKind.TEMPORARY_CONFIGURATION && newKind == NodeKind.CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                return false;
            }
            if (oldKind == NodeKind.CONFIGURATION && newKind == NodeKind.TEMPORARY_CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                return false;
            }
            if (oldKind == NodeKind.CONFIGURATION && newKind == NodeKind.TEMPORARY_CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE) {
                return newNode.getPreviousSibling() == null || RunConfigurable.getKind(newNode.getPreviousSibling()) == NodeKind.CONFIGURATION || RunConfigurable.getKind(newNode.getPreviousSibling()) == NodeKind.FOLDER;
            }
            if (oldKind == NodeKind.TEMPORARY_CONFIGURATION && newKind == NodeKind.CONFIGURATION && position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                return newNode.getNextSibling() == null || RunConfigurable.getKind(newNode.getNextSibling()) == NodeKind.TEMPORARY_CONFIGURATION;
            }
            if (oldParent == newParent) {
                if (oldKind.isConfiguration() && newKind.isConfiguration()) {
                    return oldKind == newKind;
                }
                if (oldKind == NodeKind.FOLDER) {
                    return !RunConfigurable.this.myTree.isExpanded(newIndex) || position == RowsDnDSupport.RefinedDropSupport.Position.ABOVE;
                }
            }
            return true;
        }

        public boolean isDropInto(JComponent component, int oldIndex, int newIndex) {
            TreePath oldPath = RunConfigurable.this.myTree.getPathForRow(oldIndex);
            TreePath newPath = RunConfigurable.this.myTree.getPathForRow(newIndex);
            if (oldPath == null || newPath == null) {
                return false;
            }
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)oldPath.getLastPathComponent();
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)newPath.getLastPathComponent();
            return RunConfigurable.getKind(oldNode).isConfiguration() && RunConfigurable.getKind(newNode) == NodeKind.FOLDER;
        }

        public void drop(int oldIndex, int newIndex, @NotNull RowsDnDSupport.RefinedDropSupport.Position position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/impl/RunConfigurable$MyTreeModel", "drop"));
            }
            DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)RunConfigurable.this.myTree.getPathForRow(oldIndex).getLastPathComponent();
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)RunConfigurable.this.myTree.getPathForRow(newIndex).getLastPathComponent();
            DefaultMutableTreeNode newParent = (DefaultMutableTreeNode)newNode.getParent();
            NodeKind oldKind = RunConfigurable.getKind(oldNode);
            boolean wasExpanded = RunConfigurable.this.myTree.isExpanded(new TreePath(oldNode.getPath()));
            if (this.isDropInto((JComponent)RunConfigurable.this.myTree, oldIndex, newIndex)) {
                this.removeNodeFromParent(oldNode);
                int index = newNode.getChildCount();
                if (oldKind.isConfiguration()) {
                    int middleIndex = newNode.getChildCount();
                    for (int i = 0; i < newNode.getChildCount(); ++i) {
                        if (RunConfigurable.getKind((DefaultMutableTreeNode)newNode.getChildAt(i)) != NodeKind.TEMPORARY_CONFIGURATION) continue;
                        middleIndex = i;
                        break;
                    }
                    index = position != RowsDnDSupport.RefinedDropSupport.Position.INTO ? (oldIndex < newIndex ? (oldKind == NodeKind.CONFIGURATION ? 0 : middleIndex) : (oldKind == NodeKind.CONFIGURATION ? middleIndex : newNode.getChildCount())) : (oldKind == NodeKind.TEMPORARY_CONFIGURATION ? newNode.getChildCount() : middleIndex);
                }
                this.insertNodeInto(oldNode, newNode, index);
                RunConfigurable.this.myTree.expandPath(new TreePath(newNode.getPath()));
            } else {
                int index;
                ConfigurationType type = this.getType(oldNode);
                assert (type != null);
                this.removeNodeFromParent(oldNode);
                if (type != this.getType(newNode)) {
                    DefaultMutableTreeNode typeNode = RunConfigurable.this.getConfigurationTypeNode(type);
                    assert (typeNode != null);
                    newParent = typeNode;
                    index = newParent.getChildCount();
                } else {
                    index = newParent.getIndex(newNode);
                    if (position == RowsDnDSupport.RefinedDropSupport.Position.BELOW) {
                        ++index;
                    }
                }
                this.insertNodeInto(oldNode, newParent, index);
            }
            TreePath treePath = new TreePath(oldNode.getPath());
            RunConfigurable.this.myTree.setSelectionPath(treePath);
            if (wasExpanded) {
                RunConfigurable.this.myTree.expandPath(treePath);
            }
        }

        @Override
        public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
            String newFolderName;
            super.insertNodeInto(newChild, parent, index);
            if (!RunConfigurable.getKind((DefaultMutableTreeNode)newChild).isConfiguration()) {
                return;
            }
            Object userObject = RunConfigurable.this.getSafeUserObject((DefaultMutableTreeNode)newChild);
            String string = newFolderName = RunConfigurable.getKind((DefaultMutableTreeNode)parent) == NodeKind.FOLDER ? (String)((DefaultMutableTreeNode)parent).getUserObject() : null;
            if (userObject instanceof SingleConfigurationConfigurable) {
                ((SingleConfigurationConfigurable)((Object)userObject)).setFolderName(newFolderName);
            }
        }

        @Override
        public void reload(TreeNode node) {
            super.reload(node);
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            if (userObject instanceof String) {
                String folderName = (String)userObject;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    Object safeUserObject = RunConfigurable.this.getSafeUserObject(child);
                    if (!(safeUserObject instanceof SingleConfigurationConfigurable)) continue;
                    ((SingleConfigurationConfigurable)((Object)safeUserObject)).setFolderName(folderName);
                }
            }
        }

        @Nullable
        private RunnerAndConfigurationSettings getSettings(@NotNull DefaultMutableTreeNode treeNode) {
            if (treeNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNode", "com/intellij/execution/impl/RunConfigurable$MyTreeModel", "getSettings"));
            }
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable) {
                SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)userObject);
                return (RunnerAndConfigurationSettings)configurable.getSettings();
            }
            if (userObject instanceof RunnerAndConfigurationSettings) {
                return (RunnerAndConfigurationSettings)userObject;
            }
            return null;
        }

        @Nullable
        private ConfigurationType getType(@Nullable DefaultMutableTreeNode treeNode) {
            if (treeNode == null) {
                return null;
            }
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof SingleConfigurationConfigurable) {
                SingleConfigurationConfigurable configurable = (SingleConfigurationConfigurable)((Object)userObject);
                return configurable.getConfiguration().getType();
            }
            if (userObject instanceof RunnerAndConfigurationSettings) {
                return ((RunnerAndConfigurationSettings)userObject).getType();
            }
            if (userObject instanceof ConfigurationType) {
                return (ConfigurationType)userObject;
            }
            if (treeNode.getParent() instanceof DefaultMutableTreeNode) {
                return this.getType((DefaultMutableTreeNode)treeNode.getParent());
            }
            return null;
        }
    }

    static enum NodeKind {
        CONFIGURATION_TYPE,
        FOLDER,
        CONFIGURATION,
        TEMPORARY_CONFIGURATION,
        UNKNOWN;


        boolean supportsDnD() {
            return this == FOLDER || this == CONFIGURATION || this == TEMPORARY_CONFIGURATION;
        }

        boolean isConfiguration() {
            return this == CONFIGURATION | this == TEMPORARY_CONFIGURATION;
        }
    }

    public static interface RunDialogBase {
        public void setOKActionEnabled(boolean var1);

        @Nullable
        public Executor getExecutor();

        public void setTitle(String var1);

        public void clickDefaultButton();
    }

    private static class RunConfigurationBean {
        private final RunnerAndConfigurationSettings mySettings;
        private final boolean myShared;
        private final List<BeforeRunTask> myStepsBeforeLaunch;
        private final SingleConfigurationConfigurable myConfigurable;

        public RunConfigurationBean(RunnerAndConfigurationSettings settings, boolean shared, List<BeforeRunTask> stepsBeforeLaunch) {
            this.mySettings = settings;
            this.myShared = shared;
            this.myStepsBeforeLaunch = Collections.unmodifiableList(stepsBeforeLaunch);
            this.myConfigurable = null;
        }

        public RunConfigurationBean(SingleConfigurationConfigurable configurable) {
            this.myConfigurable = configurable;
            this.mySettings = (RunnerAndConfigurationSettings)this.myConfigurable.getSettings();
            ConfigurationSettingsEditorWrapper editorWrapper = (ConfigurationSettingsEditorWrapper)this.myConfigurable.getEditor();
            this.myShared = configurable.isStoreProjectConfiguration();
            this.myStepsBeforeLaunch = editorWrapper.getStepsBeforeLaunch();
        }

        public RunnerAndConfigurationSettings getSettings() {
            return this.mySettings;
        }

        public boolean isShared() {
            return this.myShared;
        }

        public List<BeforeRunTask> getStepsBeforeLaunch() {
            return this.myStepsBeforeLaunch;
        }

        public SingleConfigurationConfigurable getConfigurable() {
            return this.myConfigurable;
        }

        public String toString() {
            return String.valueOf(this.mySettings);
        }
    }

    private class MySortFolderAction
    extends AnAction
    implements Comparator<DefaultMutableTreeNode> {
        private MySortFolderAction() {
            super(ExecutionBundle.message((String)"run.configuration.sort.folder.text", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.sort.folder.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        @Override
        public int compare(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
            NodeKind kind1 = RunConfigurable.getKind(node1);
            NodeKind kind2 = RunConfigurable.getKind(node2);
            if (kind1 == NodeKind.FOLDER) {
                return kind2 == NodeKind.FOLDER ? node1.getParent().getIndex(node1) - node2.getParent().getIndex(node2) : -1;
            }
            if (kind2 == NodeKind.FOLDER) {
                return 1;
            }
            String name1 = RunConfigurable.getName(node1.getUserObject());
            String name2 = RunConfigurable.getName(node2.getUserObject());
            if (kind1 == NodeKind.TEMPORARY_CONFIGURATION) {
                return kind2 == NodeKind.TEMPORARY_CONFIGURATION ? name1.compareTo(name2) : 1;
            }
            if (kind2 == NodeKind.TEMPORARY_CONFIGURATION) {
                return -1;
            }
            return name1.compareTo(name2);
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            ArrayList<DefaultMutableTreeNode> foldersToSort = new ArrayList<DefaultMutableTreeNode>();
            for (DefaultMutableTreeNode node : selectedNodes) {
                NodeKind kind = RunConfigurable.getKind(node);
                if (kind != NodeKind.CONFIGURATION_TYPE && kind != NodeKind.FOLDER) continue;
                foldersToSort.add(node);
            }
            for (DefaultMutableTreeNode folderNode : foldersToSort) {
                ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                for (int i = 0; i < folderNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)folderNode.getChildAt(i);
                    children.add(child);
                }
                Collections.sort(children, this);
                for (DefaultMutableTreeNode child : children) {
                    folderNode.add(child);
                }
                RunConfigurable.this.myTreeModel.nodeStructureChanged(folderNode);
            }
        }

        public void update(AnActionEvent e) {
            DefaultMutableTreeNode[] selectedNodes;
            for (DefaultMutableTreeNode node : selectedNodes = RunConfigurable.this.getSelectedNodes()) {
                NodeKind kind = RunConfigurable.getKind(node);
                if (kind != NodeKind.CONFIGURATION_TYPE && kind != NodeKind.FOLDER) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }
    }

    private class MyCreateFolderAction
    extends AnAction {
        private MyCreateFolderAction() {
            super(ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.create.folder.description", (Object[])new Object[0]), AllIcons.Nodes.Folder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(AnActionEvent e) {
            ConfigurationType type = RunConfigurable.this.getSelectedConfigurationType();
            if (type == null) {
                return;
            }
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            DefaultMutableTreeNode typeNode = RunConfigurable.this.getConfigurationTypeNode(type);
            if (typeNode == null) {
                return;
            }
            String folderName = RunConfigurable.createUniqueName(typeNode, "New Folder", new NodeKind[]{NodeKind.FOLDER});
            ArrayList<DefaultMutableTreeNode> folders = new ArrayList<DefaultMutableTreeNode>();
            RunConfigurable.collectNodesRecursively(RunConfigurable.this.getConfigurationTypeNode(type), folders, NodeKind.FOLDER);
            DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(folderName);
            RunConfigurable.this.myTreeModel.insertNodeInto(folderNode, typeNode, folders.size());
            RunConfigurable.this.isFolderCreating = true;
            try {
                for (DefaultMutableTreeNode node : selectedNodes) {
                    int folderRow = RunConfigurable.this.myTree.getRowForPath(new TreePath(folderNode.getPath()));
                    int rowForPath = RunConfigurable.this.myTree.getRowForPath(new TreePath(node.getPath()));
                    if (!RunConfigurable.getKind(node).isConfiguration() || !RunConfigurable.this.myTreeModel.canDrop(rowForPath, folderRow, RowsDnDSupport.RefinedDropSupport.Position.INTO)) continue;
                    RunConfigurable.this.myTreeModel.drop(rowForPath, folderRow, RowsDnDSupport.RefinedDropSupport.Position.INTO);
                }
                RunConfigurable.this.myTree.setSelectionPath(new TreePath(folderNode.getPath()));
            }
            finally {
                RunConfigurable.this.isFolderCreating = false;
            }
        }

        public void update(AnActionEvent e) {
            boolean isEnabled = false;
            boolean toMove = false;
            DefaultMutableTreeNode[] selectedNodes = RunConfigurable.this.getSelectedNodes();
            ConfigurationType selectedType = null;
            for (DefaultMutableTreeNode node : selectedNodes) {
                ConfigurationType type = RunConfigurable.getType(node);
                if (selectedType == null) {
                    selectedType = type;
                } else if (!Comparing.equal((Object)type, (Object)selectedType)) {
                    isEnabled = false;
                    break;
                }
                NodeKind kind = RunConfigurable.getKind(node);
                if (kind.isConfiguration() || kind == NodeKind.CONFIGURATION_TYPE && node.getParent() == RunConfigurable.this.myRoot || kind == NodeKind.FOLDER) {
                    isEnabled = true;
                }
                if (!kind.isConfiguration()) continue;
                toMove = true;
            }
            e.getPresentation().setText(ExecutionBundle.message((String)("run.configuration.create.folder.description" + (toMove ? ".move" : "")), (Object[])new Object[0]));
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private class MyEditDefaultsAction
    extends AnAction {
        public MyEditDefaultsAction() {
            super(ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.text", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.description", (Object[])new Object[0]), AllIcons.General.Settings);
        }

        public void actionPerformed(AnActionEvent e) {
            TreeNode defaults = TreeUtil.findNodeWithObject((Object)DEFAULTS, (TreeModel)RunConfigurable.this.myTree.getModel(), (Object)RunConfigurable.this.myRoot);
            if (defaults != null) {
                DefaultMutableTreeNode defaultsNode;
                ConfigurationType configurationType = RunConfigurable.this.getSelectedConfigurationType();
                if (configurationType != null) {
                    defaults = TreeUtil.findNodeWithObject((Object)configurationType, (TreeModel)RunConfigurable.this.myTree.getModel(), (Object)defaults);
                }
                if ((defaultsNode = (DefaultMutableTreeNode)defaults) == null) {
                    return;
                }
                TreePath path = TreeUtil.getPath((TreeNode)RunConfigurable.this.myRoot, (TreeNode)defaultsNode);
                RunConfigurable.this.myTree.expandPath(path);
                TreeUtil.selectInTree((DefaultMutableTreeNode)defaultsNode, (boolean)true, (JTree)RunConfigurable.this.myTree);
                RunConfigurable.this.myTree.scrollPathToVisible(path);
            }
        }

        public void update(AnActionEvent e) {
            boolean isEnabled = TreeUtil.findNodeWithObject((Object)DEFAULTS, (TreeModel)RunConfigurable.this.myTree.getModel(), (Object)RunConfigurable.this.myRoot) != null;
            TreePath path = RunConfigurable.this.myTree.getSelectionPath();
            if (path != null) {
                Object o = path.getLastPathComponent();
                if (o instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)o).getUserObject().equals(DEFAULTS)) {
                    isEnabled = false;
                }
                if ((o = path.getParentPath().getLastPathComponent()) instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)o).getUserObject().equals(DEFAULTS)) {
                    isEnabled = false;
                }
            }
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private class MyMoveAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private final int myDirection;

        protected MyMoveAction(String text, String description, Icon icon, int direction) {
            super(text, description, icon);
            this.myDirection = direction;
        }

        public void actionPerformed(AnActionEvent e) {
            this.doMove();
        }

        private void doMove() {
            Trinity<Integer, Integer, RowsDnDSupport.RefinedDropSupport.Position> dropPosition = RunConfigurable.this.getAvailableDropPosition(this.myDirection);
            if (dropPosition != null) {
                RunConfigurable.this.myTreeModel.drop((Integer)dropPosition.first, (Integer)dropPosition.second, (RowsDnDSupport.RefinedDropSupport.Position)dropPosition.third);
            }
        }

        public void run(AnActionButton button) {
            this.doMove();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled(e));
        }

        public boolean isEnabled(AnActionEvent e) {
            return RunConfigurable.this.getAvailableDropPosition(this.myDirection) != null;
        }
    }

    private class MySaveAction
    extends AnAction {
        public MySaveAction() {
            super(ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), null, AllIcons.Actions.Menu_saveall);
        }

        public void actionPerformed(AnActionEvent e) {
            SingleConfigurationConfigurable configurationConfigurable = RunConfigurable.this.getSelectedConfiguration();
            LOG.assertTrue(configurationConfigurable != null);
            try {
                configurationConfigurable.apply();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            RunnerAndConfigurationSettings originalConfiguration = (RunnerAndConfigurationSettings)configurationConfigurable.getSettings();
            if (originalConfiguration.isTemporary()) {
                RunConfigurable.this.getRunManager().makeStable(originalConfiguration);
                RunConfigurable.this.adjustOrder();
            }
            RunConfigurable.this.myTree.repaint();
        }

        public void update(AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            Presentation presentation = e.getPresentation();
            boolean enabled = configuration == null ? false : (settings = (RunnerAndConfigurationSettings)configuration.getSettings()) != null && settings.isTemporary();
            presentation.setEnabled(enabled);
            presentation.setVisible(enabled);
        }
    }

    private class MyCopyAction
    extends AnAction {
        public MyCopyAction() {
            super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
            AnAction action = ActionManager.getInstance().getAction("EditorDuplicate");
            this.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            LOG.assertTrue(configuration != null);
            try {
                DefaultMutableTreeNode typeNode = RunConfigurable.this.getSelectedConfigurationTypeNode();
                RunnerAndConfigurationSettings settings = configuration.getSnapshot();
                String copyName = RunConfigurable.createUniqueName(typeNode, configuration.getNameText(), new NodeKind[]{NodeKind.CONFIGURATION, NodeKind.TEMPORARY_CONFIGURATION});
                settings.setName(copyName);
                ConfigurationFactory factory = settings.getFactory();
                if (factory instanceof ConfigurationFactoryEx) {
                    ((ConfigurationFactoryEx)factory).onConfigurationCopied(settings.getConfiguration());
                }
                SingleConfigurationConfigurable configurable = RunConfigurable.this.createNewConfiguration(settings, typeNode, RunConfigurable.this.getSelectedNode());
                IdeFocusManager.getInstance((Project)RunConfigurable.this.myProject).requestFocus((Component)configurable.getNameTextField(), true);
                configurable.getNameTextField().setSelectionStart(0);
                configurable.getNameTextField().setSelectionEnd(copyName.length());
            }
            catch (ConfigurationException e1) {
                Messages.showErrorDialog((Component)RunConfigurable.this.myToolbarDecorator.getActionsPanel(), (String)e1.getMessage(), (String)e1.getTitle());
            }
        }

        public void update(AnActionEvent e) {
            SingleConfigurationConfigurable configuration = RunConfigurable.this.getSelectedConfiguration();
            e.getPresentation().setEnabled(configuration != null && !(configuration.getConfiguration() instanceof UnknownRunConfiguration));
        }
    }

    private class MyRemoveAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        public MyRemoveAction() {
            super(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), REMOVE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            this.doRemove();
        }

        public void run(AnActionButton button) {
            this.doRemove();
        }

        private void doRemove() {
            TreePath[] selections = RunConfigurable.this.myTree.getSelectionPaths();
            RunConfigurable.this.myTree.clearSelection();
            int nodeIndexToSelect = -1;
            DefaultMutableTreeNode parentToSelect = null;
            HashSet<DefaultMutableTreeNode> changedParents = new HashSet<DefaultMutableTreeNode>();
            boolean wasRootChanged = false;
            for (TreePath each : selections) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)each.getLastPathComponent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                NodeKind kind = RunConfigurable.getKind(node);
                if (!kind.isConfiguration() && kind != NodeKind.FOLDER) continue;
                if (node.getUserObject() instanceof SingleConfigurationConfigurable) {
                    ((SingleConfigurationConfigurable)((Object)node.getUserObject())).disposeUIResources();
                }
                nodeIndexToSelect = parent.getIndex(node);
                parentToSelect = parent;
                RunConfigurable.this.myTreeModel.removeNodeFromParent(node);
                changedParents.add(parent);
                if (kind == NodeKind.FOLDER) {
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                        Object userObject = RunConfigurable.this.getSafeUserObject(child);
                        if (userObject instanceof SingleConfigurationConfigurable) {
                            ((SingleConfigurationConfigurable)((Object)userObject)).setFolderName(null);
                        }
                        children.add(0, child);
                    }
                    int confIndex = 0;
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        if (!RunConfigurable.getKind((DefaultMutableTreeNode)parent.getChildAt(i)).isConfiguration()) continue;
                        confIndex = i;
                        break;
                    }
                    for (DefaultMutableTreeNode child : children) {
                        if (RunConfigurable.getKind(child) != NodeKind.CONFIGURATION) continue;
                        RunConfigurable.this.myTreeModel.insertNodeInto(child, parent, confIndex);
                    }
                    confIndex = parent.getChildCount();
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        if (RunConfigurable.getKind((DefaultMutableTreeNode)parent.getChildAt(i)) != NodeKind.TEMPORARY_CONFIGURATION) continue;
                        confIndex = i;
                        break;
                    }
                    for (DefaultMutableTreeNode child : children) {
                        if (RunConfigurable.getKind(child) != NodeKind.TEMPORARY_CONFIGURATION) continue;
                        RunConfigurable.this.myTreeModel.insertNodeInto(child, parent, confIndex);
                    }
                }
                if (parent.getChildCount() != 0 || !(parent.getUserObject() instanceof ConfigurationType)) continue;
                changedParents.remove(parent);
                wasRootChanged = true;
                nodeIndexToSelect = RunConfigurable.this.myRoot.getIndex(parent);
                nodeIndexToSelect = Math.max(0, nodeIndexToSelect - 1);
                parentToSelect = RunConfigurable.this.myRoot;
                parent.removeFromParent();
            }
            if (wasRootChanged) {
                ((DefaultTreeModel)RunConfigurable.this.myTree.getModel()).reload();
            } else {
                for (DefaultMutableTreeNode each : changedParents) {
                    RunConfigurable.this.myTreeModel.reload(each);
                    RunConfigurable.this.myTree.expandPath(new TreePath(each));
                }
            }
            RunConfigurable.this.mySelectedConfigurable = null;
            if (RunConfigurable.this.myRoot.getChildCount() == 0) {
                RunConfigurable.this.drawPressAddButtonMessage(null);
            } else if (parentToSelect.getChildCount() > 0) {
                TreeNode nodeToSelect = nodeIndexToSelect < parentToSelect.getChildCount() ? parentToSelect.getChildAt(nodeIndexToSelect) : parentToSelect.getChildAt(nodeIndexToSelect - 1);
                TreeUtil.selectInTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)nodeToSelect), (boolean)true, (JTree)RunConfigurable.this.myTree);
            }
        }

        public void update(AnActionEvent e) {
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isEnabled(AnActionEvent e) {
            boolean enabled = false;
            TreePath[] selections = RunConfigurable.this.myTree.getSelectionPaths();
            if (selections != null) {
                for (TreePath each : selections) {
                    NodeKind kind = RunConfigurable.getKind((DefaultMutableTreeNode)each.getLastPathComponent());
                    if (!kind.isConfiguration() && kind != NodeKind.FOLDER) continue;
                    enabled = true;
                    break;
                }
            }
            return enabled;
        }
    }

    private class MyToolbarAddAction
    extends AnAction
    implements AnActionButtonRunnable {
        public MyToolbarAddAction() {
            super(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), ADD_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RunConfigurable.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            this.showAddPopup(true);
        }

        public void run(AnActionButton button) {
            this.showAddPopup(true);
        }

        private void showAddPopup(boolean showApplicableTypesOnly) {
            ConfigurationType[] allTypes = RunConfigurable.this.getRunManager().getConfigurationFactories(false);
            final List<ConfigurationType> configurationTypes = this.getTypesToShow(showApplicableTypesOnly, allTypes);
            Collections.sort(configurationTypes, new Comparator<ConfigurationType>(){

                @Override
                public int compare(ConfigurationType type1, ConfigurationType type2) {
                    return type1.getDisplayName().compareToIgnoreCase(type2.getDisplayName());
                }
            });
            final int hiddenCount = allTypes.length - configurationTypes.size();
            if (hiddenCount > 0) {
                configurationTypes.add(null);
            }
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationType>(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), configurationTypes){

                @NotNull
                public String getTextFor(ConfigurationType type) {
                    String string = type != null ? type.getDisplayName() : hiddenCount + " items more (irrelevant)...";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable$MyToolbarAddAction$2", "getTextFor"));
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public boolean canBeHidden(ConfigurationType value) {
                    return true;
                }

                public Icon getIconFor(ConfigurationType type) {
                    return type != null ? type.getIcon() : EmptyIcon.ICON_16;
                }

                public PopupStep onChosen(ConfigurationType type, boolean finalChoice) {
                    if (this.hasSubstep(type)) {
                        return this.getSupStep(type);
                    }
                    if (type == null) {
                        return this.doFinalStep(new Runnable(){

                            @Override
                            public void run() {
                                MyToolbarAddAction.this.showAddPopup(false);
                            }
                        });
                    }
                    ConfigurationFactory[] factories = type.getConfigurationFactories();
                    if (factories.length > 0) {
                        RunConfigurable.this.createNewConfiguration(factories[0]);
                    }
                    return FINAL_CHOICE;
                }

                public int getDefaultOptionIndex() {
                    ConfigurationType type = RunConfigurable.this.getSelectedConfigurationType();
                    return type != null ? configurationTypes.indexOf(type) : super.getDefaultOptionIndex();
                }

                private ListPopupStep getSupStep(ConfigurationType type) {
                    ConfigurationFactory[] factories = type.getConfigurationFactories();
                    Arrays.sort(factories, new Comparator<ConfigurationFactory>(){

                        @Override
                        public int compare(ConfigurationFactory factory1, ConfigurationFactory factory2) {
                            return factory1.getName().compareToIgnoreCase(factory2.getName());
                        }
                    });
                    return new BaseListPopupStep<ConfigurationFactory>(ExecutionBundle.message((String)"add.new.run.configuration.action.name", (Object[])new Object[]{type.getDisplayName()}), factories){

                        @NotNull
                        public String getTextFor(ConfigurationFactory value) {
                            String string = value.getName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/RunConfigurable$MyToolbarAddAction$2$3", "getTextFor"));
                            }
                            return string;
                        }

                        public Icon getIconFor(ConfigurationFactory factory) {
                            return factory.getIcon();
                        }

                        public PopupStep onChosen(ConfigurationFactory factory, boolean finalChoice) {
                            RunConfigurable.this.createNewConfiguration(factory);
                            return FINAL_CHOICE;
                        }
                    };
                }

                public boolean hasSubstep(ConfigurationType type) {
                    return type != null && type.getConfigurationFactories().length > 1;
                }
            });
            popup.showUnderneathOf((Component)RunConfigurable.this.myToolbarDecorator.getActionsPanel());
        }

        private List<ConfigurationType> getTypesToShow(boolean showApplicableTypesOnly, ConfigurationType[] allTypes) {
            if (showApplicableTypesOnly) {
                ArrayList<ConfigurationType> applicableTypes = new ArrayList<ConfigurationType>();
                for (ConfigurationType type : allTypes) {
                    if (!this.isApplicable(type)) continue;
                    applicableTypes.add(type);
                }
                if (applicableTypes.size() < allTypes.length - 3) {
                    return applicableTypes;
                }
            }
            return new ArrayList<ConfigurationType>(Arrays.asList(allTypes));
        }

        private boolean isApplicable(ConfigurationType type) {
            for (ConfigurationFactory factory : type.getConfigurationFactories()) {
                if (!factory.isApplicable(RunConfigurable.this.myProject)) continue;
                return true;
            }
            return false;
        }
    }
}

