/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorAction
extends AnAction {
    public static AnAction[] ACTIONS = (AnAction[])ContainerUtil.map2Array((Object[])ExecutorRegistry.getInstance().getRegisteredExecutors(), AnAction.class, (Function)new Function<Executor, AnAction>(){

        public AnAction fun(Executor executor) {
            return new ExecutorAction(ActionManager.getInstance().getAction(executor.getContextActionId()), executor);
        }
    });
    private final AnAction myOrigin;
    private final Executor myExecutor;

    private ExecutorAction(AnAction origin, Executor executor) {
        this.myOrigin = origin;
        this.myExecutor = executor;
        this.copyFrom(origin);
    }

    public void update(AnActionEvent e) {
        String name = ExecutorAction.getActionName(e.getDataContext(), this.myExecutor);
        e.getPresentation().setVisible(name != null);
        e.getPresentation().setText(name);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myOrigin.actionPerformed(e);
    }

    private static String getActionName(DataContext dataContext, @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/lineMarker/ExecutorAction", "getActionName"));
        }
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        List producers = RunConfigurationProducer.getProducers((Project)context.getProject());
        List list = ContainerUtil.mapNotNull((Collection)producers, (Function)new Function<RunConfigurationProducer<?>, ConfigurationFromContext>(){

            public ConfigurationFromContext fun(RunConfigurationProducer<?> producer) {
                return ExecutorAction.createConfiguration(producer, context);
            }
        });
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, ConfigurationFromContext.COMPARATOR);
        String actionName = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)((ConfigurationFromContext)list.get(0)).getConfiguration());
        return executor.getStartActionText(actionName);
    }

    @Nullable
    private static ConfigurationFromContext createConfiguration(RunConfigurationProducer<?> producer, ConfigurationContext context) {
        RunConfiguration configuration = producer.createLightConfiguration(context);
        if (configuration == null) {
            return null;
        }
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl(context.getProject()), configuration, false);
        return new ConfigurationFromContextImpl(producer, (RunnerAndConfigurationSettings)settings, context.getPsiLocation());
    }
}

