/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "getLineMarkerInfo"));
        }
        List contributors = RunLineMarkerContributor.EXTENSION.allForLanguage(element.getLanguage());
        final DefaultActionGroup actionGroup = new DefaultActionGroup();
        Icon icon = null;
        for (RunLineMarkerContributor contributor : contributors) {
            RunLineMarkerContributor.Info info = contributor.getInfo(element);
            if (info == null) continue;
            if (icon == null) {
                icon = info.icon;
            }
            for (AnAction action : info.actions) {
                actionGroup.add((AnAction)new LineMarkerActionWrapper(element, action));
            }
            actionGroup.add((AnAction)new Separator());
        }
        if (icon == null) {
            return null;
        }
        return new LineMarkerInfo<PsiElement>(element, element.getTextOffset(), icon, 4, null, null){

            @Nullable
            public GutterIconRenderer createGutterRenderer() {
                return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                    public AnAction getClickAction() {
                        return null;
                    }

                    public boolean isNavigateAction() {
                        return true;
                    }

                    @Nullable
                    public ActionGroup getPopupMenuActions() {
                        return actionGroup;
                    }
                };
            }
        };
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }
}

