/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupConfiguration;
import com.intellij.execution.startup.ProjectStartupTasksTreeModel;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private Tree myTree;
    private ProjectStartupConfiguration myConfiguration;
    private ToolbarDecorator myDecorator;
    private JBCheckBox mySharedCheckBox;

    public ProjectStartupConfigurable(Project project) {
        this.myProject = project;
        this.myConfiguration = ProjectStartupConfiguration.getInstance(this.myProject);
    }

    @NotNull
    public String getId() {
        if ("preferences.startup.tasks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurable", "getId"));
        }
        return "preferences.startup.tasks";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Startup Tasks";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.myTree = new Tree();
        this.installRenderer();
        this.myDecorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.selectAndAddConfiguration(button);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(AnActionButton button) {
                RunnerAndConfigurationSettings selected = ProjectStartupConfigurable.this.getSelectedSettings();
                if (selected == null) {
                    return;
                }
                RunManager runManager = RunManagerImpl.getInstance((Project)ProjectStartupConfigurable.this.myProject);
                RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
                try {
                    runManager.setSelectedConfiguration(selected);
                    new EditConfigurationsDialog(ProjectStartupConfigurable.this.myProject).showAndGet();
                }
                finally {
                    runManager.setSelectedConfiguration(was);
                }
                ProjectStartupConfigurable.this.setModel(new ProjectStartupTasksTreeModel(((ProjectStartupTasksTreeModel)ProjectStartupConfigurable.this.myTree.getModel()).getConfigurations()));
                ProjectStartupConfigurable.this.selectPathOrFirst(selected);
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ProjectStartupConfigurable.this.getSelectedSettings() != null;
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                RunnerAndConfigurationSettings selected = ProjectStartupConfigurable.this.getSelectedSettings();
                if (selected == null) {
                    return;
                }
                ProjectStartupTasksTreeModel oldModel = (ProjectStartupTasksTreeModel)ProjectStartupConfigurable.this.myTree.getModel();
                List<RunnerAndConfigurationSettings> configurations = oldModel.getConfigurations();
                if (!configurations.contains(selected)) {
                    return;
                }
                configurations.remove(selected);
                Collections.sort(configurations, new Comparator<RunnerAndConfigurationSettings>(){

                    @Override
                    public int compare(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                ProjectStartupConfigurable.this.setModel(new ProjectStartupTasksTreeModel(configurations));
                ProjectStartupConfigurable.this.selectPathOrFirst(null);
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        JPanel tasksPanel = this.myDecorator.createPanel();
        this.mySharedCheckBox = new JBCheckBox("Share");
        this.mySharedCheckBox.setMnemonic('s');
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.mySharedCheckBox, "East");
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)new JLabel("Tasks to be executed right after opening the project."), (JComponent)panel).addComponentFillVertically((JComponent)tasksPanel, 2).getPanel();
    }

    private void selectPathOrFirst(RunnerAndConfigurationSettings settings) {
        if (this.myTree.isEmpty()) {
            return;
        }
        this.myTree.clearSelection();
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = ((ProjectStartupTasksTreeModel)this.myTree.getModel()).getConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                RunnerAndConfigurationSettings configuration = configurations.get(i);
                if (configuration != settings) continue;
                this.myTree.setSelectionRow(i);
                return;
            }
        }
        this.myTree.addSelectionRow(0);
    }

    @Nullable
    private RunnerAndConfigurationSettings getSelectedSettings() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (!(path.getLastPathComponent() instanceof RunnerAndConfigurationSettings)) {
            return null;
        }
        return (RunnerAndConfigurationSettings)path.getLastPathComponent();
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createEditWrapper() {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.EditSource;
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
            }

            @Override
            public void perform(final @NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$5", "perform"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/startup/ProjectStartupConfigurable$5", "perform"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/startup/ProjectStartupConfigurable$5", "perform"));
                }
                if (new EditConfigurationsDialog(project).showAndGet()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                            if (configuration != null) {
                                ProjectStartupConfigurable.this.addConfigurationToList(configuration);
                                ProjectStartupConfigurable.this.selectPathOrFirst(configuration);
                            }
                        }
                    }, project.getDisposed());
                }
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }
        };
    }

    private void selectAndAddConfiguration(final AnActionButton button) {
        ChooseRunConfigurationPopup.ItemWrapper[] allSettings;
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList<ChooseRunConfigurationPopup.ItemWrapper> wrappers = new ArrayList<ChooseRunConfigurationPopup.ItemWrapper>();
        wrappers.add(this.createEditWrapper());
        for (ChooseRunConfigurationPopup.ItemWrapper setting : allSettings = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, false)) {
            if (!(setting.getValue() instanceof RunnerAndConfigurationSettings) || ((RunnerAndConfigurationSettings)setting.getValue()).isTemporary()) continue;
            wrappers.add(setting);
        }
        final JBList list = new JBList(wrappers);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    this.setIcon(((ChooseRunConfigurationPopup.ItemWrapper)value).getIcon());
                    this.append(((ChooseRunConfigurationPopup.ItemWrapper)value).getText());
                }
            }
        });
        JBPopup popup = PopupFactoryImpl.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ChooseRunConfigurationPopup.ItemWrapper at = (ChooseRunConfigurationPopup.ItemWrapper)list.getModel().getElementAt(index);
                if (at.getValue() instanceof RunnerAndConfigurationSettings) {
                    RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)at.getValue();
                    ProjectStartupConfigurable.this.addConfigurationToList(added);
                    ProjectStartupConfigurable.this.selectPathOrFirst(added);
                } else {
                    at.perform(ProjectStartupConfigurable.this.myProject, executor, button.getDataContext());
                }
            }
        }).createPopup();
        popup.show(new RelativePoint((Component)this.myDecorator.getActionsPanel(), new Point(10, 10)));
    }

    private void addConfigurationToList(RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            ProjectStartupTasksTreeModel oldModel = (ProjectStartupTasksTreeModel)this.myTree.getModel();
            List<RunnerAndConfigurationSettings> configurations = oldModel.getConfigurations();
            if (!configurations.contains(settings)) {
                configurations.add(settings);
            }
            Collections.sort(configurations, new Comparator<RunnerAndConfigurationSettings>(){

                @Override
                public int compare(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            this.setModel(new ProjectStartupTasksTreeModel(configurations));
        }
    }

    public boolean isModified() {
        List<RunnerAndConfigurationSettings> current;
        if (this.mySharedCheckBox.isSelected() != this.myConfiguration.isShared()) {
            return true;
        }
        List<RunnerAndConfigurationSettings> recorded = this.myConfiguration.getStartupConfigurations();
        return !Comparing.equal(recorded, current = ((ProjectStartupTasksTreeModel)this.myTree.getModel()).getConfigurations());
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setStartupConfigurations(((ProjectStartupTasksTreeModel)this.myTree.getModel()).getConfigurations(), this.mySharedCheckBox.isSelected());
    }

    public void reset() {
        ProjectStartupTasksTreeModel model = new ProjectStartupTasksTreeModel(this.myConfiguration.getStartupConfigurations());
        this.setModel(model);
        this.mySharedCheckBox.setSelected(this.myConfiguration.isShared());
        this.mySharedCheckBox.setEnabled(this.myConfiguration.isShared() || this.myConfiguration.canBeShared());
        this.canBeSharedCheck(model);
        this.selectPathOrFirst(null);
    }

    private void setModel(ProjectStartupTasksTreeModel model) {
        this.myTree.setModel((TreeModel)model);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setRootVisible(false);
        this.canBeSharedCheck(model);
    }

    private void canBeSharedCheck(ProjectStartupTasksTreeModel model) {
        boolean canBeShared = true;
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        List<RunnerAndConfigurationSettings> configurations = model.getConfigurations();
        for (RunnerAndConfigurationSettings configuration : configurations) {
            if (runManager.isConfigurationShared(configuration)) continue;
            canBeShared = false;
            break;
        }
        this.mySharedCheckBox.setEnabled(canBeShared);
        if (!canBeShared) {
            this.mySharedCheckBox.setSelected(false);
        }
    }

    public void disposeUIResources() {
    }

    private void installRenderer() {
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/execution/startup/ProjectStartupConfigurable$10", "customizeCellRenderer"));
                }
                if (value instanceof RunnerAndConfigurationSettings) {
                    RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)value;
                    this.setIcon(settings.getConfiguration().getIcon());
                    this.append(settings.getName());
                }
            }
        });
    }
}

