/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.startup.ProjectStartupConfigurationBase;
import com.intellij.execution.startup.ProjectStartupLocalConfiguration;
import com.intellij.execution.startup.ProjectStartupSharedConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupConfiguration {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Project Startup Tasks Messages");
    @NonNls
    public static final String PREFIX = "Project Startup Tasks: ";
    private final Project myProject;
    private final ProjectStartupSharedConfiguration myShared;
    private final ProjectStartupLocalConfiguration myLocal;
    private final RunManagerEx myRunManager;
    private boolean myInitialized;

    public static ProjectStartupConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfiguration", "getInstance"));
        }
        return (ProjectStartupConfiguration)ServiceManager.getService((Project)project, ProjectStartupConfiguration.class);
    }

    public ProjectStartupConfiguration(Project project, ProjectStartupSharedConfiguration shared, ProjectStartupLocalConfiguration local, @NotNull RunManager runManager) {
        if (runManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/execution/startup/ProjectStartupConfiguration", "<init>"));
        }
        this.myProject = project;
        this.myShared = shared;
        this.myLocal = local;
        this.myRunManager = (RunManagerEx)runManager;
    }

    public List<RunnerAndConfigurationSettings> getStartupConfigurations() {
        ArrayList<RunnerAndConfigurationSettings> result = new ArrayList<RunnerAndConfigurationSettings>();
        if (!this.myShared.isEmpty()) {
            if (!this.myInitialized) {
                this.myLocal.shared();
                this.myInitialized = true;
            }
            this.myLocal.clear();
            return this.fillResult(result, this.myShared.getList(), true);
        }
        return this.fillResult(result, this.myLocal.getList(), false);
    }

    public void rename(String oldId, RunnerAndConfigurationSettings settings) {
        if (!this.myShared.isEmpty()) {
            ProjectStartupConfiguration.renameInStorage(oldId, settings, this.myShared);
        } else {
            ProjectStartupConfiguration.renameInStorage(oldId, settings, this.myLocal);
        }
    }

    private static void renameInStorage(String oldId, RunnerAndConfigurationSettings settings, ProjectStartupConfigurationBase configuration) {
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list = configuration.getList();
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor : list) {
            if (!descriptor.getId().equals(oldId)) continue;
            ArrayList<ProjectStartupConfigurationBase.ConfigurationDescriptor> newList = new ArrayList<ProjectStartupConfigurationBase.ConfigurationDescriptor>(list);
            newList.remove(descriptor);
            newList.add(new ProjectStartupConfigurationBase.ConfigurationDescriptor(settings.getUniqueID(), settings.getName()));
            configuration.setList(newList);
            return;
        }
    }

    public void delete(String name) {
        if (!this.myShared.isEmpty()) {
            ProjectStartupConfiguration.deleteInStorage(name, this.myShared);
        } else {
            ProjectStartupConfiguration.deleteInStorage(name, this.myLocal);
        }
    }

    private static void deleteInStorage(String name, ProjectStartupConfigurationBase configuration) {
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list = configuration.getList();
        Iterator<ProjectStartupConfigurationBase.ConfigurationDescriptor> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor = iterator.next();
            if (!descriptor.getName().equals(name)) continue;
            iterator.remove();
            return;
        }
    }

    private List<RunnerAndConfigurationSettings> fillResult(List<RunnerAndConfigurationSettings> result, List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list, boolean shared) {
        boolean changed = false;
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor : list) {
            RunnerAndConfigurationSettings settings = this.myRunManager.findConfigurationByName(descriptor.getName());
            if (settings != null) {
                result.add(settings);
                if (settings.getUniqueID().equals(descriptor.getId())) continue;
                changed = true;
                continue;
            }
            changed = true;
            NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  Run Configuration '" + descriptor.getName() + "' not found, removed from list.", MessageType.WARNING).notify(this.myProject);
        }
        if (changed) {
            this.setStartupConfigurations(result, shared);
        }
        return result;
    }

    public void setStartupConfigurations(@NotNull List<RunnerAndConfigurationSettings> list, boolean shared) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/startup/ProjectStartupConfiguration", "setStartupConfigurations"));
        }
        List names = ContainerUtil.map(list, (Function)new Function<RunnerAndConfigurationSettings, ProjectStartupConfigurationBase.ConfigurationDescriptor>(){

            public ProjectStartupConfigurationBase.ConfigurationDescriptor fun(RunnerAndConfigurationSettings settings) {
                return new ProjectStartupConfigurationBase.ConfigurationDescriptor(settings.getUniqueID(), settings.getName());
            }
        });
        if (shared) {
            this.myLocal.clear();
            this.myLocal.shared();
            this.myShared.setList(names);
        } else {
            this.myShared.clear();
            this.myLocal.setList(names);
            this.myLocal.local();
        }
    }

    public boolean canBeShared() {
        if (this.isShared()) {
            return true;
        }
        if (this.isEmpty()) {
            return true;
        }
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list = this.myLocal.getList();
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor : list) {
            RunnerAndConfigurationSettings settings = this.myRunManager.findConfigurationByName(descriptor.getName());
            if (settings == null || this.myRunManager.isConfigurationShared(settings)) continue;
            return false;
        }
        return true;
    }

    public boolean isShared() {
        return this.myLocal.isShared();
    }

    public boolean isEmpty() {
        return this.myShared.isEmpty() && this.myLocal.isEmpty();
    }

    public void checkOnChange(RunnerAndConfigurationSettings settings) {
        if (!this.isShared()) {
            return;
        }
        if (!this.myRunManager.isConfigurationShared(settings)) {
            this.myLocal.local();
            NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  configuration was made \"not shared\", since included Run Configuration '" + settings.getName() + "' is not shared.", MessageType.WARNING).notify(this.myProject);
        }
    }
}

