/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurationBase
implements PersistentStateComponent<Element> {
    protected static final String TOP_ELEMENT = "startup-tasks";
    private static final String TASK = "task";
    private static final String NAME = "name";
    private static final String ID = "id";
    private final List<ConfigurationDescriptor> myList = new ArrayList<ConfigurationDescriptor>();

    protected ProjectStartupConfigurationBase() {
    }

    @Nullable
    public Element getState() {
        if (this.myList.isEmpty()) {
            return null;
        }
        Element element = new Element(TOP_ELEMENT);
        for (ConfigurationDescriptor descriptor : this.myList) {
            Element child = new Element(TASK);
            child.setAttribute(NAME, descriptor.getName());
            child.setAttribute(ID, descriptor.getId());
            element.addContent(child);
        }
        return element;
    }

    public void loadState(Element state) {
        this.myList.clear();
        List children = state.getChildren();
        for (Element child : children) {
            if (!TASK.equals(child.getName())) continue;
            String name = child.getAttributeValue(NAME);
            String id = child.getAttributeValue(ID);
            if (StringUtil.isEmptyOrSpaces((String)name) || StringUtil.isEmptyOrSpaces((String)id)) continue;
            this.myList.add(new ConfigurationDescriptor(id, name));
        }
    }

    public void clear() {
        this.myList.clear();
    }

    public List<ConfigurationDescriptor> getList() {
        return this.myList;
    }

    public void setList(@NotNull List<ConfigurationDescriptor> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/startup/ProjectStartupConfigurationBase", "setList"));
        }
        this.myList.clear();
        this.myList.addAll(list);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public static class ConfigurationDescriptor {
        @NotNull
        private final String myId;
        @NotNull
        private final String myName;

        public ConfigurationDescriptor(@NotNull String id, @NotNull String name) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectStartupConfigurationBase.ID, "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ProjectStartupConfigurationBase.NAME, "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "<init>"));
            }
            this.myId = id;
            this.myName = name;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "getId"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurationBase$ConfigurationDescriptor", "getName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationDescriptor that = (ConfigurationDescriptor)o;
            if (!this.myId.equals(that.myId)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myId.hashCode();
            result = 31 * result + this.myName.hashCode();
            return result;
        }
    }
}

