/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupConfiguration;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.Alarm;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "runActivity"));
        }
        final ProjectStartupConfiguration projectStartupConfiguration = ProjectStartupConfiguration.getInstance(project);
        if (projectStartupConfiguration.isEmpty()) {
            return;
        }
        RunManagerImpl.getInstanceImpl(project).addRunManagerListener(new RunManagerAdapter(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationRemoved"));
                }
                projectStartupConfiguration.delete(settings.getName());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationChanged"));
                }
                if (existingId != null) {
                    projectStartupConfiguration.rename(existingId, settings);
                }
                projectStartupConfiguration.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationAdded"));
                }
                projectStartupConfiguration.checkOnChange(settings);
            }
        });
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        alarm.addRequest(this.createRequest(project, alarm), 200);
    }

    private Runnable createRequest(final Project project, final Alarm alarm) {
        return new Runnable(){

            @Override
            public void run() {
                if (!((StartupManagerEx)StartupManager.getInstance((Project)project)).postStartupActivityPassed()) {
                    alarm.addRequest(ProjectStartupRunner.this.createRequest(project, alarm), 200);
                } else {
                    ProjectStartupRunner.this.runActivities(project);
                }
            }
        };
    }

    private void runActivities(final Project project) {
        List<RunnerAndConfigurationSettings> configurations = ProjectStartupConfiguration.getInstance(project).getStartupConfigurations();
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (final RunnerAndConfigurationSettings configuration : configurations) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgramRunnerUtil.executeConfiguration(project, configuration, executor);
                    ProjectStartupConfiguration.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  started '" + configuration.getName() + "'", MessageType.INFO).notify(project);
                }
            }, ModalityState.any());
        }
    }
}

