/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;

public class Utils {
    private Utils() {
    }

    public static void showCompletionPopup(JComponent toolbarComponent, final JList list, String title, final JTextComponent textField, String ad) {
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                String selectedValue = (String)list.getSelectedValue();
                if (selectedValue != null) {
                    textField.setText(selectedValue);
                }
            }
        };
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
        if (title != null) {
            builder.setTitle(title);
        }
        JBPopup popup = builder.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
        if (ad != null) {
            popup.setAdText(ad, 2);
        }
        if (toolbarComponent != null) {
            popup.showUnderneathOf((Component)toolbarComponent);
        } else {
            popup.showUnderneathOf((Component)textField);
        }
    }

    public static void setSmallerFont(JComponent component) {
        if (SystemInfo.isMac) {
            component.setFont((Font)JBUI.Fonts.smallFont());
        }
    }

    public static void setSmallerFontForChildren(JComponent component) {
        for (Component c : component.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            Utils.setSmallerFont((JComponent)c);
        }
    }
}

