/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiActivityMonitorImpl
extends UiActivityMonitor
implements ModalityStateListener,
Disposable {
    private final FactoryMap<Project, BusyContainer> myObjects = new FactoryMap<Project, BusyContainer>(){

        protected BusyContainer create(Project key) {
            if (this.isEmpty()) {
                UiActivityMonitorImpl.this.installListener();
            }
            return key == null ? new BusyContainer(null) : new BusyContainer(null){

                @Override
                @NotNull
                protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key) {
                    if (key == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/UiActivityMonitorImpl$1$1", "createBusyImpl"));
                    }
                    BusyImpl busyImpl = new BusyImpl(key, this){

                        @Override
                        public boolean isReady() {
                            for (Map.Entry entry : UiActivityMonitorImpl.this.myObjects.entrySet()) {
                                BusyContainer eachContainer = (BusyContainer)entry.getValue();
                                BusyImpl busy = eachContainer.getOrCreateBusy(this.myToWatchArray);
                                if (busy == this || busy.isOwnReady()) continue;
                                return false;
                            }
                            return this.isOwnReady();
                        }
                    };
                    if (busyImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$1$1", "createBusyImpl"));
                    }
                    return busyImpl;
                }
            };
        }
    };
    private boolean myActive;
    @NotNull
    private final BusyObject myEmptyBusy = new BusyObject.Impl(){

        public boolean isReady() {
            return true;
        }
    };

    public void installListener() {
        LaterInvocator.addModalityStateListener(this, this);
    }

    public void dispose() {
        this.myObjects.clear();
    }

    public void beforeModalityStateChanged(boolean entering) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiActivityMonitorImpl.this.maybeReady();
            }
        });
    }

    public void maybeReady() {
        for (BusyContainer each : this.myObjects.values()) {
            each.onReady();
        }
    }

    @NotNull
    public BusyObject getBusy(@NotNull Project project, UiActivity ... toWatch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        if (toWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toWatch", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        if (!this.isActive()) {
            BusyObject busyObject = this.myEmptyBusy;
            if (busyObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
            }
            return busyObject;
        }
        BusyImpl busyImpl = this._getBusy(project, toWatch);
        if (busyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        return busyImpl;
    }

    @NotNull
    public BusyObject getBusy(UiActivity ... toWatch) {
        if (toWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toWatch", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        if (!this.isActive()) {
            BusyObject busyObject = this.myEmptyBusy;
            if (busyObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
            }
            return busyObject;
        }
        BusyImpl busyImpl = this._getBusy(null, toWatch);
        if (busyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusy"));
        }
        return busyImpl;
    }

    public void addActivity(@NotNull Project project, @NotNull UiActivity activity) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        this.addActivity(project, activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    public void addActivity(final @NotNull Project project, final @NotNull UiActivity activity, final @NotNull ModalityState effectiveModalityState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (effectiveModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveModalityState", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                UiActivityMonitorImpl.this.getBusyContainer(project).addActivity(activity, effectiveModalityState);
            }
        });
    }

    public void removeActivity(final @NotNull Project project, final @NotNull UiActivity activity) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                UiActivityMonitorImpl.this._getBusy(project, new UiActivity[0]).removeActivity(activity);
            }
        });
    }

    public void addActivity(@NotNull UiActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        this.addActivity(activity, UiActivityMonitorImpl.getDefaultModalityState());
    }

    private static ModalityState getDefaultModalityState() {
        return ApplicationManager.getApplication().getNoneModalityState();
    }

    public void addActivity(final @NotNull UiActivity activity, final @NotNull ModalityState effectiveModalityState) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (effectiveModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveModalityState", "com/intellij/ide/UiActivityMonitorImpl", "addActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                UiActivityMonitorImpl.this.getBusyContainer(null).addActivity(activity, effectiveModalityState);
            }
        });
    }

    public void removeActivity(final @NotNull UiActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl", "removeActivity"));
        }
        if (!this.isActive()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                UiActivityMonitorImpl.this._getBusy(null, new UiActivity[0]).removeActivity(activity);
            }
        });
    }

    @NotNull
    private BusyImpl _getBusy(@Nullable Project key, UiActivity ... toWatch) {
        if (toWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toWatch", "com/intellij/ide/UiActivityMonitorImpl", "_getBusy"));
        }
        BusyImpl busyImpl = this.getBusyContainer(key).getOrCreateBusy(toWatch);
        if (busyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "_getBusy"));
        }
        return busyImpl;
    }

    @NotNull
    private BusyContainer getBusyContainer(@Nullable Project key) {
        BusyContainer container = (BusyContainer)this.myObjects.get((Object)key);
        BusyContainer busyContainer = container != null ? container : this.getGlobalBusy();
        if (busyContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getBusyContainer"));
        }
        return busyContainer;
    }

    void initBusyObjectFor(@Nullable Project key) {
        this.myObjects.put((Object)key, (Object)new BusyContainer(key));
    }

    boolean hasObjectFor(Project project) {
        return this.myObjects.containsKey((Object)project);
    }

    private BusyContainer getGlobalBusy() {
        return (BusyContainer)this.myObjects.get(null);
    }

    public void clear() {
        Set keys = this.myObjects.keySet();
        for (Project each : keys) {
            ((BusyContainer)this.myObjects.get((Object)each)).clear();
        }
    }

    public void setActive(boolean active) {
        if (this.myActive == active) {
            return;
        }
        if (this.myActive) {
            this.clear();
        }
        this.myActive = active;
    }

    public boolean isActive() {
        return this.myActive;
    }

    @NotNull
    protected ModalityState getCurrentState() {
        ModalityState modalityState = ModalityState.current();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl", "getCurrentState"));
        }
        return modalityState;
    }

    public class BusyContainer
    implements Disposable {
        private final Map<Set<UiActivity>, BusyImpl> myActivities2Object = new HashMap<Set<UiActivity>, BusyImpl>();
        private final Map<BusyImpl, Set<UiActivity>> myObject2Activities = new HashMap<BusyImpl, Set<UiActivity>>();
        private final Set<UiActivity> myActivities = new HashSet<UiActivity>();
        private boolean myRemovingActivityNow;
        @Nullable
        private final Project myProject;

        public BusyContainer(Project project) {
            this.myProject = project;
            this.registerBusyObject(new HashSet<UiActivity>());
            if (project != null) {
                Disposer.register((Disposable)project, (Disposable)this);
            }
        }

        @NotNull
        public BusyImpl getOrCreateBusy(UiActivity ... activities) {
            if (activities == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "getOrCreateBusy"));
            }
            HashSet<UiActivity> key = new HashSet<UiActivity>();
            key.addAll(Arrays.asList(activities));
            if (this.myActivities2Object.containsKey(key)) {
                BusyImpl busyImpl = this.myActivities2Object.get(key);
                if (busyImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "getOrCreateBusy"));
                }
                return busyImpl;
            }
            BusyImpl busyImpl = this.registerBusyObject(key);
            if (busyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "getOrCreateBusy"));
            }
            return busyImpl;
        }

        @NotNull
        private BusyImpl registerBusyObject(@NotNull Set<UiActivity> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "registerBusyObject"));
            }
            BusyImpl busy = this.createBusyImpl(key);
            this.myActivities2Object.put(key, busy);
            this.myObject2Activities.put(busy, key);
            BusyImpl busyImpl = busy;
            if (busyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "registerBusyObject"));
            }
            return busyImpl;
        }

        @NotNull
        protected BusyImpl createBusyImpl(@NotNull Set<UiActivity> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "createBusyImpl"));
            }
            BusyImpl busyImpl = new BusyImpl(key, this);
            if (busyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "createBusyImpl"));
            }
            return busyImpl;
        }

        public void onReady() {
            Iterator<Set<UiActivity>> keyIterator = this.myActivities2Object.keySet().iterator();
            while (keyIterator.hasNext()) {
                Set<UiActivity> eachKey = keyIterator.next();
                BusyImpl busy = this.myActivities2Object.get(eachKey);
                busy.onReady();
                if (!busy.isReady()) continue;
                keyIterator.remove();
                this.myObject2Activities.remove((Object)busy);
            }
        }

        public void clear() {
            UiActivity[] activities;
            for (UiActivity each : activities = this.myActivities.toArray(new UiActivity[this.myActivities.size()])) {
                UiActivityMonitorImpl.this.removeActivity(each);
            }
        }

        public void onActivityAdded(@NotNull UiActivity activity) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "onActivityAdded"));
            }
            this.myActivities.add(activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onActivityRemoved(@NotNull BusyImpl busy, @NotNull UiActivity activity) {
            Set<UiActivity> activities;
            if (busy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "busy", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "onActivityRemoved"));
            }
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "onActivityRemoved"));
            }
            if (this.myRemovingActivityNow) {
                return;
            }
            HashMap<BusyImpl, Set<UiActivity>> toRemove = new HashMap<BusyImpl, Set<UiActivity>>();
            try {
                this.myRemovingActivityNow = true;
                this.myActivities.remove(activity);
                for (BusyImpl each : this.myObject2Activities.keySet()) {
                    if (each != busy) {
                        each.removeActivity(activity);
                    }
                    if (!each.isReady()) continue;
                    activities = this.myObject2Activities.get((Object)busy);
                    toRemove.put(busy, activities);
                }
            }
            catch (Throwable throwable) {
                for (BusyImpl each : toRemove.keySet()) {
                    Set<UiActivity> activities2 = this.myObject2Activities.remove((Object)each);
                    this.myActivities2Object.remove(activities2);
                }
                this.myRemovingActivityNow = false;
                throw throwable;
            }
            for (BusyImpl each : toRemove.keySet()) {
                activities = this.myObject2Activities.remove((Object)each);
                this.myActivities2Object.remove(activities);
            }
            this.myRemovingActivityNow = false;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState state) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "addActivity"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/UiActivityMonitorImpl$BusyContainer", "addActivity"));
            }
            this.getOrCreateBusy(activity);
            Set<BusyImpl> busies = this.myObject2Activities.keySet();
            for (BusyImpl each : busies) {
                each.addActivity(activity, state);
            }
        }

        public void dispose() {
            UiActivityMonitorImpl.this.myObjects.remove((Object)this.myProject);
        }
    }

    private class BusyImpl
    extends BusyObject.Impl {
        private final Map<UiActivity, ActivityInfo> myActivities;
        private final Set<UiActivity> myQueuedToRemove;
        protected final Set<UiActivity> myToWatch;
        protected final UiActivity[] myToWatchArray;
        private final BusyContainer myContainer;

        private BusyImpl(@NotNull Set<UiActivity> toWatch, BusyContainer container) {
            if (toWatch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toWatch", "com/intellij/ide/UiActivityMonitorImpl$BusyImpl", "<init>"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ide/UiActivityMonitorImpl$BusyImpl", "<init>"));
            }
            this.myActivities = new HashMap<UiActivity, ActivityInfo>();
            this.myQueuedToRemove = new HashSet<UiActivity>();
            this.myToWatch = toWatch;
            this.myToWatchArray = toWatch.toArray(new UiActivity[toWatch.size()]);
            this.myContainer = container;
        }

        public boolean isReady() {
            return this.isOwnReady() && UiActivityMonitorImpl.this.getGlobalBusy().getOrCreateBusy(this.myToWatchArray).isOwnReady();
        }

        boolean isOwnReady() {
            HashMap<UiActivity, ActivityInfo> infoToCheck = new HashMap<UiActivity, ActivityInfo>();
            for (Set eachActivitySet : this.myContainer.myActivities2Object.keySet()) {
                BusyImpl eachBusyObject = (BusyImpl)((Object)this.myContainer.myActivities2Object.get(eachActivitySet));
                if (eachBusyObject == this) continue;
                for (UiActivity eachOtherActivity : eachActivitySet) {
                    for (UiActivity eachToWatch : this.myToWatch) {
                        if (!eachToWatch.isSameOrGeneralFor(eachOtherActivity) || !eachBusyObject.myActivities.containsKey(eachOtherActivity)) continue;
                        infoToCheck.put(eachOtherActivity, eachBusyObject.myActivities.get(eachOtherActivity));
                    }
                }
            }
            infoToCheck.putAll(this.myActivities);
            if (infoToCheck.isEmpty()) {
                return true;
            }
            ModalityState current = UiActivityMonitorImpl.this.getCurrentState();
            for (Map.Entry entry : infoToCheck.entrySet()) {
                ActivityInfo info = (ActivityInfo)entry.getValue();
                if (current.dominates(info.getEffectiveState())) continue;
                return false;
            }
            return true;
        }

        public void addActivity(@NotNull UiActivity activity, @NotNull ModalityState effectiveModalityState) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl$BusyImpl", "addActivity"));
            }
            if (effectiveModalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveModalityState", "com/intellij/ide/UiActivityMonitorImpl$BusyImpl", "addActivity"));
            }
            if (!this.myToWatch.isEmpty() && !this.myToWatch.contains(activity)) {
                return;
            }
            this.myActivities.put(activity, new ActivityInfo(effectiveModalityState));
            this.myQueuedToRemove.remove(activity);
            this.myContainer.onActivityAdded(activity);
        }

        public void removeActivity(final @NotNull UiActivity activity) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/intellij/ide/UiActivityMonitorImpl$BusyImpl", "removeActivity"));
            }
            if (!this.myActivities.containsKey(activity)) {
                return;
            }
            this.myQueuedToRemove.add(activity);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!BusyImpl.this.myQueuedToRemove.contains(activity)) {
                        return;
                    }
                    BusyImpl.this.myQueuedToRemove.remove(activity);
                    BusyImpl.this.myActivities.remove(activity);
                    BusyImpl.this.myContainer.onActivityRemoved(BusyImpl.this, activity);
                    BusyImpl.this.onReady();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class ActivityInfo {
        private final ModalityState myEffectiveState;

        private ActivityInfo(@NotNull ModalityState effectiveState) {
            if (effectiveState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveState", "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo", "<init>"));
            }
            this.myEffectiveState = effectiveState;
        }

        @NotNull
        public ModalityState getEffectiveState() {
            ModalityState modalityState = this.myEffectiveState;
            if (modalityState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/UiActivityMonitorImpl$ActivityInfo", "getEffectiveState"));
            }
            return modalityState;
        }
    }
}

