/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseComponentsToExportDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ChooseComponentsToExportDialog.class);
    private final ElementsChooser<ComponentElementProperties> myChooser;
    private final FieldPanel myPathPanel;
    @NonNls
    public static final String DEFAULT_PATH = FileUtil.toSystemDependentName((String)(PathManager.getConfigPath() + "/" + "settings.jar"));
    private final boolean myShowFilePath;
    private final String myDescription;

    public ChooseComponentsToExportDialog(@NotNull MultiMap<File, ExportableComponent> fileToComponents, boolean showFilePath, String title, String description) {
        if (fileToComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToComponents", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "<init>"));
        }
        super(false);
        this.myDescription = description;
        this.myShowFilePath = showFilePath;
        LinkedHashMap<ExportableComponent, ComponentElementProperties> componentToContainingListElement = new LinkedHashMap<ExportableComponent, ComponentElementProperties>();
        for (ExportableComponent component : fileToComponents.values()) {
            if (ChooseComponentsToExportDialog.addToExistingListElement(component, componentToContainingListElement, fileToComponents)) continue;
            ComponentElementProperties componentElementProperties = new ComponentElementProperties();
            componentElementProperties.addComponent(component);
            componentToContainingListElement.put(component, componentElementProperties);
        }
        this.myChooser = new ElementsChooser(true);
        this.myChooser.setColorUnmarkedElements(false);
        for (ComponentElementProperties componentElementProperty : new LinkedHashSet(componentToContainingListElement.values())) {
            this.myChooser.addElement(componentElementProperty, true, (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.myChooser.sort(new Comparator<ComponentElementProperties>(){

            @Override
            public int compare(@NotNull ComponentElementProperties o1, @NotNull ComponentElementProperties o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/ide/actions/ChooseComponentsToExportDialog$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/ide/actions/ChooseComponentsToExportDialog$1", "compare"));
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        ActionListener browseAction = new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ChooseComponentsToExportDialog$2", "actionPerformed"));
                }
                ChooseComponentsToExportDialog.chooseSettingsFile(ChooseComponentsToExportDialog.this.myPathPanel.getText(), ChooseComponentsToExportDialog.this.getWindow(), IdeBundle.message((String)"title.export.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.export.settings.file.path", (Object[])new Object[0])).doWhenDone((Consumer)new Consumer<String>(){

                    public void consume(String path) {
                        ChooseComponentsToExportDialog.this.myPathPanel.setText(FileUtil.toSystemDependentName((String)path));
                    }
                });
            }
        };
        this.myPathPanel = new FieldPanel(IdeBundle.message((String)"editbox.export.settings.to", (Object[])new Object[0]), null, browseAction, null);
        String exportPath = PropertiesComponent.getInstance().getValue("export.settings.path", DEFAULT_PATH);
        this.myPathPanel.setText(exportPath);
        this.myPathPanel.setChangeListener(new Runnable(){

            @Override
            public void run() {
                ChooseComponentsToExportDialog.this.updateControls();
            }
        });
        this.updateControls();
        this.setTitle(title);
        this.init();
    }

    private void updateControls() {
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.myPathPanel.getText()));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction selectAll = new AbstractAction("Select &All"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ChooseComponentsToExportDialog$4", "actionPerformed"));
                }
                ChooseComponentsToExportDialog.this.myChooser.setAllElementsMarked(true);
            }
        };
        AbstractAction selectNone = new AbstractAction("Select &None"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ChooseComponentsToExportDialog$5", "actionPerformed"));
                }
                ChooseComponentsToExportDialog.this.myChooser.setAllElementsMarked(false);
            }
        };
        AbstractAction invert = new AbstractAction("&Invert"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ChooseComponentsToExportDialog$6", "actionPerformed"));
                }
                ChooseComponentsToExportDialog.this.myChooser.invertSelection();
            }
        };
        Action[] actionArray = new Action[]{selectAll, selectNone, invert};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.myPathPanel.getText(), DEFAULT_PATH);
        super.doOKAction();
    }

    private static boolean addToExistingListElement(@NotNull ExportableComponent component, @NotNull Map<ExportableComponent, ComponentElementProperties> componentToContainingListElement, @NotNull MultiMap<File, ExportableComponent> fileToComponents) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "addToExistingListElement"));
        }
        if (componentToContainingListElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentToContainingListElement", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "addToExistingListElement"));
        }
        if (fileToComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToComponents", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "addToExistingListElement"));
        }
        File file = null;
        for (File exportFile : component.getExportFiles()) {
            for (ExportableComponent tiedComponent : fileToComponents.get((Object)exportFile)) {
                ComponentElementProperties elementProperties;
                if (tiedComponent == component || (elementProperties = componentToContainingListElement.get(tiedComponent)) == null || FileUtil.filesEqual((File)exportFile, file)) continue;
                LOG.assertTrue(file == null, (Object)("Component " + component + " serialize itself into " + file + " and " + exportFile));
                elementProperties.addComponent(component);
                componentToContainingListElement.put(component, elementProperties);
                file = exportFile;
            }
        }
        return file != null;
    }

    @NotNull
    public static AsyncResult<String> chooseSettingsFile(String oldPath, Component parent, String title, String description) {
        VirtualFile initialDir;
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        chooserDescriptor.setDescription(description);
        chooserDescriptor.setHideIgnored(false);
        chooserDescriptor.setTitle(title);
        if (oldPath != null) {
            File oldFile = new File(oldPath);
            initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile);
            if (initialDir == null && oldFile.getParentFile() != null) {
                initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile.getParentFile());
            }
        } else {
            initialDir = null;
        }
        final AsyncResult result = new AsyncResult();
        FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, null, (Component)parent, (VirtualFile)initialDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> files) {
                VirtualFile file = files.get(0);
                if (file.isDirectory()) {
                    result.setDone((Object)(file.getPath() + '/' + new File(DEFAULT_PATH).getName()));
                } else {
                    result.setDone((Object)file.getPath());
                }
            }

            public void cancelled() {
                result.setRejected();
            }
        });
        AsyncResult asyncResult = result;
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ChooseComponentsToExportDialog", "chooseSettingsFile"));
        }
        return asyncResult;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPathPanel.getTextField();
    }

    protected JComponent createNorthPanel() {
        return new JLabel(this.myDescription);
    }

    protected JComponent createCenterPanel() {
        return this.myChooser;
    }

    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.myShowFilePath) {
            return buttons;
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)this.myPathPanel);
        panel.add(buttons);
        return panel;
    }

    Set<ExportableComponent> getExportableComponents() {
        THashSet components = new THashSet();
        for (ComponentElementProperties elementProperties : this.myChooser.getMarkedElements()) {
            components.addAll(elementProperties.myComponents);
        }
        return components;
    }

    File getExportFile() {
        return new File(this.myPathPanel.getText());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    private static class ComponentElementProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final Set<ExportableComponent> myComponents = new HashSet<ExportableComponent>();

        private ComponentElementProperties() {
        }

        private boolean addComponent(ExportableComponent component) {
            return this.myComponents.add(component);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        @Nullable
        public Color getColor() {
            return null;
        }

        public String toString() {
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            for (ExportableComponent component : this.myComponents) {
                names.add(component.getPresentableName());
            }
            return StringUtil.join((String[])names.toArray(new String[names.size()]), (String)", ");
        }
    }
}

